/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Quiet Time
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuietTime implements SdkPojo, Serializable, ToCopyableBuilder<QuietTime.Builder, QuietTime> {
    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QuietTime::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QuietTime::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_FIELD, START_FIELD));

    private static final long serialVersionUID = 1L;

    private final String end;

    private final String start;

    private QuietTime(BuilderImpl builder) {
        this.end = builder.end;
        this.start = builder.start;
    }

    /**
     * The time at which quiet time should end. The value that you specify has to be in HH:mm format, where HH is the
     * hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For example, use 02:30 to
     * represent 2:30 AM, or 14:30 to represent 2:30 PM.
     * 
     * @return The time at which quiet time should end. The value that you specify has to be in HH:mm format, where HH
     *         is the hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For example,
     *         use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.
     */
    public String end() {
        return end;
    }

    /**
     * The time at which quiet time should begin. The value that you specify has to be in HH:mm format, where HH is the
     * hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For example, use 02:30 to
     * represent 2:30 AM, or 14:30 to represent 2:30 PM.
     * 
     * @return The time at which quiet time should begin. The value that you specify has to be in HH:mm format, where HH
     *         is the hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For example,
     *         use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.
     */
    public String start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuietTime)) {
            return false;
        }
        QuietTime other = (QuietTime) obj;
        return Objects.equals(end(), other.end()) && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QuietTime").add("End", end()).add("Start", start()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuietTime, T> g) {
        return obj -> g.apply((QuietTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuietTime> {
        /**
         * The time at which quiet time should end. The value that you specify has to be in HH:mm format, where HH is
         * the hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For example, use
         * 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.
         * 
         * @param end
         *        The time at which quiet time should end. The value that you specify has to be in HH:mm format, where
         *        HH is the hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For
         *        example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * The time at which quiet time should begin. The value that you specify has to be in HH:mm format, where HH is
         * the hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For example, use
         * 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.
         * 
         * @param start
         *        The time at which quiet time should begin. The value that you specify has to be in HH:mm format, where
         *        HH is the hour in 24-hour format (with a leading zero, if applicable), and mm is the minutes. For
         *        example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);
    }

    static final class BuilderImpl implements Builder {
        private String end;

        private String start;

        private BuilderImpl() {
        }

        private BuilderImpl(QuietTime model) {
            end(model.end);
            start(model.start);
        }

        public final String getEnd() {
            return end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public QuietTime build() {
            return new QuietTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
