/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Message configuration for a campaign.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageConfiguration.Builder, MessageConfiguration> {
    private static final SdkField<Message> ADM_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .getter(getter(MessageConfiguration::admMessage)).setter(setter(Builder::admMessage)).constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADMMessage").build()).build();

    private static final SdkField<Message> APNS_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .getter(getter(MessageConfiguration::apnsMessage)).setter(setter(Builder::apnsMessage)).constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSMessage").build()).build();

    private static final SdkField<Message> BAIDU_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .getter(getter(MessageConfiguration::baiduMessage)).setter(setter(Builder::baiduMessage))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaiduMessage").build()).build();

    private static final SdkField<Message> DEFAULT_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .getter(getter(MessageConfiguration::defaultMessage)).setter(setter(Builder::defaultMessage))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessage").build()).build();

    private static final SdkField<CampaignEmailMessage> EMAIL_MESSAGE_FIELD = SdkField
            .<CampaignEmailMessage> builder(MarshallingType.SDK_POJO).getter(getter(MessageConfiguration::emailMessage))
            .setter(setter(Builder::emailMessage)).constructor(CampaignEmailMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<Message> GCM_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .getter(getter(MessageConfiguration::gcmMessage)).setter(setter(Builder::gcmMessage)).constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMMessage").build()).build();

    private static final SdkField<CampaignSmsMessage> SMS_MESSAGE_FIELD = SdkField
            .<CampaignSmsMessage> builder(MarshallingType.SDK_POJO).getter(getter(MessageConfiguration::smsMessage))
            .setter(setter(Builder::smsMessage)).constructor(CampaignSmsMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_MESSAGE_FIELD,
            APNS_MESSAGE_FIELD, BAIDU_MESSAGE_FIELD, DEFAULT_MESSAGE_FIELD, EMAIL_MESSAGE_FIELD, GCM_MESSAGE_FIELD,
            SMS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Message admMessage;

    private final Message apnsMessage;

    private final Message baiduMessage;

    private final Message defaultMessage;

    private final CampaignEmailMessage emailMessage;

    private final Message gcmMessage;

    private final CampaignSmsMessage smsMessage;

    private MessageConfiguration(BuilderImpl builder) {
        this.admMessage = builder.admMessage;
        this.apnsMessage = builder.apnsMessage;
        this.baiduMessage = builder.baiduMessage;
        this.defaultMessage = builder.defaultMessage;
        this.emailMessage = builder.emailMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
    }

    /**
     * The message that the campaign delivers to ADM channels. Overrides the default message.
     * 
     * @return The message that the campaign delivers to ADM channels. Overrides the default message.
     */
    public Message admMessage() {
        return admMessage;
    }

    /**
     * The message that the campaign delivers to APNS channels. Overrides the default message.
     * 
     * @return The message that the campaign delivers to APNS channels. Overrides the default message.
     */
    public Message apnsMessage() {
        return apnsMessage;
    }

    /**
     * The message that the campaign delivers to Baidu channels. Overrides the default message.
     * 
     * @return The message that the campaign delivers to Baidu channels. Overrides the default message.
     */
    public Message baiduMessage() {
        return baiduMessage;
    }

    /**
     * The default message for all channels.
     * 
     * @return The default message for all channels.
     */
    public Message defaultMessage() {
        return defaultMessage;
    }

    /**
     * The email message configuration.
     * 
     * @return The email message configuration.
     */
    public CampaignEmailMessage emailMessage() {
        return emailMessage;
    }

    /**
     * The message that the campaign delivers to GCM channels. Overrides the default message.
     * 
     * @return The message that the campaign delivers to GCM channels. Overrides the default message.
     */
    public Message gcmMessage() {
        return gcmMessage;
    }

    /**
     * The SMS message configuration.
     * 
     * @return The SMS message configuration.
     */
    public CampaignSmsMessage smsMessage() {
        return smsMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(admMessage());
        hashCode = 31 * hashCode + Objects.hashCode(apnsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(baiduMessage());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(gcmMessage());
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration) obj;
        return Objects.equals(admMessage(), other.admMessage()) && Objects.equals(apnsMessage(), other.apnsMessage())
                && Objects.equals(baiduMessage(), other.baiduMessage())
                && Objects.equals(defaultMessage(), other.defaultMessage())
                && Objects.equals(emailMessage(), other.emailMessage()) && Objects.equals(gcmMessage(), other.gcmMessage())
                && Objects.equals(smsMessage(), other.smsMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MessageConfiguration").add("ADMMessage", admMessage()).add("APNSMessage", apnsMessage())
                .add("BaiduMessage", baiduMessage()).add("DefaultMessage", defaultMessage()).add("EmailMessage", emailMessage())
                .add("GCMMessage", gcmMessage()).add("SMSMessage", smsMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ADMMessage":
            return Optional.ofNullable(clazz.cast(admMessage()));
        case "APNSMessage":
            return Optional.ofNullable(clazz.cast(apnsMessage()));
        case "BaiduMessage":
            return Optional.ofNullable(clazz.cast(baiduMessage()));
        case "DefaultMessage":
            return Optional.ofNullable(clazz.cast(defaultMessage()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "GCMMessage":
            return Optional.ofNullable(clazz.cast(gcmMessage()));
        case "SMSMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageConfiguration, T> g) {
        return obj -> g.apply((MessageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageConfiguration> {
        /**
         * The message that the campaign delivers to ADM channels. Overrides the default message.
         * 
         * @param admMessage
         *        The message that the campaign delivers to ADM channels. Overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admMessage(Message admMessage);

        /**
         * The message that the campaign delivers to ADM channels. Overrides the default message. This is a convenience
         * that creates an instance of the {@link Message.Builder} avoiding the need to create one manually via
         * {@link Message#builder()}.
         *
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #admMessage(Message)}.
         * 
         * @param admMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #admMessage(Message)
         */
        default Builder admMessage(Consumer<Message.Builder> admMessage) {
            return admMessage(Message.builder().applyMutation(admMessage).build());
        }

        /**
         * The message that the campaign delivers to APNS channels. Overrides the default message.
         * 
         * @param apnsMessage
         *        The message that the campaign delivers to APNS channels. Overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsMessage(Message apnsMessage);

        /**
         * The message that the campaign delivers to APNS channels. Overrides the default message. This is a convenience
         * that creates an instance of the {@link Message.Builder} avoiding the need to create one manually via
         * {@link Message#builder()}.
         *
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #apnsMessage(Message)}.
         * 
         * @param apnsMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsMessage(Message)
         */
        default Builder apnsMessage(Consumer<Message.Builder> apnsMessage) {
            return apnsMessage(Message.builder().applyMutation(apnsMessage).build());
        }

        /**
         * The message that the campaign delivers to Baidu channels. Overrides the default message.
         * 
         * @param baiduMessage
         *        The message that the campaign delivers to Baidu channels. Overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baiduMessage(Message baiduMessage);

        /**
         * The message that the campaign delivers to Baidu channels. Overrides the default message. This is a
         * convenience that creates an instance of the {@link Message.Builder} avoiding the need to create one manually
         * via {@link Message#builder()}.
         *
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #baiduMessage(Message)}.
         * 
         * @param baiduMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baiduMessage(Message)
         */
        default Builder baiduMessage(Consumer<Message.Builder> baiduMessage) {
            return baiduMessage(Message.builder().applyMutation(baiduMessage).build());
        }

        /**
         * The default message for all channels.
         * 
         * @param defaultMessage
         *        The default message for all channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMessage(Message defaultMessage);

        /**
         * The default message for all channels. This is a convenience that creates an instance of the
         * {@link Message.Builder} avoiding the need to create one manually via {@link Message#builder()}.
         *
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultMessage(Message)}.
         * 
         * @param defaultMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultMessage(Message)
         */
        default Builder defaultMessage(Consumer<Message.Builder> defaultMessage) {
            return defaultMessage(Message.builder().applyMutation(defaultMessage).build());
        }

        /**
         * The email message configuration.
         * 
         * @param emailMessage
         *        The email message configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(CampaignEmailMessage emailMessage);

        /**
         * The email message configuration. This is a convenience that creates an instance of the
         * {@link CampaignEmailMessage.Builder} avoiding the need to create one manually via
         * {@link CampaignEmailMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignEmailMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMessage(CampaignEmailMessage)}.
         * 
         * @param emailMessage
         *        a consumer that will call methods on {@link CampaignEmailMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessage(CampaignEmailMessage)
         */
        default Builder emailMessage(Consumer<CampaignEmailMessage.Builder> emailMessage) {
            return emailMessage(CampaignEmailMessage.builder().applyMutation(emailMessage).build());
        }

        /**
         * The message that the campaign delivers to GCM channels. Overrides the default message.
         * 
         * @param gcmMessage
         *        The message that the campaign delivers to GCM channels. Overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcmMessage(Message gcmMessage);

        /**
         * The message that the campaign delivers to GCM channels. Overrides the default message. This is a convenience
         * that creates an instance of the {@link Message.Builder} avoiding the need to create one manually via
         * {@link Message#builder()}.
         *
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #gcmMessage(Message)}.
         * 
         * @param gcmMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcmMessage(Message)
         */
        default Builder gcmMessage(Consumer<Message.Builder> gcmMessage) {
            return gcmMessage(Message.builder().applyMutation(gcmMessage).build());
        }

        /**
         * The SMS message configuration.
         * 
         * @param smsMessage
         *        The SMS message configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(CampaignSmsMessage smsMessage);

        /**
         * The SMS message configuration. This is a convenience that creates an instance of the
         * {@link CampaignSmsMessage.Builder} avoiding the need to create one manually via
         * {@link CampaignSmsMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignSmsMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMessage(CampaignSmsMessage)}.
         * 
         * @param smsMessage
         *        a consumer that will call methods on {@link CampaignSmsMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMessage(CampaignSmsMessage)
         */
        default Builder smsMessage(Consumer<CampaignSmsMessage.Builder> smsMessage) {
            return smsMessage(CampaignSmsMessage.builder().applyMutation(smsMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Message admMessage;

        private Message apnsMessage;

        private Message baiduMessage;

        private Message defaultMessage;

        private CampaignEmailMessage emailMessage;

        private Message gcmMessage;

        private CampaignSmsMessage smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageConfiguration model) {
            admMessage(model.admMessage);
            apnsMessage(model.apnsMessage);
            baiduMessage(model.baiduMessage);
            defaultMessage(model.defaultMessage);
            emailMessage(model.emailMessage);
            gcmMessage(model.gcmMessage);
            smsMessage(model.smsMessage);
        }

        public final Message.Builder getAdmMessage() {
            return admMessage != null ? admMessage.toBuilder() : null;
        }

        @Override
        public final Builder admMessage(Message admMessage) {
            this.admMessage = admMessage;
            return this;
        }

        public final void setAdmMessage(Message.BuilderImpl admMessage) {
            this.admMessage = admMessage != null ? admMessage.build() : null;
        }

        public final Message.Builder getApnsMessage() {
            return apnsMessage != null ? apnsMessage.toBuilder() : null;
        }

        @Override
        public final Builder apnsMessage(Message apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final void setApnsMessage(Message.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        public final Message.Builder getBaiduMessage() {
            return baiduMessage != null ? baiduMessage.toBuilder() : null;
        }

        @Override
        public final Builder baiduMessage(Message baiduMessage) {
            this.baiduMessage = baiduMessage;
            return this;
        }

        public final void setBaiduMessage(Message.BuilderImpl baiduMessage) {
            this.baiduMessage = baiduMessage != null ? baiduMessage.build() : null;
        }

        public final Message.Builder getDefaultMessage() {
            return defaultMessage != null ? defaultMessage.toBuilder() : null;
        }

        @Override
        public final Builder defaultMessage(Message defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final void setDefaultMessage(Message.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        public final CampaignEmailMessage.Builder getEmailMessage() {
            return emailMessage != null ? emailMessage.toBuilder() : null;
        }

        @Override
        public final Builder emailMessage(CampaignEmailMessage emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(CampaignEmailMessage.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        public final Message.Builder getGcmMessage() {
            return gcmMessage != null ? gcmMessage.toBuilder() : null;
        }

        @Override
        public final Builder gcmMessage(Message gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final void setGcmMessage(Message.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        public final CampaignSmsMessage.Builder getSmsMessage() {
            return smsMessage != null ? smsMessage.toBuilder() : null;
        }

        @Override
        public final Builder smsMessage(CampaignSmsMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSmsMessage(CampaignSmsMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        @Override
        public MessageConfiguration build() {
            return new MessageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
