/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Message to send
 */
@Generated("software.amazon.awssdk:codegen")
public final class Message implements SdkPojo, Serializable, ToCopyableBuilder<Message.Builder, Message> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::imageIconUrl)).setter(setter(Builder::imageIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()).build();

    private static final SdkField<String> IMAGE_SMALL_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::imageSmallIconUrl)).setter(setter(Builder::imageSmallIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSmallIconUrl").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<String> JSON_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::jsonBody)).setter(setter(Builder::jsonBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonBody").build()).build();

    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::mediaUrl)).setter(setter(Builder::mediaUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Message::silentPush)).setter(setter(Builder::silentPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Message::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Message::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD,
            IMAGE_ICON_URL_FIELD, IMAGE_SMALL_ICON_URL_FIELD, IMAGE_URL_FIELD, JSON_BODY_FIELD, MEDIA_URL_FIELD,
            RAW_CONTENT_FIELD, SILENT_PUSH_FIELD, TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String body;

    private final String imageIconUrl;

    private final String imageSmallIconUrl;

    private final String imageUrl;

    private final String jsonBody;

    private final String mediaUrl;

    private final String rawContent;

    private final Boolean silentPush;

    private final Integer timeToLive;

    private final String title;

    private final String url;

    private Message(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageSmallIconUrl = builder.imageSmallIconUrl;
        this.imageUrl = builder.imageUrl;
        this.jsonBody = builder.jsonBody;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     *
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app.
     *
     * URL - The default mobile browser on the user's device launches and opens a web page at the URL you specify.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action.
     *
     *         DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     *         interface within the app.
     *
     *         URL - The default mobile browser on the user's device launches and opens a web page at the URL you
     *         specify.
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     *
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app.
     *
     * URL - The default mobile browser on the user's device launches and opens a web page at the URL you specify.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action.
     *
     *         DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     *         interface within the app.
     *
     *         URL - The default mobile browser on the user's device launches and opens a web page at the URL you
     *         specify.
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * The message body. Can include up to 140 characters.
     * 
     * @return The message body. Can include up to 140 characters.
     */
    public String body() {
        return body;
    }

    /**
     * The URL that points to the icon image for the push notification icon, for example, the app icon.
     * 
     * @return The URL that points to the icon image for the push notification icon, for example, the app icon.
     */
    public String imageIconUrl() {
        return imageIconUrl;
    }

    /**
     * The URL that points to the small icon image for the push notification icon, for example, the app icon.
     * 
     * @return The URL that points to the small icon image for the push notification icon, for example, the app icon.
     */
    public String imageSmallIconUrl() {
        return imageSmallIconUrl;
    }

    /**
     * The URL that points to an image used in the push notification.
     * 
     * @return The URL that points to an image used in the push notification.
     */
    public String imageUrl() {
        return imageUrl;
    }

    /**
     * The JSON payload used for a silent push.
     * 
     * @return The JSON payload used for a silent push.
     */
    public String jsonBody() {
        return jsonBody;
    }

    /**
     * A URL that refers to the location of an image or video that you want to display in the push notification.
     * 
     * @return A URL that refers to the location of an image or video that you want to display in the push notification.
     */
    public String mediaUrl() {
        return mediaUrl;
    }

    /**
     * The Raw JSON formatted string to be used as the payload. This value overrides the message.
     * 
     * @return The Raw JSON formatted string to be used as the payload. This value overrides the message.
     */
    public String rawContent() {
        return rawContent;
    }

    /**
     * Indicates if the message should display on the users device.
     *
     * Silent pushes can be used for Remote Configuration and Phone Home use cases.
     * 
     * @return Indicates if the message should display on the users device.
     *
     *         Silent pushes can be used for Remote Configuration and Phone Home use cases.
     */
    public Boolean silentPush() {
        return silentPush;
    }

    /**
     * This parameter specifies how long (in seconds) the message should be kept if the service is unable to deliver the
     * notification the first time. If the value is 0, it treats the notification as if it expires immediately and does
     * not store the notification or attempt to redeliver it. This value is converted to the expiration field when sent
     * to the service. It only applies to APNs and GCM
     * 
     * @return This parameter specifies how long (in seconds) the message should be kept if the service is unable to
     *         deliver the notification the first time. If the value is 0, it treats the notification as if it expires
     *         immediately and does not store the notification or attempt to redeliver it. This value is converted to
     *         the expiration field when sent to the service. It only applies to APNs and GCM
     */
    public Integer timeToLive() {
        return timeToLive;
    }

    /**
     * The message title that displays above the message on the user's device.
     * 
     * @return The message title that displays above the message on the user's device.
     */
    public String title() {
        return title;
    }

    /**
     * The URL to open in the user's mobile browser. Used if the value for Action is URL.
     * 
     * @return The URL to open in the user's mobile browser. Used if the value for Action is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageSmallIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(jsonBody());
        hashCode = 31 * hashCode + Objects.hashCode(mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(body(), other.body())
                && Objects.equals(imageIconUrl(), other.imageIconUrl())
                && Objects.equals(imageSmallIconUrl(), other.imageSmallIconUrl()) && Objects.equals(imageUrl(), other.imageUrl())
                && Objects.equals(jsonBody(), other.jsonBody()) && Objects.equals(mediaUrl(), other.mediaUrl())
                && Objects.equals(rawContent(), other.rawContent()) && Objects.equals(silentPush(), other.silentPush())
                && Objects.equals(timeToLive(), other.timeToLive()) && Objects.equals(title(), other.title())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Message").add("Action", actionAsString()).add("Body", body())
                .add("ImageIconUrl", imageIconUrl()).add("ImageSmallIconUrl", imageSmallIconUrl()).add("ImageUrl", imageUrl())
                .add("JsonBody", jsonBody()).add("MediaUrl", mediaUrl()).add("RawContent", rawContent())
                .add("SilentPush", silentPush()).add("TimeToLive", timeToLive()).add("Title", title()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ImageIconUrl":
            return Optional.ofNullable(clazz.cast(imageIconUrl()));
        case "ImageSmallIconUrl":
            return Optional.ofNullable(clazz.cast(imageSmallIconUrl()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "JsonBody":
            return Optional.ofNullable(clazz.cast(jsonBody()));
        case "MediaUrl":
            return Optional.ofNullable(clazz.cast(mediaUrl()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "SilentPush":
            return Optional.ofNullable(clazz.cast(silentPush()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Message> {
        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         *
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app.
         *
         * URL - The default mobile browser on the user's device launches and opens a web page at the URL you specify.
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action.
         *
         *        DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated
         *        user interface within the app.
         *
         *        URL - The default mobile browser on the user's device launches and opens a web page at the URL you
         *        specify.
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         *
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app.
         *
         * URL - The default mobile browser on the user's device launches and opens a web page at the URL you specify.
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action.
         *
         *        DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated
         *        user interface within the app.
         *
         *        URL - The default mobile browser on the user's device launches and opens a web page at the URL you
         *        specify.
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * The message body. Can include up to 140 characters.
         * 
         * @param body
         *        The message body. Can include up to 140 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * The URL that points to the icon image for the push notification icon, for example, the app icon.
         * 
         * @param imageIconUrl
         *        The URL that points to the icon image for the push notification icon, for example, the app icon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIconUrl(String imageIconUrl);

        /**
         * The URL that points to the small icon image for the push notification icon, for example, the app icon.
         * 
         * @param imageSmallIconUrl
         *        The URL that points to the small icon image for the push notification icon, for example, the app icon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSmallIconUrl(String imageSmallIconUrl);

        /**
         * The URL that points to an image used in the push notification.
         * 
         * @param imageUrl
         *        The URL that points to an image used in the push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * The JSON payload used for a silent push.
         * 
         * @param jsonBody
         *        The JSON payload used for a silent push.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonBody(String jsonBody);

        /**
         * A URL that refers to the location of an image or video that you want to display in the push notification.
         * 
         * @param mediaUrl
         *        A URL that refers to the location of an image or video that you want to display in the push
         *        notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrl(String mediaUrl);

        /**
         * The Raw JSON formatted string to be used as the payload. This value overrides the message.
         * 
         * @param rawContent
         *        The Raw JSON formatted string to be used as the payload. This value overrides the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * Indicates if the message should display on the users device.
         *
         * Silent pushes can be used for Remote Configuration and Phone Home use cases.
         * 
         * @param silentPush
         *        Indicates if the message should display on the users device.
         *
         *        Silent pushes can be used for Remote Configuration and Phone Home use cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentPush(Boolean silentPush);

        /**
         * This parameter specifies how long (in seconds) the message should be kept if the service is unable to deliver
         * the notification the first time. If the value is 0, it treats the notification as if it expires immediately
         * and does not store the notification or attempt to redeliver it. This value is converted to the expiration
         * field when sent to the service. It only applies to APNs and GCM
         * 
         * @param timeToLive
         *        This parameter specifies how long (in seconds) the message should be kept if the service is unable to
         *        deliver the notification the first time. If the value is 0, it treats the notification as if it
         *        expires immediately and does not store the notification or attempt to redeliver it. This value is
         *        converted to the expiration field when sent to the service. It only applies to APNs and GCM
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * The message title that displays above the message on the user's device.
         * 
         * @param title
         *        The message title that displays above the message on the user's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * 
         * @param url
         *        The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String body;

        private String imageIconUrl;

        private String imageSmallIconUrl;

        private String imageUrl;

        private String jsonBody;

        private String mediaUrl;

        private String rawContent;

        private Boolean silentPush;

        private Integer timeToLive;

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            action(model.action);
            body(model.body);
            imageIconUrl(model.imageIconUrl);
            imageSmallIconUrl(model.imageSmallIconUrl);
            imageUrl(model.imageUrl);
            jsonBody(model.jsonBody);
            mediaUrl(model.mediaUrl);
            rawContent(model.rawContent);
            silentPush(model.silentPush);
            timeToLive(model.timeToLive);
            title(model.title);
            url(model.url);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getImageIconUrl() {
            return imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageSmallIconUrl() {
            return imageSmallIconUrl;
        }

        @Override
        public final Builder imageSmallIconUrl(String imageSmallIconUrl) {
            this.imageSmallIconUrl = imageSmallIconUrl;
            return this;
        }

        public final void setImageSmallIconUrl(String imageSmallIconUrl) {
            this.imageSmallIconUrl = imageSmallIconUrl;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getJsonBody() {
            return jsonBody;
        }

        @Override
        public final Builder jsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public final void setJsonBody(String jsonBody) {
            this.jsonBody = jsonBody;
        }

        public final String getMediaUrl() {
            return mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getRawContent() {
            return rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Message build() {
            return new Message(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
