/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCampaignVersionRequest extends PinpointRequest implements
        ToCopyableBuilder<GetCampaignVersionRequest.Builder, GetCampaignVersionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCampaignVersionRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCampaignVersionRequest::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("campaign-id").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCampaignVersionRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAMPAIGN_ID_FIELD, VERSION_FIELD));

    private final String applicationId;

    private final String campaignId;

    private final String version;

    private GetCampaignVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.version = builder.version;
    }

    /**
     * The unique ID of your Amazon Pinpoint application.
     * 
     * @return The unique ID of your Amazon Pinpoint application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The unique ID of the campaign.
     * 
     * @return The unique ID of the campaign.
     */
    public String campaignId() {
        return campaignId;
    }

    /**
     * The version of the campaign.
     * 
     * @return The version of the campaign.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignVersionRequest)) {
            return false;
        }
        GetCampaignVersionRequest other = (GetCampaignVersionRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(campaignId(), other.campaignId())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCampaignVersionRequest").add("ApplicationId", applicationId())
                .add("CampaignId", campaignId()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignVersionRequest, T> g) {
        return obj -> g.apply((GetCampaignVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCampaignVersionRequest> {
        /**
         * The unique ID of your Amazon Pinpoint application.
         * 
         * @param applicationId
         *        The unique ID of your Amazon Pinpoint application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The unique ID of the campaign.
         * 
         * @param campaignId
         *        The unique ID of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * The version of the campaign.
         * 
         * @param version
         *        The version of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String campaignId;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignVersionRequest model) {
            super(model);
            applicationId(model.applicationId);
            campaignId(model.campaignId);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCampaignVersionRequest build() {
            return new GetCampaignVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
