/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Export job resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJobResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportJobResource.Builder, ExportJobResource> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResource::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> S3_URL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResource::s3UrlPrefix)).setter(setter(Builder::s3UrlPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UrlPrefix").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResource::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExportJobResource::segmentVersion)).setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            S3_URL_PREFIX_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String s3UrlPrefix;

    private final String segmentId;

    private final Integer segmentVersion;

    private ExportJobResource(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.s3UrlPrefix = builder.s3UrlPrefix;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the Amazon S3 location that
     * endpoints will be exported to.
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the Amazon S3
     *         location that endpoints will be exported to.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * A URL that points to the location within an Amazon S3 bucket that will receive the export. The location is
     * typically a folder with multiple files.
     *
     * The URL should follow this format: s3://bucket-name/folder-name/
     *
     * Amazon Pinpoint will export endpoints to this location.
     * 
     * @return A URL that points to the location within an Amazon S3 bucket that will receive the export. The location
     *         is typically a folder with multiple files.
     *
     *         The URL should follow this format: s3://bucket-name/folder-name/
     *
     *         Amazon Pinpoint will export endpoints to this location.
     */
    public String s3UrlPrefix() {
        return s3UrlPrefix;
    }

    /**
     * The ID of the segment to export endpoints from. If not present, Amazon Pinpoint exports all of the endpoints that
     * belong to the application.
     * 
     * @return The ID of the segment to export endpoints from. If not present, Amazon Pinpoint exports all of the
     *         endpoints that belong to the application.
     */
    public String segmentId() {
        return segmentId;
    }

    /**
     * The version of the segment to export if specified.
     * 
     * @return The version of the segment to export if specified.
     */
    public Integer segmentVersion() {
        return segmentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3UrlPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobResource)) {
            return false;
        }
        ExportJobResource other = (ExportJobResource) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(s3UrlPrefix(), other.s3UrlPrefix())
                && Objects.equals(segmentId(), other.segmentId()) && Objects.equals(segmentVersion(), other.segmentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportJobResource").add("RoleArn", roleArn()).add("S3UrlPrefix", s3UrlPrefix())
                .add("SegmentId", segmentId()).add("SegmentVersion", segmentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "S3UrlPrefix":
            return Optional.ofNullable(clazz.cast(s3UrlPrefix()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJobResource, T> g) {
        return obj -> g.apply((ExportJobResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportJobResource> {
        /**
         * The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the Amazon S3 location
         * that endpoints will be exported to.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint access to the Amazon S3
         *        location that endpoints will be exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * A URL that points to the location within an Amazon S3 bucket that will receive the export. The location is
         * typically a folder with multiple files.
         *
         * The URL should follow this format: s3://bucket-name/folder-name/
         *
         * Amazon Pinpoint will export endpoints to this location.
         * 
         * @param s3UrlPrefix
         *        A URL that points to the location within an Amazon S3 bucket that will receive the export. The
         *        location is typically a folder with multiple files.
         *
         *        The URL should follow this format: s3://bucket-name/folder-name/
         *
         *        Amazon Pinpoint will export endpoints to this location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3UrlPrefix(String s3UrlPrefix);

        /**
         * The ID of the segment to export endpoints from. If not present, Amazon Pinpoint exports all of the endpoints
         * that belong to the application.
         * 
         * @param segmentId
         *        The ID of the segment to export endpoints from. If not present, Amazon Pinpoint exports all of the
         *        endpoints that belong to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * The version of the segment to export if specified.
         * 
         * @param segmentVersion
         *        The version of the segment to export if specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String s3UrlPrefix;

        private String segmentId;

        private Integer segmentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobResource model) {
            roleArn(model.roleArn);
            s3UrlPrefix(model.s3UrlPrefix);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3UrlPrefix() {
            return s3UrlPrefix;
        }

        @Override
        public final Builder s3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
            return this;
        }

        public final void setS3UrlPrefix(String s3UrlPrefix) {
            this.s3UrlPrefix = s3UrlPrefix;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        @Override
        public ExportJobResource build() {
            return new ExportJobResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
