/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Model for an event publishing subscription export.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventStream implements SdkPojo, Serializable, ToCopyableBuilder<EventStream.Builder, EventStream> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventStream::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> DESTINATION_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventStream::destinationStreamArn)).setter(setter(Builder::destinationStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStreamArn").build())
            .build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventStream::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventStream::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventStream::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventStream::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            DESTINATION_STREAM_ARN_FIELD, EXTERNAL_ID_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_UPDATED_BY_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String destinationStreamArn;

    private final String externalId;

    private final String lastModifiedDate;

    private final String lastUpdatedBy;

    private final String roleArn;

    private EventStream(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.destinationStreamArn = builder.destinationStreamArn;
        this.externalId = builder.externalId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.roleArn = builder.roleArn;
    }

    /**
     * The ID of the application from which events should be published.
     * 
     * @return The ID of the application from which events should be published.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to
     * publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME Kinesis ARN:
     * arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want
     *         to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME Kinesis
     *         ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
     */
    public String destinationStreamArn() {
        return destinationStreamArn;
    }

    /**
     * (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy. Used by Amazon
     * Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not recommended for IAM roles
     * assumed by Amazon Pinpoint.
     * 
     * @return (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy. Used
     *         by Amazon Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not
     *         recommended for IAM roles assumed by Amazon Pinpoint.
     */
    public String externalId() {
        return externalId;
    }

    /**
     * The date the event stream was last updated in ISO 8601 format.
     * 
     * @return The date the event stream was last updated in ISO 8601 format.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * The IAM user who last modified the event stream.
     * 
     * @return The IAM user who last modified the event stream.
     */
    public String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     * 
     * @return The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStream)) {
            return false;
        }
        EventStream other = (EventStream) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(destinationStreamArn(), other.destinationStreamArn())
                && Objects.equals(externalId(), other.externalId())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventStream").add("ApplicationId", applicationId())
                .add("DestinationStreamArn", destinationStreamArn()).add("ExternalId", externalId())
                .add("LastModifiedDate", lastModifiedDate()).add("LastUpdatedBy", lastUpdatedBy()).add("RoleArn", roleArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "DestinationStreamArn":
            return Optional.ofNullable(clazz.cast(destinationStreamArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventStream, T> g) {
        return obj -> g.apply((EventStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventStream> {
        /**
         * The ID of the application from which events should be published.
         * 
         * @param applicationId
         *        The ID of the application from which events should be published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you want to
         * publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME Kinesis ARN:
         * arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
         * 
         * @param destinationStreamArn
         *        The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery stream to which you
         *        want to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME
         *        Kinesis ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStreamArn(String destinationStreamArn);

        /**
         * (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy. Used by
         * Amazon Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not recommended for
         * IAM roles assumed by Amazon Pinpoint.
         * 
         * @param externalId
         *        (Deprecated) Your AWS account ID, which you assigned to the ExternalID key in an IAM trust policy.
         *        Used by Amazon Pinpoint to assume an IAM role. This requirement is removed, and external IDs are not
         *        recommended for IAM roles assumed by Amazon Pinpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * The date the event stream was last updated in ISO 8601 format.
         * 
         * @param lastModifiedDate
         *        The date the event stream was last updated in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * The IAM user who last modified the event stream.
         * 
         * @param lastUpdatedBy
         *        The IAM user who last modified the event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
         * 
         * @param roleArn
         *        The IAM role that authorizes Amazon Pinpoint to publish events to the stream in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String destinationStreamArn;

        private String externalId;

        private String lastModifiedDate;

        private String lastUpdatedBy;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventStream model) {
            applicationId(model.applicationId);
            destinationStreamArn(model.destinationStreamArn);
            externalId(model.externalId);
            lastModifiedDate(model.lastModifiedDate);
            lastUpdatedBy(model.lastUpdatedBy);
            roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getDestinationStreamArn() {
            return destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public EventStream build() {
            return new EventStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
