/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Model for creating or updating events.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<String> APP_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::appPackageName)).setter(setter(Builder::appPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppPackageName").build()).build();

    private static final SdkField<String> APP_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::appTitle)).setter(setter(Builder::appTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppTitle").build()).build();

    private static final SdkField<String> APP_VERSION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::appVersionCode)).setter(setter(Builder::appVersionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVersionCode").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Event::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_SDK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::clientSdkVersion)).setter(setter(Builder::clientSdkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSdkVersion").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<Map<String, Double>> METRICS_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .getter(getter(Event::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SDK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::sdkName)).setter(setter(Builder::sdkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SdkName").build()).build();

    private static final SdkField<Session> SESSION_FIELD = SdkField.<Session> builder(MarshallingType.SDK_POJO)
            .getter(getter(Event::session)).setter(setter(Builder::session)).constructor(Session::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Event::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_PACKAGE_NAME_FIELD,
            APP_TITLE_FIELD, APP_VERSION_CODE_FIELD, ATTRIBUTES_FIELD, CLIENT_SDK_VERSION_FIELD, EVENT_TYPE_FIELD, METRICS_FIELD,
            SDK_NAME_FIELD, SESSION_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appPackageName;

    private final String appTitle;

    private final String appVersionCode;

    private final Map<String, String> attributes;

    private final String clientSdkVersion;

    private final String eventType;

    private final Map<String, Double> metrics;

    private final String sdkName;

    private final Session session;

    private final String timestamp;

    private Event(BuilderImpl builder) {
        this.appPackageName = builder.appPackageName;
        this.appTitle = builder.appTitle;
        this.appVersionCode = builder.appVersionCode;
        this.attributes = builder.attributes;
        this.clientSdkVersion = builder.clientSdkVersion;
        this.eventType = builder.eventType;
        this.metrics = builder.metrics;
        this.sdkName = builder.sdkName;
        this.session = builder.session;
        this.timestamp = builder.timestamp;
    }

    /**
     * The package name associated with the app that's recording the event.
     * 
     * @return The package name associated with the app that's recording the event.
     */
    public String appPackageName() {
        return appPackageName;
    }

    /**
     * The title of the app that's recording the event.
     * 
     * @return The title of the app that's recording the event.
     */
    public String appTitle() {
        return appTitle;
    }

    /**
     * The version number of the app that's recording the event.
     * 
     * @return The version number of the app that's recording the event.
     */
    public String appVersionCode() {
        return appVersionCode;
    }

    /**
     * Custom attributes that are associated with the event you're adding or updating.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Custom attributes that are associated with the event you're adding or updating.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * The version of the SDK that's running on the client device.
     * 
     * @return The version of the SDK that's running on the client device.
     */
    public String clientSdkVersion() {
        return clientSdkVersion;
    }

    /**
     * The name of the custom event that you're recording.
     * 
     * @return The name of the custom event that you're recording.
     */
    public String eventType() {
        return eventType;
    }

    /**
     * Custom metrics related to the event.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Custom metrics related to the event.
     */
    public Map<String, Double> metrics() {
        return metrics;
    }

    /**
     * The name of the SDK that's being used to record the event.
     * 
     * @return The name of the SDK that's being used to record the event.
     */
    public String sdkName() {
        return sdkName;
    }

    /**
     * Information about the session in which the event occurred.
     * 
     * @return Information about the session in which the event occurred.
     */
    public Session session() {
        return session;
    }

    /**
     * The date and time when the event occurred, in ISO 8601 format.
     * 
     * @return The date and time when the event occurred, in ISO 8601 format.
     */
    public String timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(appTitle());
        hashCode = 31 * hashCode + Objects.hashCode(appVersionCode());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(clientSdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(sdkName());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(appPackageName(), other.appPackageName()) && Objects.equals(appTitle(), other.appTitle())
                && Objects.equals(appVersionCode(), other.appVersionCode()) && Objects.equals(attributes(), other.attributes())
                && Objects.equals(clientSdkVersion(), other.clientSdkVersion()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(sdkName(), other.sdkName())
                && Objects.equals(session(), other.session()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Event").add("AppPackageName", appPackageName()).add("AppTitle", appTitle())
                .add("AppVersionCode", appVersionCode()).add("Attributes", attributes())
                .add("ClientSdkVersion", clientSdkVersion()).add("EventType", eventType()).add("Metrics", metrics())
                .add("SdkName", sdkName()).add("Session", session()).add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppPackageName":
            return Optional.ofNullable(clazz.cast(appPackageName()));
        case "AppTitle":
            return Optional.ofNullable(clazz.cast(appTitle()));
        case "AppVersionCode":
            return Optional.ofNullable(clazz.cast(appVersionCode()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ClientSdkVersion":
            return Optional.ofNullable(clazz.cast(clientSdkVersion()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "SdkName":
            return Optional.ofNullable(clazz.cast(sdkName()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * The package name associated with the app that's recording the event.
         * 
         * @param appPackageName
         *        The package name associated with the app that's recording the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appPackageName(String appPackageName);

        /**
         * The title of the app that's recording the event.
         * 
         * @param appTitle
         *        The title of the app that's recording the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appTitle(String appTitle);

        /**
         * The version number of the app that's recording the event.
         * 
         * @param appVersionCode
         *        The version number of the app that's recording the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersionCode(String appVersionCode);

        /**
         * Custom attributes that are associated with the event you're adding or updating.
         * 
         * @param attributes
         *        Custom attributes that are associated with the event you're adding or updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * The version of the SDK that's running on the client device.
         * 
         * @param clientSdkVersion
         *        The version of the SDK that's running on the client device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSdkVersion(String clientSdkVersion);

        /**
         * The name of the custom event that you're recording.
         * 
         * @param eventType
         *        The name of the custom event that you're recording.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * Custom metrics related to the event.
         * 
         * @param metrics
         *        Custom metrics related to the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, Double> metrics);

        /**
         * The name of the SDK that's being used to record the event.
         * 
         * @param sdkName
         *        The name of the SDK that's being used to record the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdkName(String sdkName);

        /**
         * Information about the session in which the event occurred.
         * 
         * @param session
         *        Information about the session in which the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(Session session);

        /**
         * Information about the session in which the event occurred. This is a convenience that creates an instance of
         * the {@link Session.Builder} avoiding the need to create one manually via {@link Session#builder()}.
         *
         * When the {@link Consumer} completes, {@link Session.Builder#build()} is called immediately and its result is
         * passed to {@link #session(Session)}.
         * 
         * @param session
         *        a consumer that will call methods on {@link Session.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #session(Session)
         */
        default Builder session(Consumer<Session.Builder> session) {
            return session(Session.builder().applyMutation(session).build());
        }

        /**
         * The date and time when the event occurred, in ISO 8601 format.
         * 
         * @param timestamp
         *        The date and time when the event occurred, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String appPackageName;

        private String appTitle;

        private String appVersionCode;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String clientSdkVersion;

        private String eventType;

        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();

        private String sdkName;

        private Session session;

        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            appPackageName(model.appPackageName);
            appTitle(model.appTitle);
            appVersionCode(model.appVersionCode);
            attributes(model.attributes);
            clientSdkVersion(model.clientSdkVersion);
            eventType(model.eventType);
            metrics(model.metrics);
            sdkName(model.sdkName);
            session(model.session);
            timestamp(model.timestamp);
        }

        public final String getAppPackageName() {
            return appPackageName;
        }

        @Override
        public final Builder appPackageName(String appPackageName) {
            this.appPackageName = appPackageName;
            return this;
        }

        public final void setAppPackageName(String appPackageName) {
            this.appPackageName = appPackageName;
        }

        public final String getAppTitle() {
            return appTitle;
        }

        @Override
        public final Builder appTitle(String appTitle) {
            this.appTitle = appTitle;
            return this;
        }

        public final void setAppTitle(String appTitle) {
            this.appTitle = appTitle;
        }

        public final String getAppVersionCode() {
            return appVersionCode;
        }

        @Override
        public final Builder appVersionCode(String appVersionCode) {
            this.appVersionCode = appVersionCode;
            return this;
        }

        public final void setAppVersionCode(String appVersionCode) {
            this.appVersionCode = appVersionCode;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        public final String getClientSdkVersion() {
            return clientSdkVersion;
        }

        @Override
        public final Builder clientSdkVersion(String clientSdkVersion) {
            this.clientSdkVersion = clientSdkVersion;
            return this;
        }

        public final void setClientSdkVersion(String clientSdkVersion) {
            this.clientSdkVersion = clientSdkVersion;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Map<String, Double> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        public final String getSdkName() {
            return sdkName;
        }

        @Override
        public final Builder sdkName(String sdkName) {
            this.sdkName = sdkName;
            return this;
        }

        public final void setSdkName(String sdkName) {
            this.sdkName = sdkName;
        }

        public final Session.Builder getSession() {
            return session != null ? session.toBuilder() : null;
        }

        @Override
        public final Builder session(Session session) {
            this.session = session;
            return this;
        }

        public final void setSession(Session.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
