/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Email Channel Response.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailChannelResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailChannelResponse.Builder, EmailChannelResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::configurationSet)).setter(setter(Builder::configurationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EmailChannelResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<Boolean> HAS_CREDENTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EmailChannelResponse::hasCredential)).setter(setter(Builder::hasCredential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasCredential").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::identity)).setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()).build();

    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EmailChannelResponse::isArchived)).setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsArchived").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Integer> MESSAGES_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EmailChannelResponse::messagesPerSecond)).setter(setter(Builder::messagesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesPerSecond").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailChannelResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EmailChannelResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_SET_FIELD, CREATION_DATE_FIELD, ENABLED_FIELD, FROM_ADDRESS_FIELD, HAS_CREDENTIAL_FIELD, ID_FIELD,
            IDENTITY_FIELD, IS_ARCHIVED_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, MESSAGES_PER_SECOND_FIELD,
            PLATFORM_FIELD, ROLE_ARN_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String configurationSet;

    private final String creationDate;

    private final Boolean enabled;

    private final String fromAddress;

    private final Boolean hasCredential;

    private final String id;

    private final String identity;

    private final Boolean isArchived;

    private final String lastModifiedBy;

    private final String lastModifiedDate;

    private final Integer messagesPerSecond;

    private final String platform;

    private final String roleArn;

    private final Integer version;

    private EmailChannelResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.configurationSet = builder.configurationSet;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.hasCredential = builder.hasCredential;
        this.id = builder.id;
        this.identity = builder.identity;
        this.isArchived = builder.isArchived;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.messagesPerSecond = builder.messagesPerSecond;
        this.platform = builder.platform;
        this.roleArn = builder.roleArn;
        this.version = builder.version;
    }

    /**
     * The unique ID of the application to which the email channel belongs.
     * 
     * @return The unique ID of the application to which the email channel belongs.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The configuration set that you want to use when you send email using the Pinpoint Email API.
     * 
     * @return The configuration set that you want to use when you send email using the Pinpoint Email API.
     */
    public String configurationSet() {
        return configurationSet;
    }

    /**
     * The date that the settings were last updated in ISO 8601 format.
     * 
     * @return The date that the settings were last updated in ISO 8601 format.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * If the channel is enabled for sending messages.
     * 
     * @return If the channel is enabled for sending messages.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * The email address used to send emails from.
     * 
     * @return The email address used to send emails from.
     */
    public String fromAddress() {
        return fromAddress;
    }

    /**
     * Not used. Retained for backwards compatibility.
     * 
     * @return Not used. Retained for backwards compatibility.
     */
    public Boolean hasCredential() {
        return hasCredential;
    }

    /**
     * Channel ID. Not used, only for backwards compatibility.
     * 
     * @return Channel ID. Not used, only for backwards compatibility.
     */
    public String id() {
        return id;
    }

    /**
     * The ARN of an identity verified with SES.
     * 
     * @return The ARN of an identity verified with SES.
     */
    public String identity() {
        return identity;
    }

    /**
     * Is this channel archived
     * 
     * @return Is this channel archived
     */
    public Boolean isArchived() {
        return isArchived;
    }

    /**
     * Who last updated this entry
     * 
     * @return Who last updated this entry
     */
    public String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Last date this was updated
     * 
     * @return Last date this was updated
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * Messages per second that can be sent
     * 
     * @return Messages per second that can be sent
     */
    public Integer messagesPerSecond() {
        return messagesPerSecond;
    }

    /**
     * Platform type. Will be "EMAIL"
     * 
     * @return Platform type. Will be "EMAIL"
     */
    public String platform() {
        return platform;
    }

    /**
     * The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service
     * 
     * @return The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Version of channel
     * 
     * @return Version of channel
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredential());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(messagesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelResponse)) {
            return false;
        }
        EmailChannelResponse other = (EmailChannelResponse) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationSet(), other.configurationSet())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(fromAddress(), other.fromAddress()) && Objects.equals(hasCredential(), other.hasCredential())
                && Objects.equals(id(), other.id()) && Objects.equals(identity(), other.identity())
                && Objects.equals(isArchived(), other.isArchived()) && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(messagesPerSecond(), other.messagesPerSecond()) && Objects.equals(platform(), other.platform())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EmailChannelResponse").add("ApplicationId", applicationId())
                .add("ConfigurationSet", configurationSet()).add("CreationDate", creationDate()).add("Enabled", enabled())
                .add("FromAddress", fromAddress()).add("HasCredential", hasCredential()).add("Id", id())
                .add("Identity", identity()).add("IsArchived", isArchived()).add("LastModifiedBy", lastModifiedBy())
                .add("LastModifiedDate", lastModifiedDate()).add("MessagesPerSecond", messagesPerSecond())
                .add("Platform", platform()).add("RoleArn", roleArn()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationSet":
            return Optional.ofNullable(clazz.cast(configurationSet()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "HasCredential":
            return Optional.ofNullable(clazz.cast(hasCredential()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "IsArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "MessagesPerSecond":
            return Optional.ofNullable(clazz.cast(messagesPerSecond()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailChannelResponse, T> g) {
        return obj -> g.apply((EmailChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailChannelResponse> {
        /**
         * The unique ID of the application to which the email channel belongs.
         * 
         * @param applicationId
         *        The unique ID of the application to which the email channel belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The configuration set that you want to use when you send email using the Pinpoint Email API.
         * 
         * @param configurationSet
         *        The configuration set that you want to use when you send email using the Pinpoint Email API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(String configurationSet);

        /**
         * The date that the settings were last updated in ISO 8601 format.
         * 
         * @param creationDate
         *        The date that the settings were last updated in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * If the channel is enabled for sending messages.
         * 
         * @param enabled
         *        If the channel is enabled for sending messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * The email address used to send emails from.
         * 
         * @param fromAddress
         *        The email address used to send emails from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * Not used. Retained for backwards compatibility.
         * 
         * @param hasCredential
         *        Not used. Retained for backwards compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasCredential(Boolean hasCredential);

        /**
         * Channel ID. Not used, only for backwards compatibility.
         * 
         * @param id
         *        Channel ID. Not used, only for backwards compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ARN of an identity verified with SES.
         * 
         * @param identity
         *        The ARN of an identity verified with SES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * Is this channel archived
         * 
         * @param isArchived
         *        Is this channel archived
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * Who last updated this entry
         * 
         * @param lastModifiedBy
         *        Who last updated this entry
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * Last date this was updated
         * 
         * @param lastModifiedDate
         *        Last date this was updated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * Messages per second that can be sent
         * 
         * @param messagesPerSecond
         *        Messages per second that can be sent
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagesPerSecond(Integer messagesPerSecond);

        /**
         * Platform type. Will be "EMAIL"
         * 
         * @param platform
         *        Platform type. Will be "EMAIL"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service
         * 
         * @param roleArn
         *        The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion service
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Version of channel
         * 
         * @param version
         *        Version of channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String configurationSet;

        private String creationDate;

        private Boolean enabled;

        private String fromAddress;

        private Boolean hasCredential;

        private String id;

        private String identity;

        private Boolean isArchived;

        private String lastModifiedBy;

        private String lastModifiedDate;

        private Integer messagesPerSecond;

        private String platform;

        private String roleArn;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelResponse model) {
            applicationId(model.applicationId);
            configurationSet(model.configurationSet);
            creationDate(model.creationDate);
            enabled(model.enabled);
            fromAddress(model.fromAddress);
            hasCredential(model.hasCredential);
            id(model.id);
            identity(model.identity);
            isArchived(model.isArchived);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            messagesPerSecond(model.messagesPerSecond);
            platform(model.platform);
            roleArn(model.roleArn);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getConfigurationSet() {
            return configurationSet;
        }

        @Override
        public final Builder configurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final Boolean getHasCredential() {
            return hasCredential;
        }

        @Override
        public final Builder hasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
            return this;
        }

        public final void setHasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getMessagesPerSecond() {
            return messagesPerSecond;
        }

        @Override
        public final Builder messagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
            return this;
        }

        public final void setMessagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public EmailChannelResponse build() {
            return new EmailChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
