/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExportJobRequest extends PinpointRequest implements
        ToCopyableBuilder<CreateExportJobRequest.Builder, CreateExportJobRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateExportJobRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<ExportJobRequest> EXPORT_JOB_REQUEST_FIELD = SdkField
            .<ExportJobRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateExportJobRequest::exportJobRequest))
            .setter(setter(Builder::exportJobRequest))
            .constructor(ExportJobRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            EXPORT_JOB_REQUEST_FIELD));

    private final String applicationId;

    private final ExportJobRequest exportJobRequest;

    private CreateExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.exportJobRequest = builder.exportJobRequest;
    }

    /**
     * The unique ID of your Amazon Pinpoint application.
     * 
     * @return The unique ID of your Amazon Pinpoint application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the ExportJobRequest property for this object.
     * 
     * @return The value of the ExportJobRequest property for this object.
     */
    public ExportJobRequest exportJobRequest() {
        return exportJobRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(exportJobRequest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportJobRequest)) {
            return false;
        }
        CreateExportJobRequest other = (CreateExportJobRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(exportJobRequest(), other.exportJobRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateExportJobRequest").add("ApplicationId", applicationId())
                .add("ExportJobRequest", exportJobRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ExportJobRequest":
            return Optional.ofNullable(clazz.cast(exportJobRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExportJobRequest, T> g) {
        return obj -> g.apply((CreateExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExportJobRequest> {
        /**
         * The unique ID of your Amazon Pinpoint application.
         * 
         * @param applicationId
         *        The unique ID of your Amazon Pinpoint application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the ExportJobRequest property for this object.
         *
         * @param exportJobRequest
         *        The new value for the ExportJobRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobRequest(ExportJobRequest exportJobRequest);

        /**
         * Sets the value of the ExportJobRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExportJobRequest.Builder} avoiding the need to
         * create one manually via {@link ExportJobRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportJobRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #exportJobRequest(ExportJobRequest)}.
         * 
         * @param exportJobRequest
         *        a consumer that will call methods on {@link ExportJobRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportJobRequest(ExportJobRequest)
         */
        default Builder exportJobRequest(Consumer<ExportJobRequest.Builder> exportJobRequest) {
            return exportJobRequest(ExportJobRequest.builder().applyMutation(exportJobRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private ExportJobRequest exportJobRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportJobRequest model) {
            super(model);
            applicationId(model.applicationId);
            exportJobRequest(model.exportJobRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final ExportJobRequest.Builder getExportJobRequest() {
            return exportJobRequest != null ? exportJobRequest.toBuilder() : null;
        }

        @Override
        public final Builder exportJobRequest(ExportJobRequest exportJobRequest) {
            this.exportJobRequest = exportJobRequest;
            return this;
        }

        public final void setExportJobRequest(ExportJobRequest.BuilderImpl exportJobRequest) {
            this.exportJobRequest = exportJobRequest != null ? exportJobRequest.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportJobRequest build() {
            return new CreateExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
