/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * State of the Campaign
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignState implements SdkPojo, Serializable, ToCopyableBuilder<CampaignState.Builder, CampaignState> {
    private static final SdkField<String> CAMPAIGN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignState::campaignStatusAsString)).setter(setter(Builder::campaignStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String campaignStatus;

    private CampaignState(BuilderImpl builder) {
        this.campaignStatus = builder.campaignStatus;
    }

    /**
     * The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
     *
     * Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #campaignStatus}
     * will return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #campaignStatusAsString}.
     * </p>
     * 
     * @return The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
     *
     *         Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
     * @see CampaignStatus
     */
    public CampaignStatus campaignStatus() {
        return CampaignStatus.fromValue(campaignStatus);
    }

    /**
     * The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
     *
     * Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #campaignStatus}
     * will return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #campaignStatusAsString}.
     * </p>
     * 
     * @return The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
     *
     *         Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
     * @see CampaignStatus
     */
    public String campaignStatusAsString() {
        return campaignStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignState)) {
            return false;
        }
        CampaignState other = (CampaignState) obj;
        return Objects.equals(campaignStatusAsString(), other.campaignStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CampaignState").add("CampaignStatus", campaignStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignStatus":
            return Optional.ofNullable(clazz.cast(campaignStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignState, T> g) {
        return obj -> g.apply((CampaignState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignState> {
        /**
         * The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
         *
         * Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
         * 
         * @param campaignStatus
         *        The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
         *
         *        Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder campaignStatus(String campaignStatus);

        /**
         * The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
         *
         * Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
         * 
         * @param campaignStatus
         *        The status of the campaign, or the status of a treatment that belongs to an A/B test campaign.
         *
         *        Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN, COMPLETED, PAUSED
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder campaignStatus(CampaignStatus campaignStatus);
    }

    static final class BuilderImpl implements Builder {
        private String campaignStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignState model) {
            campaignStatus(model.campaignStatus);
        }

        public final String getCampaignStatusAsString() {
            return campaignStatus;
        }

        @Override
        public final Builder campaignStatus(String campaignStatus) {
            this.campaignStatus = campaignStatus;
            return this;
        }

        @Override
        public final Builder campaignStatus(CampaignStatus campaignStatus) {
            this.campaignStatus(campaignStatus.toString());
            return this;
        }

        public final void setCampaignStatus(String campaignStatus) {
            this.campaignStatus = campaignStatus;
        }

        @Override
        public CampaignState build() {
            return new CampaignState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
