/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * SMS message configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignSmsMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignSmsMessage.Builder, CampaignSmsMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignSmsMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignSmsMessage::messageTypeAsString)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignSmsMessage::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            MESSAGE_TYPE_FIELD, SENDER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String messageType;

    private final String senderId;

    private CampaignSmsMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.messageType = builder.messageType;
        this.senderId = builder.senderId;
    }

    /**
     * The SMS text body.
     * 
     * @return The SMS text body.
     */
    public String body() {
        return body;
    }

    /**
     * Is this is a transactional SMS message, otherwise a promotional message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return Is this is a transactional SMS message, otherwise a promotional message.
     * @see MessageType
     */
    public MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * Is this is a transactional SMS message, otherwise a promotional message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return Is this is a transactional SMS message, otherwise a promotional message.
     * @see MessageType
     */
    public String messageTypeAsString() {
        return messageType;
    }

    /**
     * Sender ID of sent message.
     * 
     * @return Sender ID of sent message.
     */
    public String senderId() {
        return senderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSmsMessage)) {
            return false;
        }
        CampaignSmsMessage other = (CampaignSmsMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(senderId(), other.senderId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CampaignSmsMessage").add("Body", body()).add("MessageType", messageTypeAsString())
                .add("SenderId", senderId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignSmsMessage, T> g) {
        return obj -> g.apply((CampaignSmsMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignSmsMessage> {
        /**
         * The SMS text body.
         * 
         * @param body
         *        The SMS text body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * Is this is a transactional SMS message, otherwise a promotional message.
         * 
         * @param messageType
         *        Is this is a transactional SMS message, otherwise a promotional message.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * Is this is a transactional SMS message, otherwise a promotional message.
         * 
         * @param messageType
         *        Is this is a transactional SMS message, otherwise a promotional message.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * Sender ID of sent message.
         * 
         * @param senderId
         *        Sender ID of sent message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String messageType;

        private String senderId;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSmsMessage model) {
            body(model.body);
            messageType(model.messageType);
            senderId(model.senderId);
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMessageTypeAsString() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getSenderId() {
            return senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public CampaignSmsMessage build() {
            return new CampaignSmsMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
