/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Campaign definition
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignResponse.Builder, CampaignResponse> {
    private static final SdkField<List<TreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField
            .<List<TreatmentResource>> builder(MarshallingType.LIST)
            .getter(getter(CampaignResponse::additionalTreatments))
            .setter(setter(Builder::additionalTreatments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TreatmentResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TreatmentResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<CampaignState> DEFAULT_STATE_FIELD = SdkField.<CampaignState> builder(MarshallingType.SDK_POJO)
            .getter(getter(CampaignResponse::defaultState)).setter(setter(Builder::defaultState))
            .constructor(CampaignState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultState").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CampaignResponse::holdoutPercent)).setter(setter(Builder::holdoutPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()).build();

    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.<CampaignHook> builder(MarshallingType.SDK_POJO)
            .getter(getter(CampaignResponse::hook)).setter(setter(Builder::hook)).constructor(CampaignHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CampaignResponse::isPaused)).setter(setter(Builder::isPaused))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.<CampaignLimits> builder(MarshallingType.SDK_POJO)
            .getter(getter(CampaignResponse::limits)).setter(setter(Builder::limits)).constructor(CampaignLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CampaignResponse::messageConfiguration))
            .setter(setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .getter(getter(CampaignResponse::schedule)).setter(setter(Builder::schedule)).constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CampaignResponse::segmentVersion)).setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final SdkField<CampaignState> STATE_FIELD = SdkField.<CampaignState> builder(MarshallingType.SDK_POJO)
            .getter(getter(CampaignResponse::state)).setter(setter(Builder::state)).constructor(CampaignState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CampaignResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::treatmentDescription)).setter(setter(Builder::treatmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build())
            .build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignResponse::treatmentName)).setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CampaignResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD,
            APPLICATION_ID_FIELD, ARN_FIELD, CREATION_DATE_FIELD, DEFAULT_STATE_FIELD, DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD,
            HOOK_FIELD, ID_FIELD, IS_PAUSED_FIELD, LAST_MODIFIED_DATE_FIELD, LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD,
            NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD, STATE_FIELD, TAGS_FIELD,
            TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TreatmentResource> additionalTreatments;

    private final String applicationId;

    private final String arn;

    private final String creationDate;

    private final CampaignState defaultState;

    private final String description;

    private final Integer holdoutPercent;

    private final CampaignHook hook;

    private final String id;

    private final Boolean isPaused;

    private final String lastModifiedDate;

    private final CampaignLimits limits;

    private final MessageConfiguration messageConfiguration;

    private final String name;

    private final Schedule schedule;

    private final String segmentId;

    private final Integer segmentVersion;

    private final CampaignState state;

    private final Map<String, String> tags;

    private final String treatmentDescription;

    private final String treatmentName;

    private final Integer version;

    private CampaignResponse(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.defaultState = builder.defaultState;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.id = builder.id;
        this.isPaused = builder.isPaused;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.state = builder.state;
        this.tags = builder.tags;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.version = builder.version;
    }

    /**
     * Treatments that are defined in addition to the default treatment.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Treatments that are defined in addition to the default treatment.
     */
    public List<TreatmentResource> additionalTreatments() {
        return additionalTreatments;
    }

    /**
     * The ID of the application to which the campaign applies.
     * 
     * @return The ID of the application to which the campaign applies.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The arn for the campaign.
     * 
     * @return The arn for the campaign.
     */
    public String arn() {
        return arn;
    }

    /**
     * The date the campaign was created in ISO 8601 format.
     * 
     * @return The date the campaign was created in ISO 8601 format.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * The status of the campaign's default treatment. Only present for A/B test campaigns.
     * 
     * @return The status of the campaign's default treatment. Only present for A/B test campaigns.
     */
    public CampaignState defaultState() {
        return defaultState;
    }

    /**
     * A description of the campaign.
     * 
     * @return A description of the campaign.
     */
    public String description() {
        return description;
    }

    /**
     * The allocated percentage of end users who will not receive messages from this campaign.
     * 
     * @return The allocated percentage of end users who will not receive messages from this campaign.
     */
    public Integer holdoutPercent() {
        return holdoutPercent;
    }

    /**
     * Campaign hook information.
     * 
     * @return Campaign hook information.
     */
    public CampaignHook hook() {
        return hook;
    }

    /**
     * The unique campaign ID.
     * 
     * @return The unique campaign ID.
     */
    public String id() {
        return id;
    }

    /**
     * Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume it by
     * setting IsPaused to false.
     * 
     * @return Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume it
     *         by setting IsPaused to false.
     */
    public Boolean isPaused() {
        return isPaused;
    }

    /**
     * The date the campaign was last updated in ISO 8601 format.
     * 
     * @return The date the campaign was last updated in ISO 8601 format.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * The campaign limits settings.
     * 
     * @return The campaign limits settings.
     */
    public CampaignLimits limits() {
        return limits;
    }

    /**
     * The message configuration settings.
     * 
     * @return The message configuration settings.
     */
    public MessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * The custom name of the campaign.
     * 
     * @return The custom name of the campaign.
     */
    public String name() {
        return name;
    }

    /**
     * The campaign schedule.
     * 
     * @return The campaign schedule.
     */
    public Schedule schedule() {
        return schedule;
    }

    /**
     * The ID of the segment to which the campaign sends messages.
     * 
     * @return The ID of the segment to which the campaign sends messages.
     */
    public String segmentId() {
        return segmentId;
    }

    /**
     * The version of the segment to which the campaign sends messages.
     * 
     * @return The version of the segment to which the campaign sends messages.
     */
    public Integer segmentVersion() {
        return segmentVersion;
    }

    /**
     * The campaign status.
     *
     * An A/B test campaign will have a status of COMPLETED only when all treatments have a status of COMPLETED.
     * 
     * @return The campaign status.
     *
     *         An A/B test campaign will have a status of COMPLETED only when all treatments have a status of COMPLETED.
     */
    public CampaignState state() {
        return state;
    }

    /**
     * The Tags for the campaign.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Tags for the campaign.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * A custom description for the treatment.
     * 
     * @return A custom description for the treatment.
     */
    public String treatmentDescription() {
        return treatmentDescription;
    }

    /**
     * The custom name of a variation of the campaign used for A/B testing.
     * 
     * @return The custom name of a variation of the campaign used for A/B testing.
     */
    public String treatmentName() {
        return treatmentName;
    }

    /**
     * The campaign version number.
     * 
     * @return The campaign version number.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalTreatments());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultState());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(hook());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignResponse)) {
            return false;
        }
        CampaignResponse other = (CampaignResponse) obj;
        return Objects.equals(additionalTreatments(), other.additionalTreatments())
                && Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(defaultState(), other.defaultState())
                && Objects.equals(description(), other.description()) && Objects.equals(holdoutPercent(), other.holdoutPercent())
                && Objects.equals(hook(), other.hook()) && Objects.equals(id(), other.id())
                && Objects.equals(isPaused(), other.isPaused()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(limits(), other.limits())
                && Objects.equals(messageConfiguration(), other.messageConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(segmentId(), other.segmentId())
                && Objects.equals(segmentVersion(), other.segmentVersion()) && Objects.equals(state(), other.state())
                && Objects.equals(tags(), other.tags()) && Objects.equals(treatmentDescription(), other.treatmentDescription())
                && Objects.equals(treatmentName(), other.treatmentName()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CampaignResponse").add("AdditionalTreatments", additionalTreatments())
                .add("ApplicationId", applicationId()).add("Arn", arn()).add("CreationDate", creationDate())
                .add("DefaultState", defaultState()).add("Description", description()).add("HoldoutPercent", holdoutPercent())
                .add("Hook", hook()).add("Id", id()).add("IsPaused", isPaused()).add("LastModifiedDate", lastModifiedDate())
                .add("Limits", limits()).add("MessageConfiguration", messageConfiguration()).add("Name", name())
                .add("Schedule", schedule()).add("SegmentId", segmentId()).add("SegmentVersion", segmentVersion())
                .add("State", state()).add("Tags", tags()).add("TreatmentDescription", treatmentDescription())
                .add("TreatmentName", treatmentName()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalTreatments":
            return Optional.ofNullable(clazz.cast(additionalTreatments()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DefaultState":
            return Optional.ofNullable(clazz.cast(defaultState()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HoldoutPercent":
            return Optional.ofNullable(clazz.cast(holdoutPercent()));
        case "Hook":
            return Optional.ofNullable(clazz.cast(hook()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IsPaused":
            return Optional.ofNullable(clazz.cast(isPaused()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TreatmentDescription":
            return Optional.ofNullable(clazz.cast(treatmentDescription()));
        case "TreatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignResponse, T> g) {
        return obj -> g.apply((CampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignResponse> {
        /**
         * Treatments that are defined in addition to the default treatment.
         * 
         * @param additionalTreatments
         *        Treatments that are defined in addition to the default treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments);

        /**
         * Treatments that are defined in addition to the default treatment.
         * 
         * @param additionalTreatments
         *        Treatments that are defined in addition to the default treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(TreatmentResource... additionalTreatments);

        /**
         * Treatments that are defined in addition to the default treatment. This is a convenience that creates an
         * instance of the {@link List<TreatmentResource>.Builder} avoiding the need to create one manually via
         * {@link List<TreatmentResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TreatmentResource>.Builder#build()} is called immediately
         * and its result is passed to {@link #additionalTreatments(List<TreatmentResource>)}.
         * 
         * @param additionalTreatments
         *        a consumer that will call methods on {@link List<TreatmentResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalTreatments(List<TreatmentResource>)
         */
        Builder additionalTreatments(Consumer<TreatmentResource.Builder>... additionalTreatments);

        /**
         * The ID of the application to which the campaign applies.
         * 
         * @param applicationId
         *        The ID of the application to which the campaign applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The arn for the campaign.
         * 
         * @param arn
         *        The arn for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The date the campaign was created in ISO 8601 format.
         * 
         * @param creationDate
         *        The date the campaign was created in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * The status of the campaign's default treatment. Only present for A/B test campaigns.
         * 
         * @param defaultState
         *        The status of the campaign's default treatment. Only present for A/B test campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultState(CampaignState defaultState);

        /**
         * The status of the campaign's default treatment. Only present for A/B test campaigns. This is a convenience
         * that creates an instance of the {@link CampaignState.Builder} avoiding the need to create one manually via
         * {@link CampaignState#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignState.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultState(CampaignState)}.
         * 
         * @param defaultState
         *        a consumer that will call methods on {@link CampaignState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultState(CampaignState)
         */
        default Builder defaultState(Consumer<CampaignState.Builder> defaultState) {
            return defaultState(CampaignState.builder().applyMutation(defaultState).build());
        }

        /**
         * A description of the campaign.
         * 
         * @param description
         *        A description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The allocated percentage of end users who will not receive messages from this campaign.
         * 
         * @param holdoutPercent
         *        The allocated percentage of end users who will not receive messages from this campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder holdoutPercent(Integer holdoutPercent);

        /**
         * Campaign hook information.
         * 
         * @param hook
         *        Campaign hook information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(CampaignHook hook);

        /**
         * Campaign hook information. This is a convenience that creates an instance of the {@link CampaignHook.Builder}
         * avoiding the need to create one manually via {@link CampaignHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignHook.Builder#build()} is called immediately and its
         * result is passed to {@link #hook(CampaignHook)}.
         * 
         * @param hook
         *        a consumer that will call methods on {@link CampaignHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hook(CampaignHook)
         */
        default Builder hook(Consumer<CampaignHook.Builder> hook) {
            return hook(CampaignHook.builder().applyMutation(hook).build());
        }

        /**
         * The unique campaign ID.
         * 
         * @param id
         *        The unique campaign ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume it by
         * setting IsPaused to false.
         * 
         * @param isPaused
         *        Indicates whether the campaign is paused. A paused campaign does not send messages unless you resume
         *        it by setting IsPaused to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPaused(Boolean isPaused);

        /**
         * The date the campaign was last updated in ISO 8601 format.
         * 
         * @param lastModifiedDate
         *        The date the campaign was last updated in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * The campaign limits settings.
         * 
         * @param limits
         *        The campaign limits settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(CampaignLimits limits);

        /**
         * The campaign limits settings. This is a convenience that creates an instance of the
         * {@link CampaignLimits.Builder} avoiding the need to create one manually via {@link CampaignLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(CampaignLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link CampaignLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(CampaignLimits)
         */
        default Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return limits(CampaignLimits.builder().applyMutation(limits).build());
        }

        /**
         * The message configuration settings.
         * 
         * @param messageConfiguration
         *        The message configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(MessageConfiguration messageConfiguration);

        /**
         * The message configuration settings. This is a convenience that creates an instance of the
         * {@link MessageConfiguration.Builder} avoiding the need to create one manually via
         * {@link MessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfiguration(MessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(MessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(MessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * The custom name of the campaign.
         * 
         * @param name
         *        The custom name of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The campaign schedule.
         * 
         * @param schedule
         *        The campaign schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * The campaign schedule. This is a convenience that creates an instance of the {@link Schedule.Builder}
         * avoiding the need to create one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * The ID of the segment to which the campaign sends messages.
         * 
         * @param segmentId
         *        The ID of the segment to which the campaign sends messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * The version of the segment to which the campaign sends messages.
         * 
         * @param segmentVersion
         *        The version of the segment to which the campaign sends messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);

        /**
         * The campaign status.
         *
         * An A/B test campaign will have a status of COMPLETED only when all treatments have a status of COMPLETED.
         * 
         * @param state
         *        The campaign status.
         *
         *        An A/B test campaign will have a status of COMPLETED only when all treatments have a status of
         *        COMPLETED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(CampaignState state);

        /**
         * The campaign status.
         *
         * An A/B test campaign will have a status of COMPLETED only when all treatments have a status of COMPLETED.
         * This is a convenience that creates an instance of the {@link CampaignState.Builder} avoiding the need to
         * create one manually via {@link CampaignState#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(CampaignState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link CampaignState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(CampaignState)
         */
        default Builder state(Consumer<CampaignState.Builder> state) {
            return state(CampaignState.builder().applyMutation(state).build());
        }

        /**
         * The Tags for the campaign.
         * 
         * @param tags
         *        The Tags for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * A custom description for the treatment.
         * 
         * @param treatmentDescription
         *        A custom description for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentDescription(String treatmentDescription);

        /**
         * The custom name of a variation of the campaign used for A/B testing.
         * 
         * @param treatmentName
         *        The custom name of a variation of the campaign used for A/B testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);

        /**
         * The campaign version number.
         * 
         * @param version
         *        The campaign version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private List<TreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();

        private String applicationId;

        private String arn;

        private String creationDate;

        private CampaignState defaultState;

        private String description;

        private Integer holdoutPercent;

        private CampaignHook hook;

        private String id;

        private Boolean isPaused;

        private String lastModifiedDate;

        private CampaignLimits limits;

        private MessageConfiguration messageConfiguration;

        private String name;

        private Schedule schedule;

        private String segmentId;

        private Integer segmentVersion;

        private CampaignState state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String treatmentDescription;

        private String treatmentName;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignResponse model) {
            additionalTreatments(model.additionalTreatments);
            applicationId(model.applicationId);
            arn(model.arn);
            creationDate(model.creationDate);
            defaultState(model.defaultState);
            description(model.description);
            holdoutPercent(model.holdoutPercent);
            hook(model.hook);
            id(model.id);
            isPaused(model.isPaused);
            lastModifiedDate(model.lastModifiedDate);
            limits(model.limits);
            messageConfiguration(model.messageConfiguration);
            name(model.name);
            schedule(model.schedule);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
            state(model.state);
            tags(model.tags);
            treatmentDescription(model.treatmentDescription);
            treatmentName(model.treatmentName);
            version(model.version);
        }

        public final Collection<TreatmentResource.Builder> getAdditionalTreatments() {
            return additionalTreatments != null ? additionalTreatments.stream().map(TreatmentResource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(TreatmentResource... additionalTreatments) {
            additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<TreatmentResource.Builder>... additionalTreatments) {
            additionalTreatments(Stream.of(additionalTreatments).map(c -> TreatmentResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalTreatments(Collection<TreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final CampaignState.Builder getDefaultState() {
            return defaultState != null ? defaultState.toBuilder() : null;
        }

        @Override
        public final Builder defaultState(CampaignState defaultState) {
            this.defaultState = defaultState;
            return this;
        }

        public final void setDefaultState(CampaignState.BuilderImpl defaultState) {
            this.defaultState = defaultState != null ? defaultState.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final CampaignHook.Builder getHook() {
            return hook != null ? hook.toBuilder() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsPaused() {
            return isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final CampaignState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTreatmentDescription() {
            return treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public CampaignResponse build() {
            return new CampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
