/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that defines the events that cause the campaign to be sent.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignEventFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignEventFilter.Builder, CampaignEventFilter> {
    private static final SdkField<EventDimensions> DIMENSIONS_FIELD = SdkField
            .<EventDimensions> builder(MarshallingType.SDK_POJO).getter(getter(CampaignEventFilter::dimensions))
            .setter(setter(Builder::dimensions)).constructor(EventDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CampaignEventFilter::filterTypeAsString)).setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            FILTER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final EventDimensions dimensions;

    private final String filterType;

    private CampaignEventFilter(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.filterType = builder.filterType;
    }

    /**
     * An object that defines the dimensions for the event filter.
     * 
     * @return An object that defines the dimensions for the event filter.
     */
    public EventDimensions dimensions() {
        return dimensions;
    }

    /**
     * The type of event that causes the campaign to be sent. Possible values:
     *
     * SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
     *
     * ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of event that causes the campaign to be sent. Possible values:
     *
     *         SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
     *
     *         ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more information.
     * @see FilterType
     */
    public FilterType filterType() {
        return FilterType.fromValue(filterType);
    }

    /**
     * The type of event that causes the campaign to be sent. Possible values:
     *
     * SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
     *
     * ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link FilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of event that causes the campaign to be sent. Possible values:
     *
     *         SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
     *
     *         ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more information.
     * @see FilterType
     */
    public String filterTypeAsString() {
        return filterType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEventFilter)) {
            return false;
        }
        CampaignEventFilter other = (CampaignEventFilter) obj;
        return Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(filterTypeAsString(), other.filterTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CampaignEventFilter").add("Dimensions", dimensions()).add("FilterType", filterTypeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "FilterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignEventFilter, T> g) {
        return obj -> g.apply((CampaignEventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignEventFilter> {
        /**
         * An object that defines the dimensions for the event filter.
         * 
         * @param dimensions
         *        An object that defines the dimensions for the event filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(EventDimensions dimensions);

        /**
         * An object that defines the dimensions for the event filter. This is a convenience that creates an instance of
         * the {@link EventDimensions.Builder} avoiding the need to create one manually via
         * {@link EventDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(EventDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link EventDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(EventDimensions)
         */
        default Builder dimensions(Consumer<EventDimensions.Builder> dimensions) {
            return dimensions(EventDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * The type of event that causes the campaign to be sent. Possible values:
         *
         * SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
         *
         * ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more information.
         * 
         * @param filterType
         *        The type of event that causes the campaign to be sent. Possible values:
         *
         *        SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
         *
         *        ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more
         *        information.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(String filterType);

        /**
         * The type of event that causes the campaign to be sent. Possible values:
         *
         * SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
         *
         * ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more information.
         * 
         * @param filterType
         *        The type of event that causes the campaign to be sent. Possible values:
         *
         *        SYSTEM - Send the campaign when a system event occurs. See the System resource for more information.
         *
         *        ENDPOINT - Send the campaign when an endpoint event occurs. See the Event resource for more
         *        information.
         * @see FilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterType
         */
        Builder filterType(FilterType filterType);
    }

    static final class BuilderImpl implements Builder {
        private EventDimensions dimensions;

        private String filterType;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEventFilter model) {
            dimensions(model.dimensions);
            filterType(model.filterType);
        }

        public final EventDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(EventDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(EventDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getFilterTypeAsString() {
            return filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(FilterType filterType) {
            this.filterType(filterType.toString());
            return this;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public CampaignEventFilter build() {
            return new CampaignEventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
