/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Baidu Message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BaiduMessage implements SdkPojo, Serializable, ToCopyableBuilder<BaiduMessage.Builder, BaiduMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(BaiduMessage::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ICON_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::iconReference)).setter(setter(Builder::iconReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconReference").build()).build();

    private static final SdkField<String> IMAGE_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::imageIconUrl)).setter(setter(Builder::imageIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIconUrl").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(BaiduMessage::silentPush)).setter(setter(Builder::silentPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()).build();

    private static final SdkField<String> SMALL_IMAGE_ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::smallImageIconUrl)).setter(setter(Builder::smallImageIconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallImageIconUrl").build()).build();

    private static final SdkField<String> SOUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::sound)).setter(setter(Builder::sound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(BaiduMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BaiduMessage::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BaiduMessage::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD,
            DATA_FIELD, ICON_REFERENCE_FIELD, IMAGE_ICON_URL_FIELD, IMAGE_URL_FIELD, RAW_CONTENT_FIELD, SILENT_PUSH_FIELD,
            SMALL_IMAGE_ICON_URL_FIELD, SOUND_FIELD, SUBSTITUTIONS_FIELD, TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String body;

    private final Map<String, String> data;

    private final String iconReference;

    private final String imageIconUrl;

    private final String imageUrl;

    private final String rawContent;

    private final Boolean silentPush;

    private final String smallImageIconUrl;

    private final String sound;

    private final Map<String, List<String>> substitutions;

    private final Integer timeToLive;

    private final String title;

    private final String url;

    private BaiduMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.data = builder.data;
        this.iconReference = builder.iconReference;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageUrl = builder.imageUrl;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.smallImageIconUrl = builder.smallImageIconUrl;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page at
     * the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a
     *         designated user interface within the app. URL - The default mobile browser on the user's device launches
     *         and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page at
     * the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a
     *         designated user interface within the app. URL - The default mobile browser on the user's device launches
     *         and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * The message body of the notification.
     * 
     * @return The message body of the notification.
     */
    public String body() {
        return body;
    }

    /**
     * The data payload used for a silent push. This payload is added to the notifications' data.pinpoint.jsonBody'
     * object
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data payload used for a silent push. This payload is added to the notifications'
     *         data.pinpoint.jsonBody' object
     */
    public Map<String, String> data() {
        return data;
    }

    /**
     * The icon image name of the asset saved in your application.
     * 
     * @return The icon image name of the asset saved in your application.
     */
    public String iconReference() {
        return iconReference;
    }

    /**
     * The URL that points to an image used as the large icon to the notification content view.
     * 
     * @return The URL that points to an image used as the large icon to the notification content view.
     */
    public String imageIconUrl() {
        return imageIconUrl;
    }

    /**
     * The URL that points to an image used in the push notification.
     * 
     * @return The URL that points to an image used in the push notification.
     */
    public String imageUrl() {
        return imageUrl;
    }

    /**
     * The Raw JSON formatted string to be used as the payload. This value overrides the message.
     * 
     * @return The Raw JSON formatted string to be used as the payload. This value overrides the message.
     */
    public String rawContent() {
        return rawContent;
    }

    /**
     * Indicates if the message should display on the users device. Silent pushes can be used for Remote Configuration
     * and Phone Home use cases.
     * 
     * @return Indicates if the message should display on the users device. Silent pushes can be used for Remote
     *         Configuration and Phone Home use cases.
     */
    public Boolean silentPush() {
        return silentPush;
    }

    /**
     * The URL that points to an image used as the small icon for the notification which will be used to represent the
     * notification in the status bar and content view
     * 
     * @return The URL that points to an image used as the small icon for the notification which will be used to
     *         represent the notification in the status bar and content view
     */
    public String smallImageIconUrl() {
        return smallImageIconUrl;
    }

    /**
     * Indicates a sound to play when the device receives the notification. Supports default, or the filename of a sound
     * resource bundled in the app. Android sound files must reside in /res/raw/
     * 
     * @return Indicates a sound to play when the device receives the notification. Supports default, or the filename of
     *         a sound resource bundled in the app. Android sound files must reside in /res/raw/
     */
    public String sound() {
        return sound;
    }

    /**
     * Default message substitutions. Can be overridden by individual address substitutions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default message substitutions. Can be overridden by individual address substitutions.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * This parameter specifies how long (in seconds) the message should be kept in Baidu storage if the device is
     * offline. The and the default value and the maximum time to live supported is 7 days (604800 seconds)
     * 
     * @return This parameter specifies how long (in seconds) the message should be kept in Baidu storage if the device
     *         is offline. The and the default value and the maximum time to live supported is 7 days (604800 seconds)
     */
    public Integer timeToLive() {
        return timeToLive;
    }

    /**
     * The message title that displays above the message on the user's device.
     * 
     * @return The message title that displays above the message on the user's device.
     */
    public String title() {
        return title;
    }

    /**
     * The URL to open in the user's mobile browser. Used if the value for Action is URL.
     * 
     * @return The URL to open in the user's mobile browser. Used if the value for Action is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(iconReference());
        hashCode = 31 * hashCode + Objects.hashCode(imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(smallImageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sound());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaiduMessage)) {
            return false;
        }
        BaiduMessage other = (BaiduMessage) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(body(), other.body())
                && Objects.equals(data(), other.data()) && Objects.equals(iconReference(), other.iconReference())
                && Objects.equals(imageIconUrl(), other.imageIconUrl()) && Objects.equals(imageUrl(), other.imageUrl())
                && Objects.equals(rawContent(), other.rawContent()) && Objects.equals(silentPush(), other.silentPush())
                && Objects.equals(smallImageIconUrl(), other.smallImageIconUrl()) && Objects.equals(sound(), other.sound())
                && Objects.equals(substitutions(), other.substitutions()) && Objects.equals(timeToLive(), other.timeToLive())
                && Objects.equals(title(), other.title()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BaiduMessage").add("Action", actionAsString()).add("Body", body()).add("Data", data())
                .add("IconReference", iconReference()).add("ImageIconUrl", imageIconUrl()).add("ImageUrl", imageUrl())
                .add("RawContent", rawContent()).add("SilentPush", silentPush()).add("SmallImageIconUrl", smallImageIconUrl())
                .add("Sound", sound()).add("Substitutions", substitutions()).add("TimeToLive", timeToLive())
                .add("Title", title()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "IconReference":
            return Optional.ofNullable(clazz.cast(iconReference()));
        case "ImageIconUrl":
            return Optional.ofNullable(clazz.cast(imageIconUrl()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "SilentPush":
            return Optional.ofNullable(clazz.cast(silentPush()));
        case "SmallImageIconUrl":
            return Optional.ofNullable(clazz.cast(smallImageIconUrl()));
        case "Sound":
            return Optional.ofNullable(clazz.cast(sound()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BaiduMessage, T> g) {
        return obj -> g.apply((BaiduMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BaiduMessage> {
        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page
         * at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display
         *        a designated user interface within the app. URL - The default mobile browser on the user's device
         *        launches and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK |
         *        URL
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page
         * at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display
         *        a designated user interface within the app. URL - The default mobile browser on the user's device
         *        launches and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK |
         *        URL
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * The message body of the notification.
         * 
         * @param body
         *        The message body of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * The data payload used for a silent push. This payload is added to the notifications' data.pinpoint.jsonBody'
         * object
         * 
         * @param data
         *        The data payload used for a silent push. This payload is added to the notifications'
         *        data.pinpoint.jsonBody' object
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Map<String, String> data);

        /**
         * The icon image name of the asset saved in your application.
         * 
         * @param iconReference
         *        The icon image name of the asset saved in your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconReference(String iconReference);

        /**
         * The URL that points to an image used as the large icon to the notification content view.
         * 
         * @param imageIconUrl
         *        The URL that points to an image used as the large icon to the notification content view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIconUrl(String imageIconUrl);

        /**
         * The URL that points to an image used in the push notification.
         * 
         * @param imageUrl
         *        The URL that points to an image used in the push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * The Raw JSON formatted string to be used as the payload. This value overrides the message.
         * 
         * @param rawContent
         *        The Raw JSON formatted string to be used as the payload. This value overrides the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * Indicates if the message should display on the users device. Silent pushes can be used for Remote
         * Configuration and Phone Home use cases.
         * 
         * @param silentPush
         *        Indicates if the message should display on the users device. Silent pushes can be used for Remote
         *        Configuration and Phone Home use cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentPush(Boolean silentPush);

        /**
         * The URL that points to an image used as the small icon for the notification which will be used to represent
         * the notification in the status bar and content view
         * 
         * @param smallImageIconUrl
         *        The URL that points to an image used as the small icon for the notification which will be used to
         *        represent the notification in the status bar and content view
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallImageIconUrl(String smallImageIconUrl);

        /**
         * Indicates a sound to play when the device receives the notification. Supports default, or the filename of a
         * sound resource bundled in the app. Android sound files must reside in /res/raw/
         * 
         * @param sound
         *        Indicates a sound to play when the device receives the notification. Supports default, or the filename
         *        of a sound resource bundled in the app. Android sound files must reside in /res/raw/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sound(String sound);

        /**
         * Default message substitutions. Can be overridden by individual address substitutions.
         * 
         * @param substitutions
         *        Default message substitutions. Can be overridden by individual address substitutions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * This parameter specifies how long (in seconds) the message should be kept in Baidu storage if the device is
         * offline. The and the default value and the maximum time to live supported is 7 days (604800 seconds)
         * 
         * @param timeToLive
         *        This parameter specifies how long (in seconds) the message should be kept in Baidu storage if the
         *        device is offline. The and the default value and the maximum time to live supported is 7 days (604800
         *        seconds)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * The message title that displays above the message on the user's device.
         * 
         * @param title
         *        The message title that displays above the message on the user's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * 
         * @param url
         *        The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String body;

        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();

        private String iconReference;

        private String imageIconUrl;

        private String imageUrl;

        private String rawContent;

        private Boolean silentPush;

        private String smallImageIconUrl;

        private String sound;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeToLive;

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(BaiduMessage model) {
            action(model.action);
            body(model.body);
            data(model.data);
            iconReference(model.iconReference);
            imageIconUrl(model.imageIconUrl);
            imageUrl(model.imageUrl);
            rawContent(model.rawContent);
            silentPush(model.silentPush);
            smallImageIconUrl(model.smallImageIconUrl);
            sound(model.sound);
            substitutions(model.substitutions);
            timeToLive(model.timeToLive);
            title(model.title);
            url(model.url);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getData() {
            return data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getIconReference() {
            return iconReference;
        }

        @Override
        public final Builder iconReference(String iconReference) {
            this.iconReference = iconReference;
            return this;
        }

        public final void setIconReference(String iconReference) {
            this.iconReference = iconReference;
        }

        public final String getImageIconUrl() {
            return imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getRawContent() {
            return rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSmallImageIconUrl() {
            return smallImageIconUrl;
        }

        @Override
        public final Builder smallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
            return this;
        }

        public final void setSmallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
        }

        public final String getSound() {
            return sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public BaiduMessage build() {
            return new BaiduMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
