/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Get Applications Result.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationsResponse.Builder, ApplicationsResponse> {
    private static final SdkField<List<ApplicationResponse>> ITEM_FIELD = SdkField
            .<List<ApplicationResponse>> builder(MarshallingType.LIST)
            .getter(getter(ApplicationsResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ApplicationResponse> item;

    private final String nextToken;

    private ApplicationsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    /**
     * List of applications returned in this page.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of applications returned in this page.
     */
    public List<ApplicationResponse> item() {
        return item;
    }

    /**
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationsResponse)) {
            return false;
        }
        ApplicationsResponse other = (ApplicationsResponse) obj;
        return Objects.equals(item(), other.item()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationsResponse").add("Item", item()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationsResponse, T> g) {
        return obj -> g.apply((ApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationsResponse> {
        /**
         * List of applications returned in this page.
         * 
         * @param item
         *        List of applications returned in this page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<ApplicationResponse> item);

        /**
         * List of applications returned in this page.
         * 
         * @param item
         *        List of applications returned in this page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(ApplicationResponse... item);

        /**
         * List of applications returned in this page. This is a convenience that creates an instance of the
         * {@link List<ApplicationResponse>.Builder} avoiding the need to create one manually via {@link List
         * <ApplicationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationResponse>.Builder#build()} is called immediately
         * and its result is passed to {@link #item(List<ApplicationResponse>)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link List<ApplicationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(List<ApplicationResponse>)
         */
        Builder item(Consumer<ApplicationResponse.Builder>... item);

        /**
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ApplicationResponse> item = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationsResponse model) {
            item(model.item);
            nextToken(model.nextToken);
        }

        public final Collection<ApplicationResponse.Builder> getItem() {
            return item != null ? item.stream().map(ApplicationResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<ApplicationResponse> item) {
            this.item = ListOfApplicationResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(ApplicationResponse... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<ApplicationResponse.Builder>... item) {
            item(Stream.of(item).map(c -> ApplicationResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<ApplicationResponse.BuilderImpl> item) {
            this.item = ListOfApplicationResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ApplicationsResponse build() {
            return new ApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
