/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Application settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSettingsResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSettingsResource.Builder, ApplicationSettingsResource> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationSettingsResource::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<CampaignHook> CAMPAIGN_HOOK_FIELD = SdkField.<CampaignHook> builder(MarshallingType.SDK_POJO)
            .getter(getter(ApplicationSettingsResource::campaignHook)).setter(setter(Builder::campaignHook))
            .constructor(CampaignHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignHook").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationSettingsResource::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.<CampaignLimits> builder(MarshallingType.SDK_POJO)
            .getter(getter(ApplicationSettingsResource::limits)).setter(setter(Builder::limits))
            .constructor(CampaignLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.<QuietTime> builder(MarshallingType.SDK_POJO)
            .getter(getter(ApplicationSettingsResource::quietTime)).setter(setter(Builder::quietTime))
            .constructor(QuietTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAMPAIGN_HOOK_FIELD, LAST_MODIFIED_DATE_FIELD, LIMITS_FIELD, QUIET_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final CampaignHook campaignHook;

    private final String lastModifiedDate;

    private final CampaignLimits limits;

    private final QuietTime quietTime;

    private ApplicationSettingsResource(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignHook = builder.campaignHook;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.quietTime = builder.quietTime;
    }

    /**
     * The unique ID for the application.
     * 
     * @return The unique ID for the application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * Default campaign hook.
     * 
     * @return Default campaign hook.
     */
    public CampaignHook campaignHook() {
        return campaignHook;
    }

    /**
     * The date that the settings were last updated in ISO 8601 format.
     * 
     * @return The date that the settings were last updated in ISO 8601 format.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign
     * overrides the default with limits of its own.
     * 
     * @return The default campaign limits for the app. These limits apply to each campaign for the app, unless the
     *         campaign overrides the default with limits of its own.
     */
    public CampaignLimits limits() {
        return limits;
    }

    /**
     * The default quiet time for the app. Campaigns in the app don't send messages to endpoints during the quiet time.
     *
     * Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a quiet
     * time for your app. If your endpoints don't include this attribute, they'll receive the messages that you send
     * them, even if quiet time is enabled.
     *
     * When you set up an app to use quiet time, campaigns in that app don't send messages during the time range you
     * specified, as long as all of the following are true: - The endpoint includes a valid Demographic.Timezone
     * attribute. - The current time in the endpoint's time zone is later than or equal to the time specified in the
     * QuietTime.Start attribute for the app (or campaign, if applicable). - The current time in the endpoint's time
     * zone is earlier than or equal to the time specified in the QuietTime.End attribute for the app (or campaign, if
     * applicable).
     *
     * Individual campaigns within the app can have their own quiet time settings, which override the quiet time
     * settings at the app level.
     * 
     * @return The default quiet time for the app. Campaigns in the app don't send messages to endpoints during the
     *         quiet time.
     *
     *         Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a
     *         quiet time for your app. If your endpoints don't include this attribute, they'll receive the messages
     *         that you send them, even if quiet time is enabled.
     *
     *         When you set up an app to use quiet time, campaigns in that app don't send messages during the time range
     *         you specified, as long as all of the following are true: - The endpoint includes a valid
     *         Demographic.Timezone attribute. - The current time in the endpoint's time zone is later than or equal to
     *         the time specified in the QuietTime.Start attribute for the app (or campaign, if applicable). - The
     *         current time in the endpoint's time zone is earlier than or equal to the time specified in the
     *         QuietTime.End attribute for the app (or campaign, if applicable).
     *
     *         Individual campaigns within the app can have their own quiet time settings, which override the quiet time
     *         settings at the app level.
     */
    public QuietTime quietTime() {
        return quietTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(campaignHook());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(quietTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsResource)) {
            return false;
        }
        ApplicationSettingsResource other = (ApplicationSettingsResource) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(campaignHook(), other.campaignHook())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(limits(), other.limits())
                && Objects.equals(quietTime(), other.quietTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationSettingsResource").add("ApplicationId", applicationId())
                .add("CampaignHook", campaignHook()).add("LastModifiedDate", lastModifiedDate()).add("Limits", limits())
                .add("QuietTime", quietTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CampaignHook":
            return Optional.ofNullable(clazz.cast(campaignHook()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "QuietTime":
            return Optional.ofNullable(clazz.cast(quietTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsResource, T> g) {
        return obj -> g.apply((ApplicationSettingsResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSettingsResource> {
        /**
         * The unique ID for the application.
         * 
         * @param applicationId
         *        The unique ID for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Default campaign hook.
         * 
         * @param campaignHook
         *        Default campaign hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignHook(CampaignHook campaignHook);

        /**
         * Default campaign hook. This is a convenience that creates an instance of the {@link CampaignHook.Builder}
         * avoiding the need to create one manually via {@link CampaignHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignHook.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignHook(CampaignHook)}.
         * 
         * @param campaignHook
         *        a consumer that will call methods on {@link CampaignHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignHook(CampaignHook)
         */
        default Builder campaignHook(Consumer<CampaignHook.Builder> campaignHook) {
            return campaignHook(CampaignHook.builder().applyMutation(campaignHook).build());
        }

        /**
         * The date that the settings were last updated in ISO 8601 format.
         * 
         * @param lastModifiedDate
         *        The date that the settings were last updated in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign
         * overrides the default with limits of its own.
         * 
         * @param limits
         *        The default campaign limits for the app. These limits apply to each campaign for the app, unless the
         *        campaign overrides the default with limits of its own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(CampaignLimits limits);

        /**
         * The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign
         * overrides the default with limits of its own. This is a convenience that creates an instance of the
         * {@link CampaignLimits.Builder} avoiding the need to create one manually via {@link CampaignLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(CampaignLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link CampaignLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(CampaignLimits)
         */
        default Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return limits(CampaignLimits.builder().applyMutation(limits).build());
        }

        /**
         * The default quiet time for the app. Campaigns in the app don't send messages to endpoints during the quiet
         * time.
         *
         * Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a quiet
         * time for your app. If your endpoints don't include this attribute, they'll receive the messages that you send
         * them, even if quiet time is enabled.
         *
         * When you set up an app to use quiet time, campaigns in that app don't send messages during the time range you
         * specified, as long as all of the following are true: - The endpoint includes a valid Demographic.Timezone
         * attribute. - The current time in the endpoint's time zone is later than or equal to the time specified in the
         * QuietTime.Start attribute for the app (or campaign, if applicable). - The current time in the endpoint's time
         * zone is earlier than or equal to the time specified in the QuietTime.End attribute for the app (or campaign,
         * if applicable).
         *
         * Individual campaigns within the app can have their own quiet time settings, which override the quiet time
         * settings at the app level.
         * 
         * @param quietTime
         *        The default quiet time for the app. Campaigns in the app don't send messages to endpoints during the
         *        quiet time.
         *
         *        Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable
         *        a quiet time for your app. If your endpoints don't include this attribute, they'll receive the
         *        messages that you send them, even if quiet time is enabled.
         *
         *        When you set up an app to use quiet time, campaigns in that app don't send messages during the time
         *        range you specified, as long as all of the following are true: - The endpoint includes a valid
         *        Demographic.Timezone attribute. - The current time in the endpoint's time zone is later than or equal
         *        to the time specified in the QuietTime.Start attribute for the app (or campaign, if applicable). - The
         *        current time in the endpoint's time zone is earlier than or equal to the time specified in the
         *        QuietTime.End attribute for the app (or campaign, if applicable).
         *
         *        Individual campaigns within the app can have their own quiet time settings, which override the quiet
         *        time settings at the app level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quietTime(QuietTime quietTime);

        /**
         * The default quiet time for the app. Campaigns in the app don't send messages to endpoints during the quiet
         * time.
         *
         * Note: Make sure that your endpoints include the Demographics.Timezone attribute if you plan to enable a quiet
         * time for your app. If your endpoints don't include this attribute, they'll receive the messages that you send
         * them, even if quiet time is enabled.
         *
         * When you set up an app to use quiet time, campaigns in that app don't send messages during the time range you
         * specified, as long as all of the following are true: - The endpoint includes a valid Demographic.Timezone
         * attribute. - The current time in the endpoint's time zone is later than or equal to the time specified in the
         * QuietTime.Start attribute for the app (or campaign, if applicable). - The current time in the endpoint's time
         * zone is earlier than or equal to the time specified in the QuietTime.End attribute for the app (or campaign,
         * if applicable).
         *
         * Individual campaigns within the app can have their own quiet time settings, which override the quiet time
         * settings at the app level. This is a convenience that creates an instance of the {@link QuietTime.Builder}
         * avoiding the need to create one manually via {@link QuietTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuietTime.Builder#build()} is called immediately and its result
         * is passed to {@link #quietTime(QuietTime)}.
         * 
         * @param quietTime
         *        a consumer that will call methods on {@link QuietTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quietTime(QuietTime)
         */
        default Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return quietTime(QuietTime.builder().applyMutation(quietTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private CampaignHook campaignHook;

        private String lastModifiedDate;

        private CampaignLimits limits;

        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsResource model) {
            applicationId(model.applicationId);
            campaignHook(model.campaignHook);
            lastModifiedDate(model.lastModifiedDate);
            limits(model.limits);
            quietTime(model.quietTime);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final CampaignHook.Builder getCampaignHook() {
            return campaignHook != null ? campaignHook.toBuilder() : null;
        }

        @Override
        public final Builder campaignHook(CampaignHook campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        public final void setCampaignHook(CampaignHook.BuilderImpl campaignHook) {
            this.campaignHook = campaignHook != null ? campaignHook.build() : null;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final QuietTime.Builder getQuietTime() {
            return quietTime != null ? quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        @Override
        public ApplicationSettingsResource build() {
            return new ApplicationSettingsResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
