/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * APNS Message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class APNSMessage implements SdkPojo, Serializable, ToCopyableBuilder<APNSMessage.Builder, APNSMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Integer> BADGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(APNSMessage::badge)).setter(setter(Builder::badge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Badge").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> COLLAPSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::collapseId)).setter(setter(Builder::collapseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapseId").build()).build();

    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(APNSMessage::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::mediaUrl)).setter(setter(Builder::mediaUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()).build();

    private static final SdkField<String> PREFERRED_AUTHENTICATION_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::preferredAuthenticationMethod))
            .setter(setter(Builder::preferredAuthenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAuthenticationMethod")
                    .build()).build();

    private static final SdkField<String> PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> RAW_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::rawContent)).setter(setter(Builder::rawContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawContent").build()).build();

    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(APNSMessage::silentPush)).setter(setter(Builder::silentPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()).build();

    private static final SdkField<String> SOUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::sound)).setter(setter(Builder::sound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sound").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(APNSMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> THREAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::threadId)).setter(setter(Builder::threadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()).build();

    private static final SdkField<Integer> TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(APNSMessage::timeToLive)).setter(setter(Builder::timeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLive").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSMessage::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BADGE_FIELD,
            BODY_FIELD, CATEGORY_FIELD, COLLAPSE_ID_FIELD, DATA_FIELD, MEDIA_URL_FIELD, PREFERRED_AUTHENTICATION_METHOD_FIELD,
            PRIORITY_FIELD, RAW_CONTENT_FIELD, SILENT_PUSH_FIELD, SOUND_FIELD, SUBSTITUTIONS_FIELD, THREAD_ID_FIELD,
            TIME_TO_LIVE_FIELD, TITLE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final Integer badge;

    private final String body;

    private final String category;

    private final String collapseId;

    private final Map<String, String> data;

    private final String mediaUrl;

    private final String preferredAuthenticationMethod;

    private final String priority;

    private final String rawContent;

    private final Boolean silentPush;

    private final String sound;

    private final Map<String, List<String>> substitutions;

    private final String threadId;

    private final Integer timeToLive;

    private final String title;

    private final String url;

    private APNSMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.badge = builder.badge;
        this.body = builder.body;
        this.category = builder.category;
        this.collapseId = builder.collapseId;
        this.data = builder.data;
        this.mediaUrl = builder.mediaUrl;
        this.preferredAuthenticationMethod = builder.preferredAuthenticationMethod;
        this.priority = builder.priority;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.threadId = builder.threadId;
        this.timeToLive = builder.timeToLive;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page at
     * the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a
     *         designated user interface within the app. URL - The default mobile browser on the user's device launches
     *         and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page at
     * the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a
     *         designated user interface within the app. URL - The default mobile browser on the user's device launches
     *         and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * Include this key when you want the system to modify the badge of your app icon. If this key is not included in
     * the dictionary, the badge is not changed. To remove the badge, set the value of this key to 0.
     * 
     * @return Include this key when you want the system to modify the badge of your app icon. If this key is not
     *         included in the dictionary, the badge is not changed. To remove the badge, set the value of this key to
     *         0.
     */
    public Integer badge() {
        return badge;
    }

    /**
     * The message body of the notification.
     * 
     * @return The message body of the notification.
     */
    public String body() {
        return body;
    }

    /**
     * Provide this key with a string value that represents the notification's type. This value corresponds to the value
     * in the identifier property of one of your app's registered categories.
     * 
     * @return Provide this key with a string value that represents the notification's type. This value corresponds to
     *         the value in the identifier property of one of your app's registered categories.
     */
    public String category() {
        return category;
    }

    /**
     * An ID that, if assigned to multiple messages, causes APNs to coalesce the messages into a single push
     * notification instead of delivering each message individually. The value must not exceed 64 bytes. Amazon Pinpoint
     * uses this value to set the apns-collapse-id request header when it sends the message to APNs.
     * 
     * @return An ID that, if assigned to multiple messages, causes APNs to coalesce the messages into a single push
     *         notification instead of delivering each message individually. The value must not exceed 64 bytes. Amazon
     *         Pinpoint uses this value to set the apns-collapse-id request header when it sends the message to APNs.
     */
    public String collapseId() {
        return collapseId;
    }

    /**
     * The data payload used for a silent push. This payload is added to the notifications' data.pinpoint.jsonBody'
     * object
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data payload used for a silent push. This payload is added to the notifications'
     *         data.pinpoint.jsonBody' object
     */
    public Map<String, String> data() {
        return data;
    }

    /**
     * A URL that refers to the location of an image or video that you want to display in the push notification.
     * 
     * @return A URL that refers to the location of an image or video that you want to display in the push notification.
     */
    public String mediaUrl() {
        return mediaUrl;
    }

    /**
     * The preferred authentication method, either "CERTIFICATE" or "TOKEN"
     * 
     * @return The preferred authentication method, either "CERTIFICATE" or "TOKEN"
     */
    public String preferredAuthenticationMethod() {
        return preferredAuthenticationMethod;
    }

    /**
     * The message priority. Amazon Pinpoint uses this value to set the apns-priority request header when it sends the
     * message to APNs. Accepts the following values:
     *
     * "5" - Low priority. Messages might be delayed, delivered in groups, and throttled.
     *
     * "10" - High priority. Messages are sent immediately. High priority messages must cause an alert, sound, or badge
     * on the receiving device.
     *
     * The default value is "10".
     *
     * The equivalent values for FCM or GCM messages are "normal" and "high". Amazon Pinpoint accepts these values for
     * APNs messages and converts them.
     *
     * For more information about the apns-priority parameter, see Communicating with APNs in the APNs Local and Remote
     * Notification Programming Guide.
     * 
     * @return The message priority. Amazon Pinpoint uses this value to set the apns-priority request header when it
     *         sends the message to APNs. Accepts the following values:
     *
     *         "5" - Low priority. Messages might be delayed, delivered in groups, and throttled.
     *
     *         "10" - High priority. Messages are sent immediately. High priority messages must cause an alert, sound,
     *         or badge on the receiving device.
     *
     *         The default value is "10".
     *
     *         The equivalent values for FCM or GCM messages are "normal" and "high". Amazon Pinpoint accepts these
     *         values for APNs messages and converts them.
     *
     *         For more information about the apns-priority parameter, see Communicating with APNs in the APNs Local and
     *         Remote Notification Programming Guide.
     */
    public String priority() {
        return priority;
    }

    /**
     * The Raw JSON formatted string to be used as the payload. This value overrides the message.
     * 
     * @return The Raw JSON formatted string to be used as the payload. This value overrides the message.
     */
    public String rawContent() {
        return rawContent;
    }

    /**
     * Indicates if the message should display on the users device. Silent pushes can be used for Remote Configuration
     * and Phone Home use cases.
     * 
     * @return Indicates if the message should display on the users device. Silent pushes can be used for Remote
     *         Configuration and Phone Home use cases.
     */
    public Boolean silentPush() {
        return silentPush;
    }

    /**
     * Include this key when you want the system to play a sound. The value of this key is the name of a sound file in
     * your app's main bundle or in the Library/Sounds folder of your app's data container. If the sound file cannot be
     * found, or if you specify defaultfor the value, the system plays the default alert sound.
     * 
     * @return Include this key when you want the system to play a sound. The value of this key is the name of a sound
     *         file in your app's main bundle or in the Library/Sounds folder of your app's data container. If the sound
     *         file cannot be found, or if you specify defaultfor the value, the system plays the default alert sound.
     */
    public String sound() {
        return sound;
    }

    /**
     * Default message substitutions. Can be overridden by individual address substitutions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default message substitutions. Can be overridden by individual address substitutions.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * Provide this key with a string value that represents the app-specific identifier for grouping notifications. If
     * you provide a Notification Content app extension, you can use this value to group your notifications together.
     * 
     * @return Provide this key with a string value that represents the app-specific identifier for grouping
     *         notifications. If you provide a Notification Content app extension, you can use this value to group your
     *         notifications together.
     */
    public String threadId() {
        return threadId;
    }

    /**
     * The length of time (in seconds) that APNs stores and attempts to deliver the message. If the value is 0, APNs
     * does not store the message or attempt to deliver it more than once. Amazon Pinpoint uses this value to set the
     * apns-expiration request header when it sends the message to APNs.
     * 
     * @return The length of time (in seconds) that APNs stores and attempts to deliver the message. If the value is 0,
     *         APNs does not store the message or attempt to deliver it more than once. Amazon Pinpoint uses this value
     *         to set the apns-expiration request header when it sends the message to APNs.
     */
    public Integer timeToLive() {
        return timeToLive;
    }

    /**
     * The message title that displays above the message on the user's device.
     * 
     * @return The message title that displays above the message on the user's device.
     */
    public String title() {
        return title;
    }

    /**
     * The URL to open in the user's mobile browser. Used if the value for Action is URL.
     * 
     * @return The URL to open in the user's mobile browser. Used if the value for Action is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(badge());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(collapseId());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(preferredAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(sound());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(threadId());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSMessage)) {
            return false;
        }
        APNSMessage other = (APNSMessage) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(badge(), other.badge())
                && Objects.equals(body(), other.body()) && Objects.equals(category(), other.category())
                && Objects.equals(collapseId(), other.collapseId()) && Objects.equals(data(), other.data())
                && Objects.equals(mediaUrl(), other.mediaUrl())
                && Objects.equals(preferredAuthenticationMethod(), other.preferredAuthenticationMethod())
                && Objects.equals(priority(), other.priority()) && Objects.equals(rawContent(), other.rawContent())
                && Objects.equals(silentPush(), other.silentPush()) && Objects.equals(sound(), other.sound())
                && Objects.equals(substitutions(), other.substitutions()) && Objects.equals(threadId(), other.threadId())
                && Objects.equals(timeToLive(), other.timeToLive()) && Objects.equals(title(), other.title())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("APNSMessage").add("Action", actionAsString()).add("Badge", badge()).add("Body", body())
                .add("Category", category()).add("CollapseId", collapseId()).add("Data", data()).add("MediaUrl", mediaUrl())
                .add("PreferredAuthenticationMethod", preferredAuthenticationMethod()).add("Priority", priority())
                .add("RawContent", rawContent()).add("SilentPush", silentPush()).add("Sound", sound())
                .add("Substitutions", substitutions()).add("ThreadId", threadId()).add("TimeToLive", timeToLive())
                .add("Title", title()).add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Badge":
            return Optional.ofNullable(clazz.cast(badge()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "CollapseId":
            return Optional.ofNullable(clazz.cast(collapseId()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "MediaUrl":
            return Optional.ofNullable(clazz.cast(mediaUrl()));
        case "PreferredAuthenticationMethod":
            return Optional.ofNullable(clazz.cast(preferredAuthenticationMethod()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "RawContent":
            return Optional.ofNullable(clazz.cast(rawContent()));
        case "SilentPush":
            return Optional.ofNullable(clazz.cast(silentPush()));
        case "Sound":
            return Optional.ofNullable(clazz.cast(sound()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "ThreadId":
            return Optional.ofNullable(clazz.cast(threadId()));
        case "TimeToLive":
            return Optional.ofNullable(clazz.cast(timeToLive()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APNSMessage, T> g) {
        return obj -> g.apply((APNSMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APNSMessage> {
        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page
         * at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display
         *        a designated user interface within the app. URL - The default mobile browser on the user's device
         *        launches and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK |
         *        URL
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page
         * at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display
         *        a designated user interface within the app. URL - The default mobile browser on the user's device
         *        launches and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK |
         *        URL
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * Include this key when you want the system to modify the badge of your app icon. If this key is not included
         * in the dictionary, the badge is not changed. To remove the badge, set the value of this key to 0.
         * 
         * @param badge
         *        Include this key when you want the system to modify the badge of your app icon. If this key is not
         *        included in the dictionary, the badge is not changed. To remove the badge, set the value of this key
         *        to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badge(Integer badge);

        /**
         * The message body of the notification.
         * 
         * @param body
         *        The message body of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * Provide this key with a string value that represents the notification's type. This value corresponds to the
         * value in the identifier property of one of your app's registered categories.
         * 
         * @param category
         *        Provide this key with a string value that represents the notification's type. This value corresponds
         *        to the value in the identifier property of one of your app's registered categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * An ID that, if assigned to multiple messages, causes APNs to coalesce the messages into a single push
         * notification instead of delivering each message individually. The value must not exceed 64 bytes. Amazon
         * Pinpoint uses this value to set the apns-collapse-id request header when it sends the message to APNs.
         * 
         * @param collapseId
         *        An ID that, if assigned to multiple messages, causes APNs to coalesce the messages into a single push
         *        notification instead of delivering each message individually. The value must not exceed 64 bytes.
         *        Amazon Pinpoint uses this value to set the apns-collapse-id request header when it sends the message
         *        to APNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collapseId(String collapseId);

        /**
         * The data payload used for a silent push. This payload is added to the notifications' data.pinpoint.jsonBody'
         * object
         * 
         * @param data
         *        The data payload used for a silent push. This payload is added to the notifications'
         *        data.pinpoint.jsonBody' object
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Map<String, String> data);

        /**
         * A URL that refers to the location of an image or video that you want to display in the push notification.
         * 
         * @param mediaUrl
         *        A URL that refers to the location of an image or video that you want to display in the push
         *        notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrl(String mediaUrl);

        /**
         * The preferred authentication method, either "CERTIFICATE" or "TOKEN"
         * 
         * @param preferredAuthenticationMethod
         *        The preferred authentication method, either "CERTIFICATE" or "TOKEN"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAuthenticationMethod(String preferredAuthenticationMethod);

        /**
         * The message priority. Amazon Pinpoint uses this value to set the apns-priority request header when it sends
         * the message to APNs. Accepts the following values:
         *
         * "5" - Low priority. Messages might be delayed, delivered in groups, and throttled.
         *
         * "10" - High priority. Messages are sent immediately. High priority messages must cause an alert, sound, or
         * badge on the receiving device.
         *
         * The default value is "10".
         *
         * The equivalent values for FCM or GCM messages are "normal" and "high". Amazon Pinpoint accepts these values
         * for APNs messages and converts them.
         *
         * For more information about the apns-priority parameter, see Communicating with APNs in the APNs Local and
         * Remote Notification Programming Guide.
         * 
         * @param priority
         *        The message priority. Amazon Pinpoint uses this value to set the apns-priority request header when it
         *        sends the message to APNs. Accepts the following values:
         *
         *        "5" - Low priority. Messages might be delayed, delivered in groups, and throttled.
         *
         *        "10" - High priority. Messages are sent immediately. High priority messages must cause an alert,
         *        sound, or badge on the receiving device.
         *
         *        The default value is "10".
         *
         *        The equivalent values for FCM or GCM messages are "normal" and "high". Amazon Pinpoint accepts these
         *        values for APNs messages and converts them.
         *
         *        For more information about the apns-priority parameter, see Communicating with APNs in the APNs Local
         *        and Remote Notification Programming Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(String priority);

        /**
         * The Raw JSON formatted string to be used as the payload. This value overrides the message.
         * 
         * @param rawContent
         *        The Raw JSON formatted string to be used as the payload. This value overrides the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawContent(String rawContent);

        /**
         * Indicates if the message should display on the users device. Silent pushes can be used for Remote
         * Configuration and Phone Home use cases.
         * 
         * @param silentPush
         *        Indicates if the message should display on the users device. Silent pushes can be used for Remote
         *        Configuration and Phone Home use cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentPush(Boolean silentPush);

        /**
         * Include this key when you want the system to play a sound. The value of this key is the name of a sound file
         * in your app's main bundle or in the Library/Sounds folder of your app's data container. If the sound file
         * cannot be found, or if you specify defaultfor the value, the system plays the default alert sound.
         * 
         * @param sound
         *        Include this key when you want the system to play a sound. The value of this key is the name of a
         *        sound file in your app's main bundle or in the Library/Sounds folder of your app's data container. If
         *        the sound file cannot be found, or if you specify defaultfor the value, the system plays the default
         *        alert sound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sound(String sound);

        /**
         * Default message substitutions. Can be overridden by individual address substitutions.
         * 
         * @param substitutions
         *        Default message substitutions. Can be overridden by individual address substitutions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * Provide this key with a string value that represents the app-specific identifier for grouping notifications.
         * If you provide a Notification Content app extension, you can use this value to group your notifications
         * together.
         * 
         * @param threadId
         *        Provide this key with a string value that represents the app-specific identifier for grouping
         *        notifications. If you provide a Notification Content app extension, you can use this value to group
         *        your notifications together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadId(String threadId);

        /**
         * The length of time (in seconds) that APNs stores and attempts to deliver the message. If the value is 0, APNs
         * does not store the message or attempt to deliver it more than once. Amazon Pinpoint uses this value to set
         * the apns-expiration request header when it sends the message to APNs.
         * 
         * @param timeToLive
         *        The length of time (in seconds) that APNs stores and attempts to deliver the message. If the value is
         *        0, APNs does not store the message or attempt to deliver it more than once. Amazon Pinpoint uses this
         *        value to set the apns-expiration request header when it sends the message to APNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLive(Integer timeToLive);

        /**
         * The message title that displays above the message on the user's device.
         * 
         * @param title
         *        The message title that displays above the message on the user's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * 
         * @param url
         *        The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private Integer badge;

        private String body;

        private String category;

        private String collapseId;

        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();

        private String mediaUrl;

        private String preferredAuthenticationMethod;

        private String priority;

        private String rawContent;

        private Boolean silentPush;

        private String sound;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String threadId;

        private Integer timeToLive;

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSMessage model) {
            action(model.action);
            badge(model.badge);
            body(model.body);
            category(model.category);
            collapseId(model.collapseId);
            data(model.data);
            mediaUrl(model.mediaUrl);
            preferredAuthenticationMethod(model.preferredAuthenticationMethod);
            priority(model.priority);
            rawContent(model.rawContent);
            silentPush(model.silentPush);
            sound(model.sound);
            substitutions(model.substitutions);
            threadId(model.threadId);
            timeToLive(model.timeToLive);
            title(model.title);
            url(model.url);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getBadge() {
            return badge;
        }

        @Override
        public final Builder badge(Integer badge) {
            this.badge = badge;
            return this;
        }

        public final void setBadge(Integer badge) {
            this.badge = badge;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getCollapseId() {
            return collapseId;
        }

        @Override
        public final Builder collapseId(String collapseId) {
            this.collapseId = collapseId;
            return this;
        }

        public final void setCollapseId(String collapseId) {
            this.collapseId = collapseId;
        }

        public final Map<String, String> getData() {
            return data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getMediaUrl() {
            return mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getPreferredAuthenticationMethod() {
            return preferredAuthenticationMethod;
        }

        @Override
        public final Builder preferredAuthenticationMethod(String preferredAuthenticationMethod) {
            this.preferredAuthenticationMethod = preferredAuthenticationMethod;
            return this;
        }

        public final void setPreferredAuthenticationMethod(String preferredAuthenticationMethod) {
            this.preferredAuthenticationMethod = preferredAuthenticationMethod;
        }

        public final String getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(String priority) {
            this.priority = priority;
        }

        public final String getRawContent() {
            return rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSound() {
            return sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getThreadId() {
            return threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final Integer getTimeToLive() {
            return timeToLive;
        }

        @Override
        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final void setTimeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public APNSMessage build() {
            return new APNSMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
