/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies geographical dimension settings for a segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentLocation implements SdkPojo, Serializable, ToCopyableBuilder<SegmentLocation.Builder, SegmentLocation> {
    private static final SdkField<SetDimension> COUNTRY_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Country").getter(getter(SegmentLocation::country)).setter(setter(Builder::country))
            .constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<GPSPointDimension> GPS_POINT_FIELD = SdkField
            .<GPSPointDimension> builder(MarshallingType.SDK_POJO).memberName("GPSPoint")
            .getter(getter(SegmentLocation::gpsPoint)).setter(setter(Builder::gpsPoint)).constructor(GPSPointDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GPSPoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COUNTRY_FIELD, GPS_POINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SetDimension country;

    private final GPSPointDimension gpsPoint;

    private SegmentLocation(BuilderImpl builder) {
        this.country = builder.country;
        this.gpsPoint = builder.gpsPoint;
    }

    /**
     * <p>
     * The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
     * </p>
     * 
     * @return The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
     */
    public final SetDimension country() {
        return country;
    }

    /**
     * <p>
     * The GPS location and range for the segment.
     * </p>
     * 
     * @return The GPS location and range for the segment.
     */
    public final GPSPointDimension gpsPoint() {
        return gpsPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(gpsPoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentLocation)) {
            return false;
        }
        SegmentLocation other = (SegmentLocation) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(gpsPoint(), other.gpsPoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentLocation").add("Country", country()).add("GPSPoint", gpsPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "GPSPoint":
            return Optional.ofNullable(clazz.cast(gpsPoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentLocation, T> g) {
        return obj -> g.apply((SegmentLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentLocation> {
        /**
         * <p>
         * The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
         * </p>
         * 
         * @param country
         *        The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(SetDimension country);

        /**
         * <p>
         * The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetDimension.Builder} avoiding the need
         * to create one manually via {@link SetDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #country(SetDimension)}.
         * 
         * @param country
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(SetDimension)
         */
        default Builder country(Consumer<SetDimension.Builder> country) {
            return country(SetDimension.builder().applyMutation(country).build());
        }

        /**
         * <p>
         * The GPS location and range for the segment.
         * </p>
         * 
         * @param gpsPoint
         *        The GPS location and range for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpsPoint(GPSPointDimension gpsPoint);

        /**
         * <p>
         * The GPS location and range for the segment.
         * </p>
         * This is a convenience method that creates an instance of the {@link GPSPointDimension.Builder} avoiding the
         * need to create one manually via {@link GPSPointDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GPSPointDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #gpsPoint(GPSPointDimension)}.
         * 
         * @param gpsPoint
         *        a consumer that will call methods on {@link GPSPointDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gpsPoint(GPSPointDimension)
         */
        default Builder gpsPoint(Consumer<GPSPointDimension.Builder> gpsPoint) {
            return gpsPoint(GPSPointDimension.builder().applyMutation(gpsPoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SetDimension country;

        private GPSPointDimension gpsPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentLocation model) {
            country(model.country);
            gpsPoint(model.gpsPoint);
        }

        public final SetDimension.Builder getCountry() {
            return country != null ? country.toBuilder() : null;
        }

        public final void setCountry(SetDimension.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(SetDimension country) {
            this.country = country;
            return this;
        }

        public final GPSPointDimension.Builder getGpsPoint() {
            return gpsPoint != null ? gpsPoint.toBuilder() : null;
        }

        public final void setGpsPoint(GPSPointDimension.BuilderImpl gpsPoint) {
            this.gpsPoint = gpsPoint != null ? gpsPoint.build() : null;
        }

        @Override
        public final Builder gpsPoint(GPSPointDimension gpsPoint) {
            this.gpsPoint = gpsPoint;
            return this;
        }

        @Override
        public SegmentLocation build() {
            return new SegmentLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
