/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.DayOfWeek;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOfOpenHoursRulesCopier;
import software.amazon.awssdk.services.pinpoint.model.OpenHoursRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenHours
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenHours> {
    private static final SdkField<Map<String, List<OpenHoursRule>>> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EMAIL").getter(OpenHours.getter(OpenHours::emailAsStrings)).setter(OpenHours.setter(Builder::emailWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMAIL").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenHoursRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<OpenHoursRule>>> SMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SMS").getter(OpenHours.getter(OpenHours::smsAsStrings)).setter(OpenHours.setter(Builder::smsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMS").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenHoursRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<OpenHoursRule>>> PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PUSH").getter(OpenHours.getter(OpenHours::pushAsStrings)).setter(OpenHours.setter(Builder::pushWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PUSH").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenHoursRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<OpenHoursRule>>> VOICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("VOICE").getter(OpenHours.getter(OpenHours::voiceAsStrings)).setter(OpenHours.setter(Builder::voiceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VOICE").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenHoursRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<OpenHoursRule>>> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CUSTOM").getter(OpenHours.getter(OpenHours::customAsStrings)).setter(OpenHours.setter(Builder::customWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CUSTOM").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenHoursRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, SMS_FIELD, PUSH_FIELD, VOICE_FIELD, CUSTOM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, List<OpenHoursRule>> email;
    private final Map<String, List<OpenHoursRule>> sms;
    private final Map<String, List<OpenHoursRule>> push;
    private final Map<String, List<OpenHoursRule>> voice;
    private final Map<String, List<OpenHoursRule>> custom;

    private OpenHours(BuilderImpl builder) {
        this.email = builder.email;
        this.sms = builder.sms;
        this.push = builder.push;
        this.voice = builder.voice;
        this.custom = builder.custom;
    }

    public final Map<DayOfWeek, List<OpenHoursRule>> email() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(this.email);
    }

    public final boolean hasEmail() {
        return this.email != null && !(this.email instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<OpenHoursRule>> emailAsStrings() {
        return this.email;
    }

    public final Map<DayOfWeek, List<OpenHoursRule>> sms() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(this.sms);
    }

    public final boolean hasSms() {
        return this.sms != null && !(this.sms instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<OpenHoursRule>> smsAsStrings() {
        return this.sms;
    }

    public final Map<DayOfWeek, List<OpenHoursRule>> push() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(this.push);
    }

    public final boolean hasPush() {
        return this.push != null && !(this.push instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<OpenHoursRule>> pushAsStrings() {
        return this.push;
    }

    public final Map<DayOfWeek, List<OpenHoursRule>> voice() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(this.voice);
    }

    public final boolean hasVoice() {
        return this.voice != null && !(this.voice instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<OpenHoursRule>> voiceAsStrings() {
        return this.voice;
    }

    public final Map<DayOfWeek, List<OpenHoursRule>> custom() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(this.custom);
    }

    public final boolean hasCustom() {
        return this.custom != null && !(this.custom instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<OpenHoursRule>> customAsStrings() {
        return this.custom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmail() ? this.emailAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSms() ? this.smsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPush() ? this.pushAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoice() ? this.voiceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustom() ? this.customAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenHours)) {
            return false;
        }
        OpenHours other = (OpenHours)obj;
        return this.hasEmail() == other.hasEmail() && Objects.equals(this.emailAsStrings(), other.emailAsStrings()) && this.hasSms() == other.hasSms() && Objects.equals(this.smsAsStrings(), other.smsAsStrings()) && this.hasPush() == other.hasPush() && Objects.equals(this.pushAsStrings(), other.pushAsStrings()) && this.hasVoice() == other.hasVoice() && Objects.equals(this.voiceAsStrings(), other.voiceAsStrings()) && this.hasCustom() == other.hasCustom() && Objects.equals(this.customAsStrings(), other.customAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"OpenHours").add("EMAIL", this.hasEmail() ? this.emailAsStrings() : null).add("SMS", this.hasSms() ? this.smsAsStrings() : null).add("PUSH", this.hasPush() ? this.pushAsStrings() : null).add("VOICE", this.hasVoice() ? this.voiceAsStrings() : null).add("CUSTOM", this.hasCustom() ? this.customAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EMAIL": {
                return Optional.ofNullable(clazz.cast(this.emailAsStrings()));
            }
            case "SMS": {
                return Optional.ofNullable(clazz.cast(this.smsAsStrings()));
            }
            case "PUSH": {
                return Optional.ofNullable(clazz.cast(this.pushAsStrings()));
            }
            case "VOICE": {
                return Optional.ofNullable(clazz.cast(this.voiceAsStrings()));
            }
            case "CUSTOM": {
                return Optional.ofNullable(clazz.cast(this.customAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenHours, T> g) {
        return obj -> g.apply((OpenHours)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<OpenHoursRule>> email = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<OpenHoursRule>> sms = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<OpenHoursRule>> push = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<OpenHoursRule>> voice = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<OpenHoursRule>> custom = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenHours model) {
            this.emailWithStrings(model.email);
            this.smsWithStrings(model.sms);
            this.pushWithStrings(model.push);
            this.voiceWithStrings(model.voice);
            this.customWithStrings(model.custom);
        }

        public final Map<String, List<OpenHoursRule.Builder>> getEmail() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.email);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEmail(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> email) {
            this.email = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(email);
        }

        @Override
        public final Builder emailWithStrings(Map<String, ? extends Collection<OpenHoursRule>> email) {
            this.email = MapOfListOfOpenHoursRulesCopier.copy(email);
            return this;
        }

        @Override
        public final Builder email(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> email) {
            this.email = MapOfListOfOpenHoursRulesCopier.copyEnumToString(email);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getSms() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.sms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSms(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> sms) {
            this.sms = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(sms);
        }

        @Override
        public final Builder smsWithStrings(Map<String, ? extends Collection<OpenHoursRule>> sms) {
            this.sms = MapOfListOfOpenHoursRulesCopier.copy(sms);
            return this;
        }

        @Override
        public final Builder sms(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> sms) {
            this.sms = MapOfListOfOpenHoursRulesCopier.copyEnumToString(sms);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getPush() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.push);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPush(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> push) {
            this.push = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(push);
        }

        @Override
        public final Builder pushWithStrings(Map<String, ? extends Collection<OpenHoursRule>> push) {
            this.push = MapOfListOfOpenHoursRulesCopier.copy(push);
            return this;
        }

        @Override
        public final Builder push(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> push) {
            this.push = MapOfListOfOpenHoursRulesCopier.copyEnumToString(push);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getVoice() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.voice);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVoice(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> voice) {
            this.voice = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(voice);
        }

        @Override
        public final Builder voiceWithStrings(Map<String, ? extends Collection<OpenHoursRule>> voice) {
            this.voice = MapOfListOfOpenHoursRulesCopier.copy(voice);
            return this;
        }

        @Override
        public final Builder voice(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> voice) {
            this.voice = MapOfListOfOpenHoursRulesCopier.copyEnumToString(voice);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getCustom() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.custom);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustom(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> custom) {
            this.custom = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(custom);
        }

        @Override
        public final Builder customWithStrings(Map<String, ? extends Collection<OpenHoursRule>> custom) {
            this.custom = MapOfListOfOpenHoursRulesCopier.copy(custom);
            return this;
        }

        @Override
        public final Builder custom(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> custom) {
            this.custom = MapOfListOfOpenHoursRulesCopier.copyEnumToString(custom);
            return this;
        }

        public OpenHours build() {
            return new OpenHours(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenHours> {
        public Builder emailWithStrings(Map<String, ? extends Collection<OpenHoursRule>> var1);

        public Builder email(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> var1);

        public Builder smsWithStrings(Map<String, ? extends Collection<OpenHoursRule>> var1);

        public Builder sms(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> var1);

        public Builder pushWithStrings(Map<String, ? extends Collection<OpenHoursRule>> var1);

        public Builder push(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> var1);

        public Builder voiceWithStrings(Map<String, ? extends Collection<OpenHoursRule>> var1);

        public Builder voice(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> var1);

        public Builder customWithStrings(Map<String, ? extends Collection<OpenHoursRule>> var1);

        public Builder custom(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> var1);
    }
}

