/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.InAppMessageContent;
import software.amazon.awssdk.services.pinpoint.model.Layout;
import software.amazon.awssdk.services.pinpoint.model.ListOfInAppMessageContentCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppTemplateResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(InAppTemplateResponse.getter(InAppTemplateResponse::arn)).setter(InAppTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<InAppMessageContent>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Content").getter(InAppTemplateResponse.getter(InAppTemplateResponse::content)).setter(InAppTemplateResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InAppMessageContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(InAppTemplateResponse.getter(InAppTemplateResponse::creationDate)).setter(InAppTemplateResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomConfig").getter(InAppTemplateResponse.getter(InAppTemplateResponse::customConfig)).setter(InAppTemplateResponse.setter(Builder::customConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(InAppTemplateResponse.getter(InAppTemplateResponse::lastModifiedDate)).setter(InAppTemplateResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Layout").getter(InAppTemplateResponse.getter(InAppTemplateResponse::layoutAsString)).setter(InAppTemplateResponse.setter(Builder::layout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(InAppTemplateResponse.getter(InAppTemplateResponse::tags)).setter(InAppTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateDescription").getter(InAppTemplateResponse.getter(InAppTemplateResponse::templateDescription)).setter(InAppTemplateResponse.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(InAppTemplateResponse.getter(InAppTemplateResponse::templateName)).setter(InAppTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(InAppTemplateResponse.getter(InAppTemplateResponse::templateTypeAsString)).setter(InAppTemplateResponse.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(InAppTemplateResponse.getter(InAppTemplateResponse::version)).setter(InAppTemplateResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONTENT_FIELD, CREATION_DATE_FIELD, CUSTOM_CONFIG_FIELD, LAST_MODIFIED_DATE_FIELD, LAYOUT_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<InAppMessageContent> content;
    private final String creationDate;
    private final Map<String, String> customConfig;
    private final String lastModifiedDate;
    private final String layout;
    private final Map<String, String> tags;
    private final String templateDescription;
    private final String templateName;
    private final String templateType;
    private final String version;

    private InAppTemplateResponse(BuilderImpl builder) {
        this.arn = builder.arn;
        this.content = builder.content;
        this.creationDate = builder.creationDate;
        this.customConfig = builder.customConfig;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.layout = builder.layout;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.version = builder.version;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<InAppMessageContent> content() {
        return this.content;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final boolean hasCustomConfig() {
        return this.customConfig != null && !(this.customConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customConfig() {
        return this.customConfig;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Layout layout() {
        return Layout.fromValue(this.layout);
    }

    public final String layoutAsString() {
        return this.layout;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String templateDescription() {
        return this.templateDescription;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomConfig() ? this.customConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppTemplateResponse)) {
            return false;
        }
        InAppTemplateResponse other = (InAppTemplateResponse)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content()) && Objects.equals(this.creationDate(), other.creationDate()) && this.hasCustomConfig() == other.hasCustomConfig() && Objects.equals(this.customConfig(), other.customConfig()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.layoutAsString(), other.layoutAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"InAppTemplateResponse").add("Arn", (Object)this.arn()).add("Content", this.hasContent() ? this.content() : null).add("CreationDate", (Object)this.creationDate()).add("CustomConfig", this.hasCustomConfig() ? this.customConfig() : null).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Layout", (Object)this.layoutAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateDescription", (Object)this.templateDescription()).add("TemplateName", (Object)this.templateName()).add("TemplateType", (Object)this.templateTypeAsString()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CustomConfig": {
                return Optional.ofNullable(clazz.cast(this.customConfig()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Layout": {
                return Optional.ofNullable(clazz.cast(this.layoutAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppTemplateResponse, T> g) {
        return obj -> g.apply((InAppTemplateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<InAppMessageContent> content = DefaultSdkAutoConstructList.getInstance();
        private String creationDate;
        private Map<String, String> customConfig = DefaultSdkAutoConstructMap.getInstance();
        private String lastModifiedDate;
        private String layout;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;
        private String templateName;
        private String templateType;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppTemplateResponse model) {
            this.arn(model.arn);
            this.content(model.content);
            this.creationDate(model.creationDate);
            this.customConfig(model.customConfig);
            this.lastModifiedDate(model.lastModifiedDate);
            this.layout(model.layout);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
            this.templateName(model.templateName);
            this.templateType(model.templateType);
            this.version(model.version);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<InAppMessageContent.Builder> getContent() {
            List<InAppMessageContent.Builder> result = ListOfInAppMessageContentCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<InAppMessageContent.BuilderImpl> content) {
            this.content = ListOfInAppMessageContentCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<InAppMessageContent> content) {
            this.content = ListOfInAppMessageContentCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(InAppMessageContent ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<InAppMessageContent.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (InAppMessageContent)((InAppMessageContent.Builder)InAppMessageContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Map<String, String> getCustomConfig() {
            if (this.customConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customConfig;
        }

        public final void setCustomConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
        }

        @Override
        public final Builder customConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLayout() {
            return this.layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public final Builder layout(Layout layout) {
            this.layout(layout == null ? null : layout.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public InAppTemplateResponse build() {
            return new InAppTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppTemplateResponse> {
        public Builder arn(String var1);

        public Builder content(Collection<InAppMessageContent> var1);

        public Builder content(InAppMessageContent ... var1);

        public Builder content(Consumer<InAppMessageContent.Builder> ... var1);

        public Builder creationDate(String var1);

        public Builder customConfig(Map<String, String> var1);

        public Builder lastModifiedDate(String var1);

        public Builder layout(String var1);

        public Builder layout(Layout var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);

        public Builder templateName(String var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder version(String var1);
    }
}

