/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more attributes to remove from all the endpoints that are associated with an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAttributesRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateAttributesRequest.Builder, UpdateAttributesRequest> {
    private static final SdkField<List<String>> BLACKLIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Blacklist")
            .getter(getter(UpdateAttributesRequest::blacklist))
            .setter(setter(Builder::blacklist))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blacklist").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKLIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> blacklist;

    private UpdateAttributesRequest(BuilderImpl builder) {
        this.blacklist = builder.blacklist;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blacklist property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlacklist() {
        return blacklist != null && !(blacklist instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the attributes to remove from all the endpoints that are associated with the application. The array
     * can specify the complete, exact name of each attribute to remove or it can specify a glob pattern that an
     * attribute name must match in order for the attribute to be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlacklist} method.
     * </p>
     * 
     * @return An array of the attributes to remove from all the endpoints that are associated with the application. The
     *         array can specify the complete, exact name of each attribute to remove or it can specify a glob pattern
     *         that an attribute name must match in order for the attribute to be removed.
     */
    public final List<String> blacklist() {
        return blacklist;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlacklist() ? blacklist() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAttributesRequest)) {
            return false;
        }
        UpdateAttributesRequest other = (UpdateAttributesRequest) obj;
        return hasBlacklist() == other.hasBlacklist() && Objects.equals(blacklist(), other.blacklist());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAttributesRequest").add("Blacklist", hasBlacklist() ? blacklist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blacklist":
            return Optional.ofNullable(clazz.cast(blacklist()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAttributesRequest, T> g) {
        return obj -> g.apply((UpdateAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateAttributesRequest> {
        /**
         * <p>
         * An array of the attributes to remove from all the endpoints that are associated with the application. The
         * array can specify the complete, exact name of each attribute to remove or it can specify a glob pattern that
         * an attribute name must match in order for the attribute to be removed.
         * </p>
         * 
         * @param blacklist
         *        An array of the attributes to remove from all the endpoints that are associated with the application.
         *        The array can specify the complete, exact name of each attribute to remove or it can specify a glob
         *        pattern that an attribute name must match in order for the attribute to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blacklist(Collection<String> blacklist);

        /**
         * <p>
         * An array of the attributes to remove from all the endpoints that are associated with the application. The
         * array can specify the complete, exact name of each attribute to remove or it can specify a glob pattern that
         * an attribute name must match in order for the attribute to be removed.
         * </p>
         * 
         * @param blacklist
         *        An array of the attributes to remove from all the endpoints that are associated with the application.
         *        The array can specify the complete, exact name of each attribute to remove or it can specify a glob
         *        pattern that an attribute name must match in order for the attribute to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blacklist(String... blacklist);
    }

    static final class BuilderImpl implements Builder {
        private List<String> blacklist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAttributesRequest model) {
            blacklist(model.blacklist);
        }

        public final Collection<String> getBlacklist() {
            if (blacklist instanceof SdkAutoConstructList) {
                return null;
            }
            return blacklist;
        }

        public final void setBlacklist(Collection<String> blacklist) {
            this.blacklist = ListOf__stringCopier.copy(blacklist);
        }

        @Override
        public final Builder blacklist(Collection<String> blacklist) {
            this.blacklist = ListOf__stringCopier.copy(blacklist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blacklist(String... blacklist) {
            blacklist(Arrays.asList(blacklist));
            return this;
        }

        @Override
        public UpdateAttributesRequest build() {
            return new UpdateAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
