/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.JourneyTimeframeCap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSettingsJourneyLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSettingsJourneyLimits> {
    private static final SdkField<Integer> DAILY_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DailyCap").getter(ApplicationSettingsJourneyLimits.getter(ApplicationSettingsJourneyLimits::dailyCap)).setter(ApplicationSettingsJourneyLimits.setter(Builder::dailyCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCap").build()}).build();
    private static final SdkField<JourneyTimeframeCap> TIMEFRAME_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeframeCap").getter(ApplicationSettingsJourneyLimits.getter(ApplicationSettingsJourneyLimits::timeframeCap)).setter(ApplicationSettingsJourneyLimits.setter(Builder::timeframeCap)).constructor(JourneyTimeframeCap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeframeCap").build()}).build();
    private static final SdkField<Integer> TOTAL_CAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCap").getter(ApplicationSettingsJourneyLimits.getter(ApplicationSettingsJourneyLimits::totalCap)).setter(ApplicationSettingsJourneyLimits.setter(Builder::totalCap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCap").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_CAP_FIELD, TIMEFRAME_CAP_FIELD, TOTAL_CAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dailyCap;
    private final JourneyTimeframeCap timeframeCap;
    private final Integer totalCap;

    private ApplicationSettingsJourneyLimits(BuilderImpl builder) {
        this.dailyCap = builder.dailyCap;
        this.timeframeCap = builder.timeframeCap;
        this.totalCap = builder.totalCap;
    }

    public final Integer dailyCap() {
        return this.dailyCap;
    }

    public final JourneyTimeframeCap timeframeCap() {
        return this.timeframeCap;
    }

    public final Integer totalCap() {
        return this.totalCap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeframeCap());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCap());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsJourneyLimits)) {
            return false;
        }
        ApplicationSettingsJourneyLimits other = (ApplicationSettingsJourneyLimits)obj;
        return Objects.equals(this.dailyCap(), other.dailyCap()) && Objects.equals(this.timeframeCap(), other.timeframeCap()) && Objects.equals(this.totalCap(), other.totalCap());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSettingsJourneyLimits").add("DailyCap", (Object)this.dailyCap()).add("TimeframeCap", (Object)this.timeframeCap()).add("TotalCap", (Object)this.totalCap()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DailyCap": {
                return Optional.ofNullable(clazz.cast(this.dailyCap()));
            }
            case "TimeframeCap": {
                return Optional.ofNullable(clazz.cast(this.timeframeCap()));
            }
            case "TotalCap": {
                return Optional.ofNullable(clazz.cast(this.totalCap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsJourneyLimits, T> g) {
        return obj -> g.apply((ApplicationSettingsJourneyLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dailyCap;
        private JourneyTimeframeCap timeframeCap;
        private Integer totalCap;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsJourneyLimits model) {
            this.dailyCap(model.dailyCap);
            this.timeframeCap(model.timeframeCap);
            this.totalCap(model.totalCap);
        }

        public final Integer getDailyCap() {
            return this.dailyCap;
        }

        public final void setDailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
        }

        @Override
        public final Builder dailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
            return this;
        }

        public final JourneyTimeframeCap.Builder getTimeframeCap() {
            return this.timeframeCap != null ? this.timeframeCap.toBuilder() : null;
        }

        public final void setTimeframeCap(JourneyTimeframeCap.BuilderImpl timeframeCap) {
            this.timeframeCap = timeframeCap != null ? timeframeCap.build() : null;
        }

        @Override
        public final Builder timeframeCap(JourneyTimeframeCap timeframeCap) {
            this.timeframeCap = timeframeCap;
            return this;
        }

        public final Integer getTotalCap() {
            return this.totalCap;
        }

        public final void setTotalCap(Integer totalCap) {
            this.totalCap = totalCap;
        }

        @Override
        public final Builder totalCap(Integer totalCap) {
            this.totalCap = totalCap;
            return this;
        }

        public ApplicationSettingsJourneyLimits build() {
            return new ApplicationSettingsJourneyLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSettingsJourneyLimits> {
        public Builder dailyCap(Integer var1);

        public Builder timeframeCap(JourneyTimeframeCap var1);

        default public Builder timeframeCap(Consumer<JourneyTimeframeCap.Builder> timeframeCap) {
            return this.timeframeCap((JourneyTimeframeCap)((JourneyTimeframeCap.Builder)JourneyTimeframeCap.builder().applyMutation(timeframeCap)).build());
        }

        public Builder totalCap(Integer var1);
    }
}

