/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the configuration and other settings for all the campaigns that are associated with an
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignsResponse.Builder, CampaignsResponse> {
    private static final SdkField<List<CampaignResponse>> ITEM_FIELD = SdkField
            .<List<CampaignResponse>> builder(MarshallingType.LIST)
            .memberName("Item")
            .getter(getter(CampaignsResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CampaignResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(CampaignResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(CampaignsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CampaignResponse> item;

    private final String nextToken;

    private CampaignsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Item property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of responses, one for each campaign that's associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItem} method.
     * </p>
     * 
     * @return An array of responses, one for each campaign that's associated with the application.
     */
    public final List<CampaignResponse> item() {
        return item;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItem() ? item() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignsResponse)) {
            return false;
        }
        CampaignsResponse other = (CampaignsResponse) obj;
        return hasItem() == other.hasItem() && Objects.equals(item(), other.item())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignsResponse").add("Item", hasItem() ? item() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignsResponse, T> g) {
        return obj -> g.apply((CampaignsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignsResponse> {
        /**
         * <p>
         * An array of responses, one for each campaign that's associated with the application.
         * </p>
         * 
         * @param item
         *        An array of responses, one for each campaign that's associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<CampaignResponse> item);

        /**
         * <p>
         * An array of responses, one for each campaign that's associated with the application.
         * </p>
         * 
         * @param item
         *        An array of responses, one for each campaign that's associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(CampaignResponse... item);

        /**
         * <p>
         * An array of responses, one for each campaign that's associated with the application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.CampaignResponse.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pinpoint.model.CampaignResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.CampaignResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #item(List<CampaignResponse>)}.
         * 
         * @param item
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.CampaignResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(java.util.Collection<CampaignResponse>)
         */
        Builder item(Consumer<CampaignResponse.Builder>... item);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<CampaignResponse> item = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignsResponse model) {
            item(model.item);
            nextToken(model.nextToken);
        }

        public final List<CampaignResponse.Builder> getItem() {
            List<CampaignResponse.Builder> result = ListOfCampaignResponseCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItem(Collection<CampaignResponse.BuilderImpl> item) {
            this.item = ListOfCampaignResponseCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Collection<CampaignResponse> item) {
            this.item = ListOfCampaignResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(CampaignResponse... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<CampaignResponse.Builder>... item) {
            item(Stream.of(item).map(c -> CampaignResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public CampaignsResponse build() {
            return new CampaignsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
