/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.CampaignHook;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.CustomDeliveryConfiguration;
import software.amazon.awssdk.services.pinpoint.model.ListOfWriteTreatmentResourceCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration;
import software.amazon.awssdk.services.pinpoint.model.WriteTreatmentResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteCampaignRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteCampaignRequest> {
    private static final SdkField<List<WriteTreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalTreatments").getter(WriteCampaignRequest.getter(WriteCampaignRequest::additionalTreatments)).setter(WriteCampaignRequest.setter(Builder::additionalTreatments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WriteTreatmentResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomDeliveryConfiguration> CUSTOM_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDeliveryConfiguration").getter(WriteCampaignRequest.getter(WriteCampaignRequest::customDeliveryConfiguration)).setter(WriteCampaignRequest.setter(Builder::customDeliveryConfiguration)).constructor(CustomDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDeliveryConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(WriteCampaignRequest.getter(WriteCampaignRequest::description)).setter(WriteCampaignRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HoldoutPercent").getter(WriteCampaignRequest.getter(WriteCampaignRequest::holdoutPercent)).setter(WriteCampaignRequest.setter(Builder::holdoutPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()}).build();
    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Hook").getter(WriteCampaignRequest.getter(WriteCampaignRequest::hook)).setter(WriteCampaignRequest.setter(Builder::hook)).constructor(CampaignHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()}).build();
    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPaused").getter(WriteCampaignRequest.getter(WriteCampaignRequest::isPaused)).setter(WriteCampaignRequest.setter(Builder::isPaused)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()}).build();
    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limits").getter(WriteCampaignRequest.getter(WriteCampaignRequest::limits)).setter(WriteCampaignRequest.setter(Builder::limits)).constructor(CampaignLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()}).build();
    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageConfiguration").getter(WriteCampaignRequest.getter(WriteCampaignRequest::messageConfiguration)).setter(WriteCampaignRequest.setter(Builder::messageConfiguration)).constructor(MessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WriteCampaignRequest.getter(WriteCampaignRequest::name)).setter(WriteCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(WriteCampaignRequest.getter(WriteCampaignRequest::schedule)).setter(WriteCampaignRequest.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentId").getter(WriteCampaignRequest.getter(WriteCampaignRequest::segmentId)).setter(WriteCampaignRequest.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()}).build();
    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentVersion").getter(WriteCampaignRequest.getter(WriteCampaignRequest::segmentVersion)).setter(WriteCampaignRequest.setter(Builder::segmentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(WriteCampaignRequest.getter(WriteCampaignRequest::tags)).setter(WriteCampaignRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(WriteCampaignRequest.getter(WriteCampaignRequest::templateConfiguration)).setter(WriteCampaignRequest.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentDescription").getter(WriteCampaignRequest.getter(WriteCampaignRequest::treatmentDescription)).setter(WriteCampaignRequest.setter(Builder::treatmentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatmentName").getter(WriteCampaignRequest.getter(WriteCampaignRequest::treatmentName)).setter(WriteCampaignRequest.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(WriteCampaignRequest.getter(WriteCampaignRequest::priority)).setter(WriteCampaignRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD, CUSTOM_DELIVERY_CONFIGURATION_FIELD, DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD, HOOK_FIELD, IS_PAUSED_FIELD, LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD, NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD, TAGS_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD, PRIORITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<WriteTreatmentResource> additionalTreatments;
    private final CustomDeliveryConfiguration customDeliveryConfiguration;
    private final String description;
    private final Integer holdoutPercent;
    private final CampaignHook hook;
    private final Boolean isPaused;
    private final CampaignLimits limits;
    private final MessageConfiguration messageConfiguration;
    private final String name;
    private final Schedule schedule;
    private final String segmentId;
    private final Integer segmentVersion;
    private final Map<String, String> tags;
    private final TemplateConfiguration templateConfiguration;
    private final String treatmentDescription;
    private final String treatmentName;
    private final Integer priority;

    private WriteCampaignRequest(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.isPaused = builder.isPaused;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.tags = builder.tags;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.priority = builder.priority;
    }

    public final boolean hasAdditionalTreatments() {
        return this.additionalTreatments != null && !(this.additionalTreatments instanceof SdkAutoConstructList);
    }

    public final List<WriteTreatmentResource> additionalTreatments() {
        return this.additionalTreatments;
    }

    public final CustomDeliveryConfiguration customDeliveryConfiguration() {
        return this.customDeliveryConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final Integer holdoutPercent() {
        return this.holdoutPercent;
    }

    public final CampaignHook hook() {
        return this.hook;
    }

    public final Boolean isPaused() {
        return this.isPaused;
    }

    public final CampaignLimits limits() {
        return this.limits;
    }

    public final MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final Integer segmentVersion() {
        return this.segmentVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final String treatmentDescription() {
        return this.treatmentDescription;
    }

    public final String treatmentName() {
        return this.treatmentName;
    }

    public final Integer priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalTreatments() ? this.additionalTreatments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hook());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(this.limits());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteCampaignRequest)) {
            return false;
        }
        WriteCampaignRequest other = (WriteCampaignRequest)obj;
        return this.hasAdditionalTreatments() == other.hasAdditionalTreatments() && Objects.equals(this.additionalTreatments(), other.additionalTreatments()) && Objects.equals(this.customDeliveryConfiguration(), other.customDeliveryConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.holdoutPercent(), other.holdoutPercent()) && Objects.equals(this.hook(), other.hook()) && Objects.equals(this.isPaused(), other.isPaused()) && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.segmentVersion(), other.segmentVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.treatmentDescription(), other.treatmentDescription()) && Objects.equals(this.treatmentName(), other.treatmentName()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"WriteCampaignRequest").add("AdditionalTreatments", this.hasAdditionalTreatments() ? this.additionalTreatments() : null).add("CustomDeliveryConfiguration", (Object)this.customDeliveryConfiguration()).add("Description", (Object)this.description()).add("HoldoutPercent", (Object)this.holdoutPercent()).add("Hook", (Object)this.hook()).add("IsPaused", (Object)this.isPaused()).add("Limits", (Object)this.limits()).add("MessageConfiguration", (Object)this.messageConfiguration()).add("Name", (Object)this.name()).add("Schedule", (Object)this.schedule()).add("SegmentId", (Object)this.segmentId()).add("SegmentVersion", (Object)this.segmentVersion()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TreatmentDescription", (Object)this.treatmentDescription()).add("TreatmentName", (Object)this.treatmentName()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalTreatments": {
                return Optional.ofNullable(clazz.cast(this.additionalTreatments()));
            }
            case "CustomDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customDeliveryConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HoldoutPercent": {
                return Optional.ofNullable(clazz.cast(this.holdoutPercent()));
            }
            case "Hook": {
                return Optional.ofNullable(clazz.cast(this.hook()));
            }
            case "IsPaused": {
                return Optional.ofNullable(clazz.cast(this.isPaused()));
            }
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "MessageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.messageConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.ofNullable(clazz.cast(this.segmentVersion()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "TreatmentDescription": {
                return Optional.ofNullable(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteCampaignRequest, T> g) {
        return obj -> g.apply((WriteCampaignRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WriteTreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();
        private CustomDeliveryConfiguration customDeliveryConfiguration;
        private String description;
        private Integer holdoutPercent;
        private CampaignHook hook;
        private Boolean isPaused;
        private CampaignLimits limits;
        private MessageConfiguration messageConfiguration;
        private String name;
        private Schedule schedule;
        private String segmentId;
        private Integer segmentVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TemplateConfiguration templateConfiguration;
        private String treatmentDescription;
        private String treatmentName;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteCampaignRequest model) {
            this.additionalTreatments(model.additionalTreatments);
            this.customDeliveryConfiguration(model.customDeliveryConfiguration);
            this.description(model.description);
            this.holdoutPercent(model.holdoutPercent);
            this.hook(model.hook);
            this.isPaused(model.isPaused);
            this.limits(model.limits);
            this.messageConfiguration(model.messageConfiguration);
            this.name(model.name);
            this.schedule(model.schedule);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
            this.tags(model.tags);
            this.templateConfiguration(model.templateConfiguration);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
            this.priority(model.priority);
        }

        public final List<WriteTreatmentResource.Builder> getAdditionalTreatments() {
            List<WriteTreatmentResource.Builder> result = ListOfWriteTreatmentResourceCopier.copyToBuilder(this.additionalTreatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalTreatments(Collection<WriteTreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        @Override
        public final Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(WriteTreatmentResource ... additionalTreatments) {
            this.additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder> ... additionalTreatments) {
            this.additionalTreatments(Stream.of(additionalTreatments).map(c -> (WriteTreatmentResource)((WriteTreatmentResource.Builder)WriteTreatmentResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomDeliveryConfiguration.Builder getCustomDeliveryConfiguration() {
            return this.customDeliveryConfiguration != null ? this.customDeliveryConfiguration.toBuilder() : null;
        }

        public final void setCustomDeliveryConfiguration(CustomDeliveryConfiguration.BuilderImpl customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration != null ? customDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getHoldoutPercent() {
            return this.holdoutPercent;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final CampaignHook.Builder getHook() {
            return this.hook != null ? this.hook.toBuilder() : null;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final Boolean getIsPaused() {
            return this.isPaused;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public WriteCampaignRequest build() {
            return new WriteCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteCampaignRequest> {
        public Builder additionalTreatments(Collection<WriteTreatmentResource> var1);

        public Builder additionalTreatments(WriteTreatmentResource ... var1);

        public Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder> ... var1);

        public Builder customDeliveryConfiguration(CustomDeliveryConfiguration var1);

        default public Builder customDeliveryConfiguration(Consumer<CustomDeliveryConfiguration.Builder> customDeliveryConfiguration) {
            return this.customDeliveryConfiguration((CustomDeliveryConfiguration)((CustomDeliveryConfiguration.Builder)CustomDeliveryConfiguration.builder().applyMutation(customDeliveryConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder holdoutPercent(Integer var1);

        public Builder hook(CampaignHook var1);

        default public Builder hook(Consumer<CampaignHook.Builder> hook) {
            return this.hook((CampaignHook)((CampaignHook.Builder)CampaignHook.builder().applyMutation(hook)).build());
        }

        public Builder isPaused(Boolean var1);

        public Builder limits(CampaignLimits var1);

        default public Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return this.limits((CampaignLimits)((CampaignLimits.Builder)CampaignLimits.builder().applyMutation(limits)).build());
        }

        public Builder messageConfiguration(MessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(messageConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);

        public Builder priority(Integer var1);
    }
}

