/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiAsyncClient;
import software.amazon.awssdk.services.pi.internal.UserAgentUtils;
import software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest;
import software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse;

public class ListPerformanceAnalysisReportsPublisher
implements SdkPublisher<ListPerformanceAnalysisReportsResponse> {
    private final PiAsyncClient client;
    private final ListPerformanceAnalysisReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPerformanceAnalysisReportsPublisher(PiAsyncClient client, ListPerformanceAnalysisReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPerformanceAnalysisReportsPublisher(PiAsyncClient client, ListPerformanceAnalysisReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPerformanceAnalysisReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPerformanceAnalysisReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPerformanceAnalysisReportsResponseFetcher
    implements AsyncPageFetcher<ListPerformanceAnalysisReportsResponse> {
        private ListPerformanceAnalysisReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListPerformanceAnalysisReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPerformanceAnalysisReportsResponse> nextPage(ListPerformanceAnalysisReportsResponse previousPage) {
            if (previousPage == null) {
                return ListPerformanceAnalysisReportsPublisher.this.client.listPerformanceAnalysisReports(ListPerformanceAnalysisReportsPublisher.this.firstRequest);
            }
            return ListPerformanceAnalysisReportsPublisher.this.client.listPerformanceAnalysisReports((ListPerformanceAnalysisReportsRequest)((Object)ListPerformanceAnalysisReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

