/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetExportJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeDatasetExportJobResponse.Builder, DescribeDatasetExportJobResponse> {
    private static final SdkField<DatasetExportJob> DATASET_EXPORT_JOB_FIELD = SdkField
            .<DatasetExportJob> builder(MarshallingType.SDK_POJO).memberName("datasetExportJob")
            .getter(getter(DescribeDatasetExportJobResponse::datasetExportJob)).setter(setter(Builder::datasetExportJob))
            .constructor(DatasetExportJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetExportJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_EXPORT_JOB_FIELD));

    private final DatasetExportJob datasetExportJob;

    private DescribeDatasetExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.datasetExportJob = builder.datasetExportJob;
    }

    /**
     * <p>
     * Information about the dataset export job, including the status.
     * </p>
     * <p>
     * The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the dataset export job, including the status.</p>
     *         <p>
     *         The status is one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE IN_PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */
    public final DatasetExportJob datasetExportJob() {
        return datasetExportJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetExportJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetExportJobResponse)) {
            return false;
        }
        DescribeDatasetExportJobResponse other = (DescribeDatasetExportJobResponse) obj;
        return Objects.equals(datasetExportJob(), other.datasetExportJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetExportJobResponse").add("DatasetExportJob", datasetExportJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetExportJob":
            return Optional.ofNullable(clazz.cast(datasetExportJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetExportJobResponse, T> g) {
        return obj -> g.apply((DescribeDatasetExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDatasetExportJobResponse> {
        /**
         * <p>
         * Information about the dataset export job, including the status.
         * </p>
         * <p>
         * The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param datasetExportJob
         *        Information about the dataset export job, including the status.</p>
         *        <p>
         *        The status is one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE IN_PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetExportJob(DatasetExportJob datasetExportJob);

        /**
         * <p>
         * Information about the dataset export job, including the status.
         * </p>
         * <p>
         * The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link DatasetExportJob.Builder} avoiding the
         * need to create one manually via {@link DatasetExportJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetExportJob.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetExportJob(DatasetExportJob)}.
         * 
         * @param datasetExportJob
         *        a consumer that will call methods on {@link DatasetExportJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetExportJob(DatasetExportJob)
         */
        default Builder datasetExportJob(Consumer<DatasetExportJob.Builder> datasetExportJob) {
            return datasetExportJob(DatasetExportJob.builder().applyMutation(datasetExportJob).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private DatasetExportJob datasetExportJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetExportJobResponse model) {
            super(model);
            datasetExportJob(model.datasetExportJob);
        }

        public final DatasetExportJob.Builder getDatasetExportJob() {
            return datasetExportJob != null ? datasetExportJob.toBuilder() : null;
        }

        public final void setDatasetExportJob(DatasetExportJob.BuilderImpl datasetExportJob) {
            this.datasetExportJob = datasetExportJob != null ? datasetExportJob.build() : null;
        }

        @Override
        public final Builder datasetExportJob(DatasetExportJob datasetExportJob) {
            this.datasetExportJob = datasetExportJob;
            return this;
        }

        @Override
        public DescribeDatasetExportJobResponse build() {
            return new DescribeDatasetExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
