/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchInferenceJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchInferenceJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(BatchInferenceJob.getter(BatchInferenceJob::jobName)).setter(BatchInferenceJob.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> BATCH_INFERENCE_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("batchInferenceJobArn").getter(BatchInferenceJob.getter(BatchInferenceJob::batchInferenceJobArn)).setter(BatchInferenceJob.setter(Builder::batchInferenceJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobArn").build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(BatchInferenceJob.getter(BatchInferenceJob::filterArn)).setter(BatchInferenceJob.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(BatchInferenceJob.getter(BatchInferenceJob::failureReason)).setter(BatchInferenceJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(BatchInferenceJob.getter(BatchInferenceJob::solutionVersionArn)).setter(BatchInferenceJob.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numResults").getter(BatchInferenceJob.getter(BatchInferenceJob::numResults)).setter(BatchInferenceJob.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()}).build();
    private static final SdkField<BatchInferenceJobInput> JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobInput").getter(BatchInferenceJob.getter(BatchInferenceJob::jobInput)).setter(BatchInferenceJob.setter(Builder::jobInput)).constructor(BatchInferenceJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()}).build();
    private static final SdkField<BatchInferenceJobOutput> JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobOutput").getter(BatchInferenceJob.getter(BatchInferenceJob::jobOutput)).setter(BatchInferenceJob.setter(Builder::jobOutput)).constructor(BatchInferenceJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()}).build();
    private static final SdkField<BatchInferenceJobConfig> BATCH_INFERENCE_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchInferenceJobConfig").getter(BatchInferenceJob.getter(BatchInferenceJob::batchInferenceJobConfig)).setter(BatchInferenceJob.setter(Builder::batchInferenceJobConfig)).constructor(BatchInferenceJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(BatchInferenceJob.getter(BatchInferenceJob::roleArn)).setter(BatchInferenceJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchInferenceJob.getter(BatchInferenceJob::status)).setter(BatchInferenceJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(BatchInferenceJob.getter(BatchInferenceJob::creationDateTime)).setter(BatchInferenceJob.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(BatchInferenceJob.getter(BatchInferenceJob::lastUpdatedDateTime)).setter(BatchInferenceJob.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, BATCH_INFERENCE_JOB_ARN_FIELD, FILTER_ARN_FIELD, FAILURE_REASON_FIELD, SOLUTION_VERSION_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, BATCH_INFERENCE_JOB_CONFIG_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String batchInferenceJobArn;
    private final String filterArn;
    private final String failureReason;
    private final String solutionVersionArn;
    private final Integer numResults;
    private final BatchInferenceJobInput jobInput;
    private final BatchInferenceJobOutput jobOutput;
    private final BatchInferenceJobConfig batchInferenceJobConfig;
    private final String roleArn;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private BatchInferenceJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.batchInferenceJobArn = builder.batchInferenceJobArn;
        this.filterArn = builder.filterArn;
        this.failureReason = builder.failureReason;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.batchInferenceJobConfig = builder.batchInferenceJobConfig;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String batchInferenceJobArn() {
        return this.batchInferenceJobArn;
    }

    public final String filterArn() {
        return this.filterArn;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final BatchInferenceJobInput jobInput() {
        return this.jobInput;
    }

    public final BatchInferenceJobOutput jobOutput() {
        return this.jobOutput;
    }

    public final BatchInferenceJobConfig batchInferenceJobConfig() {
        return this.batchInferenceJobConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchInferenceJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJob)) {
            return false;
        }
        BatchInferenceJob other = (BatchInferenceJob)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.batchInferenceJobArn(), other.batchInferenceJobArn()) && Objects.equals(this.filterArn(), other.filterArn()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.jobInput(), other.jobInput()) && Objects.equals(this.jobOutput(), other.jobOutput()) && Objects.equals(this.batchInferenceJobConfig(), other.batchInferenceJobConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BatchInferenceJob").add("JobName", (Object)this.jobName()).add("BatchInferenceJobArn", (Object)this.batchInferenceJobArn()).add("FilterArn", (Object)this.filterArn()).add("FailureReason", (Object)this.failureReason()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("NumResults", (Object)this.numResults()).add("JobInput", (Object)this.jobInput()).add("JobOutput", (Object)this.jobOutput()).add("BatchInferenceJobConfig", (Object)this.batchInferenceJobConfig()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "batchInferenceJobArn": {
                return Optional.ofNullable(clazz.cast(this.batchInferenceJobArn()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "numResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "jobInput": {
                return Optional.ofNullable(clazz.cast(this.jobInput()));
            }
            case "jobOutput": {
                return Optional.ofNullable(clazz.cast(this.jobOutput()));
            }
            case "batchInferenceJobConfig": {
                return Optional.ofNullable(clazz.cast(this.batchInferenceJobConfig()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJob, T> g) {
        return obj -> g.apply((BatchInferenceJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String batchInferenceJobArn;
        private String filterArn;
        private String failureReason;
        private String solutionVersionArn;
        private Integer numResults;
        private BatchInferenceJobInput jobInput;
        private BatchInferenceJobOutput jobOutput;
        private BatchInferenceJobConfig batchInferenceJobConfig;
        private String roleArn;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJob model) {
            this.jobName(model.jobName);
            this.batchInferenceJobArn(model.batchInferenceJobArn);
            this.filterArn(model.filterArn);
            this.failureReason(model.failureReason);
            this.solutionVersionArn(model.solutionVersionArn);
            this.numResults(model.numResults);
            this.jobInput(model.jobInput);
            this.jobOutput(model.jobOutput);
            this.batchInferenceJobConfig(model.batchInferenceJobConfig);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getBatchInferenceJobArn() {
            return this.batchInferenceJobArn;
        }

        @Override
        public final Builder batchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
            return this;
        }

        public final void setBatchInferenceJobArn(String batchInferenceJobArn) {
            this.batchInferenceJobArn = batchInferenceJobArn;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final BatchInferenceJobInput.Builder getJobInput() {
            return this.jobInput != null ? this.jobInput.toBuilder() : null;
        }

        @Override
        public final Builder jobInput(BatchInferenceJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final void setJobInput(BatchInferenceJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        public final BatchInferenceJobOutput.Builder getJobOutput() {
            return this.jobOutput != null ? this.jobOutput.toBuilder() : null;
        }

        @Override
        public final Builder jobOutput(BatchInferenceJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final void setJobOutput(BatchInferenceJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        public final BatchInferenceJobConfig.Builder getBatchInferenceJobConfig() {
            return this.batchInferenceJobConfig != null ? this.batchInferenceJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder batchInferenceJobConfig(BatchInferenceJobConfig batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig;
            return this;
        }

        public final void setBatchInferenceJobConfig(BatchInferenceJobConfig.BuilderImpl batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig != null ? batchInferenceJobConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public BatchInferenceJob build() {
            return new BatchInferenceJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchInferenceJob> {
        public Builder jobName(String var1);

        public Builder batchInferenceJobArn(String var1);

        public Builder filterArn(String var1);

        public Builder failureReason(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder numResults(Integer var1);

        public Builder jobInput(BatchInferenceJobInput var1);

        default public Builder jobInput(Consumer<BatchInferenceJobInput.Builder> jobInput) {
            return this.jobInput((BatchInferenceJobInput)((BatchInferenceJobInput.Builder)BatchInferenceJobInput.builder().applyMutation(jobInput)).build());
        }

        public Builder jobOutput(BatchInferenceJobOutput var1);

        default public Builder jobOutput(Consumer<BatchInferenceJobOutput.Builder> jobOutput) {
            return this.jobOutput((BatchInferenceJobOutput)((BatchInferenceJobOutput.Builder)BatchInferenceJobOutput.builder().applyMutation(jobOutput)).build());
        }

        public Builder batchInferenceJobConfig(BatchInferenceJobConfig var1);

        default public Builder batchInferenceJobConfig(Consumer<BatchInferenceJobConfig.Builder> batchInferenceJobConfig) {
            return this.batchInferenceJobConfig((BatchInferenceJobConfig)((BatchInferenceJobConfig.Builder)BatchInferenceJobConfig.builder().applyMutation(batchInferenceJobConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

