/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratePinDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<GeneratePinDataRequest.Builder, GeneratePinDataRequest> {
    private static final SdkField<String> ENCRYPTION_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyIdentifier").getter(getter(GeneratePinDataRequest::encryptionKeyIdentifier))
            .setter(setter(Builder::encryptionKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyIdentifier").build())
            .build();

    private static final SdkField<PinGenerationAttributes> GENERATION_ATTRIBUTES_FIELD = SdkField
            .<PinGenerationAttributes> builder(MarshallingType.SDK_POJO).memberName("GenerationAttributes")
            .getter(getter(GeneratePinDataRequest::generationAttributes)).setter(setter(Builder::generationAttributes))
            .constructor(PinGenerationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationAttributes").build())
            .build();

    private static final SdkField<String> GENERATION_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationKeyIdentifier").getter(getter(GeneratePinDataRequest::generationKeyIdentifier))
            .setter(setter(Builder::generationKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationKeyIdentifier").build())
            .build();

    private static final SdkField<String> PIN_BLOCK_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlockFormat").getter(getter(GeneratePinDataRequest::pinBlockFormatAsString))
            .setter(setter(Builder::pinBlockFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockFormat").build()).build();

    private static final SdkField<Integer> PIN_DATA_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PinDataLength").getter(getter(GeneratePinDataRequest::pinDataLength))
            .setter(setter(Builder::pinDataLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinDataLength").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(GeneratePinDataRequest::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENCRYPTION_KEY_IDENTIFIER_FIELD, GENERATION_ATTRIBUTES_FIELD, GENERATION_KEY_IDENTIFIER_FIELD,
            PIN_BLOCK_FORMAT_FIELD, PIN_DATA_LENGTH_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD));

    private final String encryptionKeyIdentifier;

    private final PinGenerationAttributes generationAttributes;

    private final String generationKeyIdentifier;

    private final String pinBlockFormat;

    private final Integer pinDataLength;

    private final String primaryAccountNumber;

    private GeneratePinDataRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionKeyIdentifier = builder.encryptionKeyIdentifier;
        this.generationAttributes = builder.generationAttributes;
        this.generationKeyIdentifier = builder.generationKeyIdentifier;
        this.pinBlockFormat = builder.pinBlockFormat;
        this.pinDataLength = builder.pinDataLength;
        this.primaryAccountNumber = builder.primaryAccountNumber;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses to encrypt the PIN Block.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses to encrypt the PIN
     *         Block.
     */
    public final String encryptionKeyIdentifier() {
        return encryptionKeyIdentifier;
    }

    /**
     * <p>
     * The attributes and values to use for PIN, PVV, or PIN Offset generation.
     * </p>
     * 
     * @return The attributes and values to use for PIN, PVV, or PIN Offset generation.
     */
    public final PinGenerationAttributes generationAttributes() {
        return generationAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for pin data generation.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for pin data
     *         generation.
     */
    public final String generationKeyIdentifier() {
        return generationKeyIdentifier;
    }

    /**
     * <p>
     * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
     * </p>
     * <p>
     * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
     * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
     * </p>
     * <p>
     * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
     * digits are random values from 10 to 15.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pinBlockFormat}
     * will return {@link PinBlockFormatForPinData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pinBlockFormatAsString}.
     * </p>
     * 
     * @return The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     *         Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
     *         <p>
     *         The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
     *         block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
     *         length.
     *         </p>
     *         <p>
     *         The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the
     *         fill digits are random values from 10 to 15.
     * @see PinBlockFormatForPinData
     */
    public final PinBlockFormatForPinData pinBlockFormat() {
        return PinBlockFormatForPinData.fromValue(pinBlockFormat);
    }

    /**
     * <p>
     * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
     * </p>
     * <p>
     * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
     * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
     * </p>
     * <p>
     * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
     * digits are random values from 10 to 15.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pinBlockFormat}
     * will return {@link PinBlockFormatForPinData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pinBlockFormatAsString}.
     * </p>
     * 
     * @return The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     *         Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
     *         <p>
     *         The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
     *         block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
     *         length.
     *         </p>
     *         <p>
     *         The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the
     *         fill digits are random values from 10 to 15.
     * @see PinBlockFormatForPinData
     */
    public final String pinBlockFormatAsString() {
        return pinBlockFormat;
    }

    /**
     * <p>
     * The length of PIN under generation.
     * </p>
     * 
     * @return The length of PIN under generation.
     */
    public final Integer pinDataLength() {
        return pinDataLength;
    }

    /**
     * <p>
     * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card
     * with a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates
     *         the card with a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(generationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(generationKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(pinBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pinDataLength());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratePinDataRequest)) {
            return false;
        }
        GeneratePinDataRequest other = (GeneratePinDataRequest) obj;
        return Objects.equals(encryptionKeyIdentifier(), other.encryptionKeyIdentifier())
                && Objects.equals(generationAttributes(), other.generationAttributes())
                && Objects.equals(generationKeyIdentifier(), other.generationKeyIdentifier())
                && Objects.equals(pinBlockFormatAsString(), other.pinBlockFormatAsString())
                && Objects.equals(pinDataLength(), other.pinDataLength())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratePinDataRequest").add("EncryptionKeyIdentifier", encryptionKeyIdentifier())
                .add("GenerationAttributes", generationAttributes()).add("GenerationKeyIdentifier", generationKeyIdentifier())
                .add("PinBlockFormat", pinBlockFormatAsString()).add("PinDataLength", pinDataLength())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionKeyIdentifier":
            return Optional.ofNullable(clazz.cast(encryptionKeyIdentifier()));
        case "GenerationAttributes":
            return Optional.ofNullable(clazz.cast(generationAttributes()));
        case "GenerationKeyIdentifier":
            return Optional.ofNullable(clazz.cast(generationKeyIdentifier()));
        case "PinBlockFormat":
            return Optional.ofNullable(clazz.cast(pinBlockFormatAsString()));
        case "PinDataLength":
            return Optional.ofNullable(clazz.cast(pinDataLength()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratePinDataRequest, T> g) {
        return obj -> g.apply((GeneratePinDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GeneratePinDataRequest> {
        /**
         * <p>
         * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses to encrypt the PIN
         * Block.
         * </p>
         * 
         * @param encryptionKeyIdentifier
         *        The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses to encrypt the
         *        PIN Block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyIdentifier(String encryptionKeyIdentifier);

        /**
         * <p>
         * The attributes and values to use for PIN, PVV, or PIN Offset generation.
         * </p>
         * 
         * @param generationAttributes
         *        The attributes and values to use for PIN, PVV, or PIN Offset generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationAttributes(PinGenerationAttributes generationAttributes);

        /**
         * <p>
         * The attributes and values to use for PIN, PVV, or PIN Offset generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link PinGenerationAttributes.Builder} avoiding
         * the need to create one manually via {@link PinGenerationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PinGenerationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #generationAttributes(PinGenerationAttributes)}.
         * 
         * @param generationAttributes
         *        a consumer that will call methods on {@link PinGenerationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationAttributes(PinGenerationAttributes)
         */
        default Builder generationAttributes(Consumer<PinGenerationAttributes.Builder> generationAttributes) {
            return generationAttributes(PinGenerationAttributes.builder().applyMutation(generationAttributes).build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for pin data
         * generation.
         * </p>
         * 
         * @param generationKeyIdentifier
         *        The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for pin data
         *        generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationKeyIdentifier(String generationKeyIdentifier);

        /**
         * <p>
         * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
         * </p>
         * <p>
         * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
         * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
         * </p>
         * <p>
         * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
         * digits are random values from 10 to 15.
         * </p>
         * 
         * @param pinBlockFormat
         *        The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         *        Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
         *        <p>
         *        The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
         *        block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
         *        length.
         *        </p>
         *        <p>
         *        The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that
         *        the fill digits are random values from 10 to 15.
         * @see PinBlockFormatForPinData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockFormatForPinData
         */
        Builder pinBlockFormat(String pinBlockFormat);

        /**
         * <p>
         * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
         * </p>
         * <p>
         * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
         * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
         * </p>
         * <p>
         * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
         * digits are random values from 10 to 15.
         * </p>
         * 
         * @param pinBlockFormat
         *        The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         *        Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
         *        <p>
         *        The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
         *        block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
         *        length.
         *        </p>
         *        <p>
         *        The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that
         *        the fill digits are random values from 10 to 15.
         * @see PinBlockFormatForPinData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockFormatForPinData
         */
        Builder pinBlockFormat(PinBlockFormatForPinData pinBlockFormat);

        /**
         * <p>
         * The length of PIN under generation.
         * </p>
         * 
         * @param pinDataLength
         *        The length of PIN under generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinDataLength(Integer pinDataLength);

        /**
         * <p>
         * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the
         * card with a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that
         *        associates the card with a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String encryptionKeyIdentifier;

        private PinGenerationAttributes generationAttributes;

        private String generationKeyIdentifier;

        private String pinBlockFormat;

        private Integer pinDataLength;

        private String primaryAccountNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratePinDataRequest model) {
            super(model);
            encryptionKeyIdentifier(model.encryptionKeyIdentifier);
            generationAttributes(model.generationAttributes);
            generationKeyIdentifier(model.generationKeyIdentifier);
            pinBlockFormat(model.pinBlockFormat);
            pinDataLength(model.pinDataLength);
            primaryAccountNumber(model.primaryAccountNumber);
        }

        public final String getEncryptionKeyIdentifier() {
            return encryptionKeyIdentifier;
        }

        public final void setEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
        }

        @Override
        public final Builder encryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
            return this;
        }

        public final PinGenerationAttributes.Builder getGenerationAttributes() {
            return generationAttributes != null ? generationAttributes.toBuilder() : null;
        }

        public final void setGenerationAttributes(PinGenerationAttributes.BuilderImpl generationAttributes) {
            this.generationAttributes = generationAttributes != null ? generationAttributes.build() : null;
        }

        @Override
        public final Builder generationAttributes(PinGenerationAttributes generationAttributes) {
            this.generationAttributes = generationAttributes;
            return this;
        }

        public final String getGenerationKeyIdentifier() {
            return generationKeyIdentifier;
        }

        public final void setGenerationKeyIdentifier(String generationKeyIdentifier) {
            this.generationKeyIdentifier = generationKeyIdentifier;
        }

        @Override
        public final Builder generationKeyIdentifier(String generationKeyIdentifier) {
            this.generationKeyIdentifier = generationKeyIdentifier;
            return this;
        }

        public final String getPinBlockFormat() {
            return pinBlockFormat;
        }

        public final void setPinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
        }

        @Override
        public final Builder pinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
            return this;
        }

        @Override
        public final Builder pinBlockFormat(PinBlockFormatForPinData pinBlockFormat) {
            this.pinBlockFormat(pinBlockFormat == null ? null : pinBlockFormat.toString());
            return this;
        }

        public final Integer getPinDataLength() {
            return pinDataLength;
        }

        public final void setPinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
        }

        @Override
        public final Builder pinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GeneratePinDataRequest build() {
            return new GeneratePinDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
