/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters required for DUKPT MAC generation and verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MacAlgorithmDukpt implements SdkPojo, Serializable,
        ToCopyableBuilder<MacAlgorithmDukpt.Builder, MacAlgorithmDukpt> {
    private static final SdkField<String> DUKPT_DERIVATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DukptDerivationType").getter(getter(MacAlgorithmDukpt::dukptDerivationTypeAsString))
            .setter(setter(Builder::dukptDerivationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptDerivationType").build())
            .build();

    private static final SdkField<String> DUKPT_KEY_VARIANT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DukptKeyVariant").getter(getter(MacAlgorithmDukpt::dukptKeyVariantAsString))
            .setter(setter(Builder::dukptKeyVariant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyVariant").build()).build();

    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeySerialNumber").getter(getter(MacAlgorithmDukpt::keySerialNumber))
            .setter(setter(Builder::keySerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DUKPT_DERIVATION_TYPE_FIELD,
            DUKPT_KEY_VARIANT_FIELD, KEY_SERIAL_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dukptDerivationType;

    private final String dukptKeyVariant;

    private final String keySerialNumber;

    private MacAlgorithmDukpt(BuilderImpl builder) {
        this.dukptDerivationType = builder.dukptDerivationType;
        this.dukptKeyVariant = builder.dukptKeyVariant;
        this.keySerialNumber = builder.keySerialNumber;
    }

    /**
     * <p>
     * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less
     * than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a derivation type
     * for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dukptDerivationType} will return {@link DukptDerivationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dukptDerivationTypeAsString}.
     * </p>
     * 
     * @return The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must
     *         be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
     *         derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
     * @see DukptDerivationType
     */
    public final DukptDerivationType dukptDerivationType() {
        return DukptDerivationType.fromValue(dukptDerivationType);
    }

    /**
     * <p>
     * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be less
     * than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a derivation type
     * for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dukptDerivationType} will return {@link DukptDerivationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dukptDerivationTypeAsString}.
     * </p>
     * 
     * @return The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must
     *         be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
     *         derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
     * @see DukptDerivationType
     */
    public final String dukptDerivationTypeAsString() {
        return dukptDerivationType;
    }

    /**
     * <p>
     * The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dukptKeyVariant}
     * will return {@link DukptKeyVariant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dukptKeyVariantAsString}.
     * </p>
     * 
     * @return The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
     * @see DukptKeyVariant
     */
    public final DukptKeyVariant dukptKeyVariant() {
        return DukptKeyVariant.fromValue(dukptKeyVariant);
    }

    /**
     * <p>
     * The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dukptKeyVariant}
     * will return {@link DukptKeyVariant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dukptKeyVariantAsString}.
     * </p>
     * 
     * @return The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
     * @see DukptKeyVariant
     */
    public final String dukptKeyVariantAsString() {
        return dukptKeyVariant;
    }

    /**
     * <p>
     * The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT
     * encryption method. The KSN is derived from the encrypting device unique identifier and an internal transaction
     * counter.
     * </p>
     * 
     * @return The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT
     *         encryption method. The KSN is derived from the encrypting device unique identifier and an internal
     *         transaction counter.
     */
    public final String keySerialNumber() {
        return keySerialNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dukptDerivationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dukptKeyVariantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keySerialNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAlgorithmDukpt)) {
            return false;
        }
        MacAlgorithmDukpt other = (MacAlgorithmDukpt) obj;
        return Objects.equals(dukptDerivationTypeAsString(), other.dukptDerivationTypeAsString())
                && Objects.equals(dukptKeyVariantAsString(), other.dukptKeyVariantAsString())
                && Objects.equals(keySerialNumber(), other.keySerialNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MacAlgorithmDukpt").add("DukptDerivationType", dukptDerivationTypeAsString())
                .add("DukptKeyVariant", dukptKeyVariantAsString()).add("KeySerialNumber", keySerialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DukptDerivationType":
            return Optional.ofNullable(clazz.cast(dukptDerivationTypeAsString()));
        case "DukptKeyVariant":
            return Optional.ofNullable(clazz.cast(dukptKeyVariantAsString()));
        case "KeySerialNumber":
            return Optional.ofNullable(clazz.cast(keySerialNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MacAlgorithmDukpt, T> g) {
        return obj -> g.apply((MacAlgorithmDukpt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MacAlgorithmDukpt> {
        /**
         * <p>
         * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be
         * less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
         * derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
         * </p>
         * 
         * @param dukptDerivationType
         *        The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This
         *        must be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code>
         *        as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
         * @see DukptDerivationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptDerivationType
         */
        Builder dukptDerivationType(String dukptDerivationType);

        /**
         * <p>
         * The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This must be
         * less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code> as a
         * derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
         * </p>
         * 
         * @param dukptDerivationType
         *        The key type derived using DUKPT from a Base Derivation Key (BDK) and Key Serial Number (KSN). This
         *        must be less than or equal to the strength of the BDK. For example, you can't use <code>AES_128</code>
         *        as a derivation type for a BDK of <code>AES_128</code> or <code>TDES_2KEY</code>.
         * @see DukptDerivationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptDerivationType
         */
        Builder dukptDerivationType(DukptDerivationType dukptDerivationType);

        /**
         * <p>
         * The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
         * </p>
         * 
         * @param dukptKeyVariant
         *        The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
         * @see DukptKeyVariant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptKeyVariant
         */
        Builder dukptKeyVariant(String dukptKeyVariant);

        /**
         * <p>
         * The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
         * </p>
         * 
         * @param dukptKeyVariant
         *        The type of use of DUKPT, which can be MAC generation, MAC verification, or both.
         * @see DukptKeyVariant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DukptKeyVariant
         */
        Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant);

        /**
         * <p>
         * The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using DUKPT
         * encryption method. The KSN is derived from the encrypting device unique identifier and an internal
         * transaction counter.
         * </p>
         * 
         * @param keySerialNumber
         *        The unique identifier known as Key Serial Number (KSN) that comes from an encrypting device using
         *        DUKPT encryption method. The KSN is derived from the encrypting device unique identifier and an
         *        internal transaction counter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySerialNumber(String keySerialNumber);
    }

    static final class BuilderImpl implements Builder {
        private String dukptDerivationType;

        private String dukptKeyVariant;

        private String keySerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(MacAlgorithmDukpt model) {
            dukptDerivationType(model.dukptDerivationType);
            dukptKeyVariant(model.dukptKeyVariant);
            keySerialNumber(model.keySerialNumber);
        }

        public final String getDukptDerivationType() {
            return dukptDerivationType;
        }

        public final void setDukptDerivationType(String dukptDerivationType) {
            this.dukptDerivationType = dukptDerivationType;
        }

        @Override
        public final Builder dukptDerivationType(String dukptDerivationType) {
            this.dukptDerivationType = dukptDerivationType;
            return this;
        }

        @Override
        public final Builder dukptDerivationType(DukptDerivationType dukptDerivationType) {
            this.dukptDerivationType(dukptDerivationType == null ? null : dukptDerivationType.toString());
            return this;
        }

        public final String getDukptKeyVariant() {
            return dukptKeyVariant;
        }

        public final void setDukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
        }

        @Override
        public final Builder dukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
            return this;
        }

        @Override
        public final Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant) {
            this.dukptKeyVariant(dukptKeyVariant == null ? null : dukptKeyVariant.toString());
            return this;
        }

        public final String getKeySerialNumber() {
            return keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        @Override
        public MacAlgorithmDukpt build() {
            return new MacAlgorithmDukpt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
