/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.panorama.DefaultPanoramaBaseClientBuilder;
import software.amazon.awssdk.services.panorama.DefaultPanoramaClient;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.PanoramaClientBuilder;
import software.amazon.awssdk.services.panorama.PanoramaServiceClientConfiguration;
import software.amazon.awssdk.services.panorama.endpoints.PanoramaEndpointProvider;

@SdkInternalApi
final class DefaultPanoramaClientBuilder
extends DefaultPanoramaBaseClientBuilder<PanoramaClientBuilder, PanoramaClient>
implements PanoramaClientBuilder {
    DefaultPanoramaClientBuilder() {
    }

    @Override
    public DefaultPanoramaClientBuilder endpointProvider(PanoramaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PanoramaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPanoramaClientBuilder.validateClientOptions(clientConfiguration);
        PanoramaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPanoramaClient client = new DefaultPanoramaClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PanoramaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PanoramaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

