/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaAsyncClient;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse;

public class ListPackageImportJobsPublisher
implements SdkPublisher<ListPackageImportJobsResponse> {
    private final PanoramaAsyncClient client;
    private final ListPackageImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackageImportJobsPublisher(PanoramaAsyncClient client, ListPackageImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackageImportJobsPublisher(PanoramaAsyncClient client, ListPackageImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackageImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackageImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPackageImportJobsResponseFetcher
    implements AsyncPageFetcher<ListPackageImportJobsResponse> {
        private ListPackageImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackageImportJobsResponse> nextPage(ListPackageImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageImportJobsPublisher.this.client.listPackageImportJobs(ListPackageImportJobsPublisher.this.firstRequest);
            }
            return ListPackageImportJobsPublisher.this.client.listPackageImportJobs((ListPackageImportJobsRequest)((Object)ListPackageImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

