/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.osis.DefaultOsisAsyncClient;
import software.amazon.awssdk.services.osis.DefaultOsisBaseClientBuilder;
import software.amazon.awssdk.services.osis.OsisAsyncClient;
import software.amazon.awssdk.services.osis.OsisAsyncClientBuilder;
import software.amazon.awssdk.services.osis.OsisServiceClientConfiguration;
import software.amazon.awssdk.services.osis.endpoints.OsisEndpointProvider;

@SdkInternalApi
final class DefaultOsisAsyncClientBuilder
extends DefaultOsisBaseClientBuilder<OsisAsyncClientBuilder, OsisAsyncClient>
implements OsisAsyncClientBuilder {
    DefaultOsisAsyncClientBuilder() {
    }

    @Override
    public DefaultOsisAsyncClientBuilder endpointProvider(OsisEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OsisAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOsisAsyncClientBuilder.validateClientOptions(clientConfiguration);
        OsisServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOsisAsyncClient client = new DefaultOsisAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OsisServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OsisServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

