/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
 * <b>undeploy</b>, and <b>shutdown</b>. For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each
 * event. In addition, you can provide custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom
 * event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a
 * particular layer to be run in response to each of the five events.
 * </p>
 * <p>
 * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name,
 * which is the recipe's file name without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
 * recipe in the repository's phpapp2 folder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recipes implements SdkPojo, Serializable, ToCopyableBuilder<Recipes.Builder, Recipes> {
    private static final SdkField<List<String>> SETUP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Setup")
            .getter(getter(Recipes::setup))
            .setter(setter(Builder::setup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Setup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONFIGURE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Configure")
            .getter(getter(Recipes::configure))
            .setter(setter(Builder::configure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configure").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEPLOY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Deploy")
            .getter(getter(Recipes::deploy))
            .setter(setter(Builder::deploy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deploy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UNDEPLOY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Undeploy")
            .getter(getter(Recipes::undeploy))
            .setter(setter(Builder::undeploy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Undeploy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SHUTDOWN_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Shutdown")
            .getter(getter(Recipes::shutdown))
            .setter(setter(Builder::shutdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shutdown").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETUP_FIELD, CONFIGURE_FIELD,
            DEPLOY_FIELD, UNDEPLOY_FIELD, SHUTDOWN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> setup;

    private final List<String> configure;

    private final List<String> deploy;

    private final List<String> undeploy;

    private final List<String> shutdown;

    private Recipes(BuilderImpl builder) {
        this.setup = builder.setup;
        this.configure = builder.configure;
        this.deploy = builder.deploy;
        this.undeploy = builder.undeploy;
        this.shutdown = builder.shutdown;
    }

    /**
     * For responses, this returns true if the service returned a value for the Setup property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSetup() {
        return setup != null && !(setup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>setup</code> event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSetup} method.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>setup</code> event.
     */
    public final List<String> setup() {
        return setup;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configure property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfigure() {
        return configure != null && !(configure instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>configure</code> event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigure} method.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>configure</code> event.
     */
    public final List<String> configure() {
        return configure;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deploy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeploy() {
        return deploy != null && !(deploy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>deploy</code> event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploy} method.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>deploy</code> event.
     */
    public final List<String> deploy() {
        return deploy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Undeploy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUndeploy() {
        return undeploy != null && !(undeploy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>undeploy</code> event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUndeploy} method.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>undeploy</code> event.
     */
    public final List<String> undeploy() {
        return undeploy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shutdown property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShutdown() {
        return shutdown != null && !(shutdown instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>shutdown</code> event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShutdown} method.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>shutdown</code> event.
     */
    public final List<String> shutdown() {
        return shutdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSetup() ? setup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigure() ? configure() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploy() ? deploy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUndeploy() ? undeploy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasShutdown() ? shutdown() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipes)) {
            return false;
        }
        Recipes other = (Recipes) obj;
        return hasSetup() == other.hasSetup() && Objects.equals(setup(), other.setup()) && hasConfigure() == other.hasConfigure()
                && Objects.equals(configure(), other.configure()) && hasDeploy() == other.hasDeploy()
                && Objects.equals(deploy(), other.deploy()) && hasUndeploy() == other.hasUndeploy()
                && Objects.equals(undeploy(), other.undeploy()) && hasShutdown() == other.hasShutdown()
                && Objects.equals(shutdown(), other.shutdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recipes").add("Setup", hasSetup() ? setup() : null)
                .add("Configure", hasConfigure() ? configure() : null).add("Deploy", hasDeploy() ? deploy() : null)
                .add("Undeploy", hasUndeploy() ? undeploy() : null).add("Shutdown", hasShutdown() ? shutdown() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Setup":
            return Optional.ofNullable(clazz.cast(setup()));
        case "Configure":
            return Optional.ofNullable(clazz.cast(configure()));
        case "Deploy":
            return Optional.ofNullable(clazz.cast(deploy()));
        case "Undeploy":
            return Optional.ofNullable(clazz.cast(undeploy()));
        case "Shutdown":
            return Optional.ofNullable(clazz.cast(shutdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recipes, T> g) {
        return obj -> g.apply((Recipes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recipes> {
        /**
         * <p>
         * An array of custom recipe names to be run following a <code>setup</code> event.
         * </p>
         * 
         * @param setup
         *        An array of custom recipe names to be run following a <code>setup</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setup(Collection<String> setup);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>setup</code> event.
         * </p>
         * 
         * @param setup
         *        An array of custom recipe names to be run following a <code>setup</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setup(String... setup);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>configure</code> event.
         * </p>
         * 
         * @param configure
         *        An array of custom recipe names to be run following a <code>configure</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configure(Collection<String> configure);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>configure</code> event.
         * </p>
         * 
         * @param configure
         *        An array of custom recipe names to be run following a <code>configure</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configure(String... configure);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>deploy</code> event.
         * </p>
         * 
         * @param deploy
         *        An array of custom recipe names to be run following a <code>deploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploy(Collection<String> deploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>deploy</code> event.
         * </p>
         * 
         * @param deploy
         *        An array of custom recipe names to be run following a <code>deploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploy(String... deploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>undeploy</code> event.
         * </p>
         * 
         * @param undeploy
         *        An array of custom recipe names to be run following a <code>undeploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undeploy(Collection<String> undeploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>undeploy</code> event.
         * </p>
         * 
         * @param undeploy
         *        An array of custom recipe names to be run following a <code>undeploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undeploy(String... undeploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>shutdown</code> event.
         * </p>
         * 
         * @param shutdown
         *        An array of custom recipe names to be run following a <code>shutdown</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdown(Collection<String> shutdown);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>shutdown</code> event.
         * </p>
         * 
         * @param shutdown
         *        An array of custom recipe names to be run following a <code>shutdown</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdown(String... shutdown);
    }

    static final class BuilderImpl implements Builder {
        private List<String> setup = DefaultSdkAutoConstructList.getInstance();

        private List<String> configure = DefaultSdkAutoConstructList.getInstance();

        private List<String> deploy = DefaultSdkAutoConstructList.getInstance();

        private List<String> undeploy = DefaultSdkAutoConstructList.getInstance();

        private List<String> shutdown = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recipes model) {
            setup(model.setup);
            configure(model.configure);
            deploy(model.deploy);
            undeploy(model.undeploy);
            shutdown(model.shutdown);
        }

        public final Collection<String> getSetup() {
            if (setup instanceof SdkAutoConstructList) {
                return null;
            }
            return setup;
        }

        public final void setSetup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
        }

        @Override
        @Transient
        public final Builder setup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setup(String... setup) {
            setup(Arrays.asList(setup));
            return this;
        }

        public final Collection<String> getConfigure() {
            if (configure instanceof SdkAutoConstructList) {
                return null;
            }
            return configure;
        }

        public final void setConfigure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
        }

        @Override
        public final Builder configure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configure(String... configure) {
            configure(Arrays.asList(configure));
            return this;
        }

        public final Collection<String> getDeploy() {
            if (deploy instanceof SdkAutoConstructList) {
                return null;
            }
            return deploy;
        }

        public final void setDeploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
        }

        @Override
        public final Builder deploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploy(String... deploy) {
            deploy(Arrays.asList(deploy));
            return this;
        }

        public final Collection<String> getUndeploy() {
            if (undeploy instanceof SdkAutoConstructList) {
                return null;
            }
            return undeploy;
        }

        public final void setUndeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
        }

        @Override
        public final Builder undeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undeploy(String... undeploy) {
            undeploy(Arrays.asList(undeploy));
            return this;
        }

        public final Collection<String> getShutdown() {
            if (shutdown instanceof SdkAutoConstructList) {
                return null;
            }
            return shutdown;
        }

        public final void setShutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
        }

        @Override
        public final Builder shutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shutdown(String... shutdown) {
            shutdown(Arrays.asList(shutdown));
            return this;
        }

        @Override
        public Recipes build() {
            return new Recipes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
