/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentCommandName {
    INSTALL_DEPENDENCIES("install_dependencies"),
    UPDATE_DEPENDENCIES("update_dependencies"),
    UPDATE_CUSTOM_COOKBOOKS("update_custom_cookbooks"),
    EXECUTE_RECIPES("execute_recipes"),
    CONFIGURE("configure"),
    SETUP("setup"),
    DEPLOY("deploy"),
    ROLLBACK("rollback"),
    START("start"),
    STOP("stop"),
    RESTART("restart"),
    UNDEPLOY("undeploy"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentCommandName> VALUE_MAP;
    private final String value;

    private DeploymentCommandName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentCommandName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentCommandName> knownValues() {
        EnumSet<DeploymentCommandName> knownValues = EnumSet.allOf(DeploymentCommandName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentCommandName.class, DeploymentCommandName::toString);
    }
}

