/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessPolicyRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<UpdateAccessPolicyRequest.Builder, UpdateAccessPolicyRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAccessPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAccessPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAccessPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(UpdateAccessPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<String> POLICY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyVersion").getter(getter(UpdateAccessPolicyRequest::policyVersion))
            .setter(setter(Builder::policyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersion").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateAccessPolicyRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, POLICY_FIELD, POLICY_VERSION_FIELD, TYPE_FIELD));

    private final String clientToken;

    private final String description;

    private final String name;

    private final String policy;

    private final String policyVersion;

    private final String type;

    private UpdateAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.name = builder.name;
        this.policy = builder.policy;
        this.policyVersion = builder.policyVersion;
        this.type = builder.type;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description of the policy. Typically used to store information about the permissions defined in the policy.
     * </p>
     * 
     * @return A description of the policy. Typically used to store information about the permissions defined in the
     *         policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The JSON policy document to use as the content for the policy.
     * </p>
     * 
     * @return The JSON policy document to use as the content for the policy.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The version of the policy being updated.
     * </p>
     * 
     * @return The version of the policy being updated.
     */
    public final String policyVersion() {
        return policyVersion;
    }

    /**
     * <p>
     * The type of policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of policy.
     * @see AccessPolicyType
     */
    public final AccessPolicyType type() {
        return AccessPolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of policy.
     * @see AccessPolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessPolicyRequest)) {
            return false;
        }
        UpdateAccessPolicyRequest other = (UpdateAccessPolicyRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(policy(), other.policy())
                && Objects.equals(policyVersion(), other.policyVersion()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessPolicyRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("Name", name()).add("Policy", policy()).add("PolicyVersion", policyVersion()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "policyVersion":
            return Optional.ofNullable(clazz.cast(policyVersion()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAccessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccessPolicyRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description of the policy. Typically used to store information about the permissions defined in the policy.
         * </p>
         * 
         * @param description
         *        A description of the policy. Typically used to store information about the permissions defined in the
         *        policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param name
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The JSON policy document to use as the content for the policy.
         * </p>
         * 
         * @param policy
         *        The JSON policy document to use as the content for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The version of the policy being updated.
         * </p>
         * 
         * @param policyVersion
         *        The version of the policy being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersion(String policyVersion);

        /**
         * <p>
         * The type of policy.
         * </p>
         * 
         * @param type
         *        The type of policy.
         * @see AccessPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of policy.
         * </p>
         * 
         * @param type
         *        The type of policy.
         * @see AccessPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPolicyType
         */
        Builder type(AccessPolicyType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String name;

        private String policy;

        private String policyVersion;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessPolicyRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            name(model.name);
            policy(model.policy);
            policyVersion(model.policyVersion);
            type(model.type);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getPolicyVersion() {
            return policyVersion;
        }

        public final void setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
        }

        @Override
        public final Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessPolicyRequest build() {
            return new UpdateAccessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
