/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the response returned by the <code>UpdatePackage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageResponse extends OpenSearchResponse implements
        ToCopyableBuilder<UpdatePackageResponse.Builder, UpdatePackageResponse> {
    private static final SdkField<PackageDetails> PACKAGE_DETAILS_FIELD = SdkField
            .<PackageDetails> builder(MarshallingType.SDK_POJO).memberName("PackageDetails")
            .getter(getter(UpdatePackageResponse::packageDetails)).setter(setter(Builder::packageDetails))
            .constructor(PackageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_DETAILS_FIELD));

    private final PackageDetails packageDetails;

    private UpdatePackageResponse(BuilderImpl builder) {
        super(builder);
        this.packageDetails = builder.packageDetails;
    }

    /**
     * <p>
     * Information about a package.
     * </p>
     * 
     * @return Information about a package.
     */
    public final PackageDetails packageDetails() {
        return packageDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageResponse)) {
            return false;
        }
        UpdatePackageResponse other = (UpdatePackageResponse) obj;
        return Objects.equals(packageDetails(), other.packageDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageResponse").add("PackageDetails", packageDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageDetails":
            return Optional.ofNullable(clazz.cast(packageDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageResponse, T> g) {
        return obj -> g.apply((UpdatePackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageResponse> {
        /**
         * <p>
         * Information about a package.
         * </p>
         * 
         * @param packageDetails
         *        Information about a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDetails(PackageDetails packageDetails);

        /**
         * <p>
         * Information about a package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageDetails.Builder} avoiding the need
         * to create one manually via {@link PackageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #packageDetails(PackageDetails)}.
         * 
         * @param packageDetails
         *        a consumer that will call methods on {@link PackageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageDetails(PackageDetails)
         */
        default Builder packageDetails(Consumer<PackageDetails.Builder> packageDetails) {
            return packageDetails(PackageDetails.builder().applyMutation(packageDetails).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private PackageDetails packageDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageResponse model) {
            super(model);
            packageDetails(model.packageDetails);
        }

        public final PackageDetails.Builder getPackageDetails() {
            return packageDetails != null ? packageDetails.toBuilder() : null;
        }

        public final void setPackageDetails(PackageDetails.BuilderImpl packageDetails) {
            this.packageDetails = packageDetails != null ? packageDetails.build() : null;
        }

        @Override
        public final Builder packageDetails(PackageDetails packageDetails) {
            this.packageDetails = packageDetails;
            return this;
        }

        @Override
        public UpdatePackageResponse build() {
            return new UpdatePackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
