/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the domain maintenance details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainMaintenanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainMaintenanceDetails.Builder, DomainMaintenanceDetails> {
    private static final SdkField<String> MAINTENANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceId").getter(getter(DomainMaintenanceDetails::maintenanceId))
            .setter(setter(Builder::maintenanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DomainMaintenanceDetails::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(DomainMaintenanceDetails::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(DomainMaintenanceDetails::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DomainMaintenanceDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DomainMaintenanceDetails::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DomainMaintenanceDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DomainMaintenanceDetails::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_ID_FIELD,
            DOMAIN_NAME_FIELD, ACTION_FIELD, NODE_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maintenanceId;

    private final String domainName;

    private final String action;

    private final String nodeId;

    private final String status;

    private final String statusMessage;

    private final Instant createdAt;

    private final Instant updatedAt;

    private DomainMaintenanceDetails(BuilderImpl builder) {
        this.maintenanceId = builder.maintenanceId;
        this.domainName = builder.domainName;
        this.action = builder.action;
        this.nodeId = builder.nodeId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * Id of the requested action.
     * </p>
     * 
     * @return Id of the requested action.
     */
    public final String maintenanceId() {
        return maintenanceId;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link MaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The name of the action.
     * @see MaintenanceType
     */
    public final MaintenanceType action() {
        return MaintenanceType.fromValue(action);
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link MaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The name of the action.
     * @see MaintenanceType
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Id of the data node.
     * </p>
     * 
     * @return Id of the data node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see MaintenanceStatus
     */
    public final MaintenanceStatus status() {
        return MaintenanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see MaintenanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the action.
     * </p>
     * 
     * @return The status message of the action.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Contains time at which action created.
     * </p>
     * 
     * @return Contains time at which action created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Contains time at which action updated.
     * </p>
     * 
     * @return Contains time at which action updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMaintenanceDetails)) {
            return false;
        }
        DomainMaintenanceDetails other = (DomainMaintenanceDetails) obj;
        return Objects.equals(maintenanceId(), other.maintenanceId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainMaintenanceDetails").add("MaintenanceId", maintenanceId()).add("DomainName", domainName())
                .add("Action", actionAsString()).add("NodeId", nodeId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceId":
            return Optional.ofNullable(clazz.cast(maintenanceId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainMaintenanceDetails, T> g) {
        return obj -> g.apply((DomainMaintenanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainMaintenanceDetails> {
        /**
         * <p>
         * Id of the requested action.
         * </p>
         * 
         * @param maintenanceId
         *        Id of the requested action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceId(String maintenanceId);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param action
         *        The name of the action.
         * @see MaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceType
         */
        Builder action(String action);

        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param action
         *        The name of the action.
         * @see MaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceType
         */
        Builder action(MaintenanceType action);

        /**
         * <p>
         * Id of the data node.
         * </p>
         * 
         * @param nodeId
         *        Id of the data node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder status(MaintenanceStatus status);

        /**
         * <p>
         * The status message of the action.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Contains time at which action created.
         * </p>
         * 
         * @param createdAt
         *        Contains time at which action created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Contains time at which action updated.
         * </p>
         * 
         * @param updatedAt
         *        Contains time at which action updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceId;

        private String domainName;

        private String action;

        private String nodeId;

        private String status;

        private String statusMessage;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMaintenanceDetails model) {
            maintenanceId(model.maintenanceId);
            domainName(model.domainName);
            action(model.action);
            nodeId(model.nodeId);
            status(model.status);
            statusMessage(model.statusMessage);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getMaintenanceId() {
            return maintenanceId;
        }

        public final void setMaintenanceId(String maintenanceId) {
            this.maintenanceId = maintenanceId;
        }

        @Override
        public final Builder maintenanceId(String maintenanceId) {
            this.maintenanceId = maintenanceId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(MaintenanceType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DomainMaintenanceDetails build() {
            return new DomainMaintenanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
