/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>GetDomainMaintenanceStatus</code> request that information about the requested action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainMaintenanceStatusResponse extends OpenSearchResponse implements
        ToCopyableBuilder<GetDomainMaintenanceStatusResponse.Builder, GetDomainMaintenanceStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDomainMaintenanceStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetDomainMaintenanceStatusResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(GetDomainMaintenanceStatusResponse::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(GetDomainMaintenanceStatusResponse::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetDomainMaintenanceStatusResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(GetDomainMaintenanceStatusResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_MESSAGE_FIELD, NODE_ID_FIELD, ACTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private final String status;

    private final String statusMessage;

    private final String nodeId;

    private final String action;

    private final Instant createdAt;

    private final Instant updatedAt;

    private GetDomainMaintenanceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.nodeId = builder.nodeId;
        this.action = builder.action;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The status of the maintenance action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the maintenance action.
     * @see MaintenanceStatus
     */
    public final MaintenanceStatus status() {
        return MaintenanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the maintenance action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the maintenance action.
     * @see MaintenanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the maintenance action.
     * </p>
     * 
     * @return The status message of the maintenance action.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The node ID of the maintenance action.
     * </p>
     * 
     * @return The node ID of the maintenance action.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The action name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link MaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action name.
     * @see MaintenanceType
     */
    public final MaintenanceType action() {
        return MaintenanceType.fromValue(action);
    }

    /**
     * <p>
     * The action name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link MaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action name.
     * @see MaintenanceType
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The time at which the action was created.
     * </p>
     * 
     * @return The time at which the action was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which the action was updated.
     * </p>
     * 
     * @return The time at which the action was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainMaintenanceStatusResponse)) {
            return false;
        }
        GetDomainMaintenanceStatusResponse other = (GetDomainMaintenanceStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(nodeId(), other.nodeId()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDomainMaintenanceStatusResponse").add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("NodeId", nodeId()).add("Action", actionAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainMaintenanceStatusResponse, T> g) {
        return obj -> g.apply((GetDomainMaintenanceStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainMaintenanceStatusResponse> {
        /**
         * <p>
         * The status of the maintenance action.
         * </p>
         * 
         * @param status
         *        The status of the maintenance action.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the maintenance action.
         * </p>
         * 
         * @param status
         *        The status of the maintenance action.
         * @see MaintenanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceStatus
         */
        Builder status(MaintenanceStatus status);

        /**
         * <p>
         * The status message of the maintenance action.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The node ID of the maintenance action.
         * </p>
         * 
         * @param nodeId
         *        The node ID of the maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The action name.
         * </p>
         * 
         * @param action
         *        The action name.
         * @see MaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceType
         */
        Builder action(String action);

        /**
         * <p>
         * The action name.
         * </p>
         * 
         * @param action
         *        The action name.
         * @see MaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceType
         */
        Builder action(MaintenanceType action);

        /**
         * <p>
         * The time at which the action was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the action was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which the action was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the action was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String status;

        private String statusMessage;

        private String nodeId;

        private String action;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainMaintenanceStatusResponse model) {
            super(model);
            status(model.status);
            statusMessage(model.statusMessage);
            nodeId(model.nodeId);
            action(model.action);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(MaintenanceType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDomainMaintenanceStatusResponse build() {
            return new GetDomainMaintenanceStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
