/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for results from <code>DescribeReservedInstances</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstancesResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeReservedInstancesResponse.Builder, DescribeReservedInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReservedInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ReservedInstance>> RESERVED_INSTANCES_FIELD = SdkField
            .<List<ReservedInstance>> builder(MarshallingType.LIST)
            .memberName("ReservedInstances")
            .getter(getter(DescribeReservedInstancesResponse::reservedInstances))
            .setter(setter(Builder::reservedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservedInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVED_INSTANCES_FIELD));

    private final String nextToken;

    private final List<ReservedInstance> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstances = builder.reservedInstances;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedInstances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReservedInstances() {
        return reservedInstances != null && !(reservedInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Reserved Instances in the current Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedInstances} method.
     * </p>
     * 
     * @return List of Reserved Instances in the current Region.
     */
    public final List<ReservedInstance> reservedInstances() {
        return reservedInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstances() ? reservedInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReservedInstances() == other.hasReservedInstances()
                && Objects.equals(reservedInstances(), other.reservedInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedInstancesResponse").add("NextToken", nextToken())
                .add("ReservedInstances", hasReservedInstances() ? reservedInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReservedInstances":
            return Optional.ofNullable(clazz.cast(reservedInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of Reserved Instances in the current Region.
         * </p>
         * 
         * @param reservedInstances
         *        List of Reserved Instances in the current Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(Collection<ReservedInstance> reservedInstances);

        /**
         * <p>
         * List of Reserved Instances in the current Region.
         * </p>
         * 
         * @param reservedInstances
         *        List of Reserved Instances in the current Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(ReservedInstance... reservedInstances);

        /**
         * <p>
         * List of Reserved Instances in the current Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.ReservedInstance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opensearch.model.ReservedInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.ReservedInstance.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedInstances(List<ReservedInstance>)}.
         * 
         * @param reservedInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.ReservedInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstances(java.util.Collection<ReservedInstance>)
         */
        Builder reservedInstances(Consumer<ReservedInstance.Builder>... reservedInstances);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedInstance> reservedInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservedInstances(model.reservedInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedInstance.Builder> getReservedInstances() {
            List<ReservedInstance.Builder> result = ReservedInstanceListCopier.copyToBuilder(this.reservedInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstances(Collection<ReservedInstance.BuilderImpl> reservedInstances) {
            this.reservedInstances = ReservedInstanceListCopier.copyFromBuilder(reservedInstances);
        }

        @Override
        public final Builder reservedInstances(Collection<ReservedInstance> reservedInstances) {
            this.reservedInstances = ReservedInstanceListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstance... reservedInstances) {
            reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(Consumer<ReservedInstance.Builder>... reservedInstances) {
            reservedInstances(Stream.of(reservedInstances).map(c -> ReservedInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
