/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnnotationStoreVersionResponse extends OmicsResponse implements
        ToCopyableBuilder<UpdateAnnotationStoreVersionResponse.Builder, UpdateAnnotationStoreVersionResponse> {
    private static final SdkField<String> STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeId").getter(getter(UpdateAnnotationStoreVersionResponse::storeId)).setter(setter(Builder::storeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateAnnotationStoreVersionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateAnnotationStoreVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAnnotationStoreVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(UpdateAnnotationStoreVersionResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAnnotationStoreVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(UpdateAnnotationStoreVersionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(UpdateAnnotationStoreVersionResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORE_ID_FIELD, ID_FIELD,
            STATUS_FIELD, NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD));

    private final String storeId;

    private final String id;

    private final String status;

    private final String name;

    private final String versionName;

    private final String description;

    private final Instant creationTime;

    private final Instant updateTime;

    private UpdateAnnotationStoreVersionResponse(BuilderImpl builder) {
        super(builder);
        this.storeId = builder.storeId;
        this.id = builder.id;
        this.status = builder.status;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The annotation store ID.
     * </p>
     * 
     * @return The annotation store ID.
     */
    public final String storeId() {
        return storeId;
    }

    /**
     * <p>
     * The annotation store version ID.
     * </p>
     * 
     * @return The annotation store version ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an annotation store version.
     * @see VersionStatus
     */
    public final VersionStatus status() {
        return VersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an annotation store version.
     * @see VersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of an annotation store.
     * </p>
     * 
     * @return The name of an annotation store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of an annotation store version.
     * </p>
     * 
     * @return The name of an annotation store version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The description of an annotation store version.
     * </p>
     * 
     * @return The description of an annotation store version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time stamp for when an annotation store version was created.
     * </p>
     * 
     * @return The time stamp for when an annotation store version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time stamp for when an annotation store version was updated.
     * </p>
     * 
     * @return The time stamp for when an annotation store version was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storeId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnnotationStoreVersionResponse)) {
            return false;
        }
        UpdateAnnotationStoreVersionResponse other = (UpdateAnnotationStoreVersionResponse) obj;
        return Objects.equals(storeId(), other.storeId()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(description(), other.description())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnnotationStoreVersionResponse").add("StoreId", storeId()).add("Id", id())
                .add("Status", statusAsString()).add("Name", name()).add("VersionName", versionName())
                .add("Description", description()).add("CreationTime", creationTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storeId":
            return Optional.ofNullable(clazz.cast(storeId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnnotationStoreVersionResponse, T> g) {
        return obj -> g.apply((UpdateAnnotationStoreVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAnnotationStoreVersionResponse> {
        /**
         * <p>
         * The annotation store ID.
         * </p>
         * 
         * @param storeId
         *        The annotation store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeId(String storeId);

        /**
         * <p>
         * The annotation store version ID.
         * </p>
         * 
         * @param id
         *        The annotation store version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of an annotation store version.
         * </p>
         * 
         * @param status
         *        The status of an annotation store version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of an annotation store version.
         * </p>
         * 
         * @param status
         *        The status of an annotation store version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder status(VersionStatus status);

        /**
         * <p>
         * The name of an annotation store.
         * </p>
         * 
         * @param name
         *        The name of an annotation store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of an annotation store version.
         * </p>
         * 
         * @param versionName
         *        The name of an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The description of an annotation store version.
         * </p>
         * 
         * @param description
         *        The description of an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time stamp for when an annotation store version was created.
         * </p>
         * 
         * @param creationTime
         *        The time stamp for when an annotation store version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time stamp for when an annotation store version was updated.
         * </p>
         * 
         * @param updateTime
         *        The time stamp for when an annotation store version was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String storeId;

        private String id;

        private String status;

        private String name;

        private String versionName;

        private String description;

        private Instant creationTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnnotationStoreVersionResponse model) {
            super(model);
            storeId(model.storeId);
            id(model.id);
            status(model.status);
            name(model.name);
            versionName(model.versionName);
            description(model.description);
            creationTime(model.creationTime);
            updateTime(model.updateTime);
        }

        public final String getStoreId() {
            return storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateAnnotationStoreVersionResponse build() {
            return new UpdateAnnotationStoreVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
