/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A genome reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceItem implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceItem.Builder, ReferenceItem> {
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceArn").getter(getter(ReferenceItem::referenceArn)).setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String referenceArn;

    private final Type type;

    private ReferenceItem(BuilderImpl builder) {
        this.referenceArn = builder.referenceArn;
        this.type = builder.type;
    }

    /**
     * <p>
     * The reference's ARN.
     * </p>
     * 
     * @return The reference's ARN.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceItem)) {
            return false;
        }
        ReferenceItem other = (ReferenceItem) obj;
        return Objects.equals(referenceArn(), other.referenceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceItem").add("ReferenceArn", referenceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "referenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #referenceArn()} initialized to the given value.
     *
     * <p>
     * The reference's ARN.
     * </p>
     * 
     * @param referenceArn
     *        The reference's ARN.
     */
    public static ReferenceItem fromReferenceArn(String referenceArn) {
        return builder().referenceArn(referenceArn).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceItem, T> g) {
        return obj -> g.apply((ReferenceItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceItem> {
        /**
         * <p>
         * The reference's ARN.
         * </p>
         * 
         * @param referenceArn
         *        The reference's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);
    }

    static final class BuilderImpl implements Builder {
        private String referenceArn;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceItem model) {
            referenceArn(model.referenceArn);
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            Object oldValue = this.referenceArn;
            this.referenceArn = referenceArn;
            handleUnionValueChange(Type.REFERENCE_ARN, oldValue, this.referenceArn);
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            Object oldValue = this.referenceArn;
            this.referenceArn = referenceArn;
            handleUnionValueChange(Type.REFERENCE_ARN, oldValue, this.referenceArn);
            return this;
        }

        @Override
        public ReferenceItem build() {
            return new ReferenceItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReferenceItem#type()
     */
    public enum Type {
        REFERENCE_ARN,

        UNKNOWN_TO_SDK_VERSION
    }
}
