/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnnotationStoreVersionsResponse extends OmicsResponse implements
        ToCopyableBuilder<ListAnnotationStoreVersionsResponse.Builder, ListAnnotationStoreVersionsResponse> {
    private static final SdkField<List<AnnotationStoreVersionItem>> ANNOTATION_STORE_VERSIONS_FIELD = SdkField
            .<List<AnnotationStoreVersionItem>> builder(MarshallingType.LIST)
            .memberName("annotationStoreVersions")
            .getter(getter(ListAnnotationStoreVersionsResponse::annotationStoreVersions))
            .setter(setter(Builder::annotationStoreVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationStoreVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnnotationStoreVersionItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnnotationStoreVersionItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAnnotationStoreVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANNOTATION_STORE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AnnotationStoreVersionItem> annotationStoreVersions;

    private final String nextToken;

    private ListAnnotationStoreVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.annotationStoreVersions = builder.annotationStoreVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnnotationStoreVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAnnotationStoreVersions() {
        return annotationStoreVersions != null && !(annotationStoreVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all versions of an annotation store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotationStoreVersions} method.
     * </p>
     * 
     * @return Lists all versions of an annotation store.
     */
    public final List<AnnotationStoreVersionItem> annotationStoreVersions() {
        return annotationStoreVersions;
    }

    /**
     * <p>
     * Specifies the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specifies the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotationStoreVersions() ? annotationStoreVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnnotationStoreVersionsResponse)) {
            return false;
        }
        ListAnnotationStoreVersionsResponse other = (ListAnnotationStoreVersionsResponse) obj;
        return hasAnnotationStoreVersions() == other.hasAnnotationStoreVersions()
                && Objects.equals(annotationStoreVersions(), other.annotationStoreVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnnotationStoreVersionsResponse")
                .add("AnnotationStoreVersions", hasAnnotationStoreVersions() ? annotationStoreVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "annotationStoreVersions":
            return Optional.ofNullable(clazz.cast(annotationStoreVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnnotationStoreVersionsResponse, T> g) {
        return obj -> g.apply((ListAnnotationStoreVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnnotationStoreVersionsResponse> {
        /**
         * <p>
         * Lists all versions of an annotation store.
         * </p>
         * 
         * @param annotationStoreVersions
         *        Lists all versions of an annotation store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationStoreVersions(Collection<AnnotationStoreVersionItem> annotationStoreVersions);

        /**
         * <p>
         * Lists all versions of an annotation store.
         * </p>
         * 
         * @param annotationStoreVersions
         *        Lists all versions of an annotation store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationStoreVersions(AnnotationStoreVersionItem... annotationStoreVersions);

        /**
         * <p>
         * Lists all versions of an annotation store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem.Builder#build()} is called
         * immediately and its result is passed to {@link #annotationStoreVersions(List<AnnotationStoreVersionItem>)}.
         * 
         * @param annotationStoreVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.AnnotationStoreVersionItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotationStoreVersions(java.util.Collection<AnnotationStoreVersionItem>)
         */
        Builder annotationStoreVersions(Consumer<AnnotationStoreVersionItem.Builder>... annotationStoreVersions);

        /**
         * <p>
         * Specifies the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private List<AnnotationStoreVersionItem> annotationStoreVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnnotationStoreVersionsResponse model) {
            super(model);
            annotationStoreVersions(model.annotationStoreVersions);
            nextToken(model.nextToken);
        }

        public final List<AnnotationStoreVersionItem.Builder> getAnnotationStoreVersions() {
            List<AnnotationStoreVersionItem.Builder> result = AnnotationStoreVersionItemsCopier
                    .copyToBuilder(this.annotationStoreVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotationStoreVersions(Collection<AnnotationStoreVersionItem.BuilderImpl> annotationStoreVersions) {
            this.annotationStoreVersions = AnnotationStoreVersionItemsCopier.copyFromBuilder(annotationStoreVersions);
        }

        @Override
        public final Builder annotationStoreVersions(Collection<AnnotationStoreVersionItem> annotationStoreVersions) {
            this.annotationStoreVersions = AnnotationStoreVersionItemsCopier.copy(annotationStoreVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationStoreVersions(AnnotationStoreVersionItem... annotationStoreVersions) {
            annotationStoreVersions(Arrays.asList(annotationStoreVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationStoreVersions(Consumer<AnnotationStoreVersionItem.Builder>... annotationStoreVersions) {
            annotationStoreVersions(Stream.of(annotationStoreVersions)
                    .map(c -> AnnotationStoreVersionItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnnotationStoreVersionsResponse build() {
            return new ListAnnotationStoreVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
