/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReadSetImportJobsResponse extends OmicsResponse implements
        ToCopyableBuilder<ListReadSetImportJobsResponse.Builder, ListReadSetImportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReadSetImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ImportReadSetJobItem>> IMPORT_JOBS_FIELD = SdkField
            .<List<ImportReadSetJobItem>> builder(MarshallingType.LIST)
            .memberName("importJobs")
            .getter(getter(ListReadSetImportJobsResponse::importJobs))
            .setter(setter(Builder::importJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportReadSetJobItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportReadSetJobItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            IMPORT_JOBS_FIELD));

    private final String nextToken;

    private final List<ImportReadSetJobItem> importJobs;

    private ListReadSetImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.importJobs = builder.importJobs;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImportJobs() {
        return importJobs != null && !(importJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportJobs} method.
     * </p>
     * 
     * @return A list of jobs.
     */
    public final List<ImportReadSetJobItem> importJobs() {
        return importJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasImportJobs() ? importJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetImportJobsResponse)) {
            return false;
        }
        ListReadSetImportJobsResponse other = (ListReadSetImportJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasImportJobs() == other.hasImportJobs()
                && Objects.equals(importJobs(), other.importJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReadSetImportJobsResponse").add("NextToken", nextToken())
                .add("ImportJobs", hasImportJobs() ? importJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "importJobs":
            return Optional.ofNullable(clazz.cast(importJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetImportJobsResponse, T> g) {
        return obj -> g.apply((ListReadSetImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReadSetImportJobsResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param importJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobs(Collection<ImportReadSetJobItem> importJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param importJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobs(ImportReadSetJobItem... importJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.ImportReadSetJobItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.omics.model.ImportReadSetJobItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.ImportReadSetJobItem.Builder#build()} is called
         * immediately and its result is passed to {@link #importJobs(List<ImportReadSetJobItem>)}.
         * 
         * @param importJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.ImportReadSetJobItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJobs(java.util.Collection<ImportReadSetJobItem>)
         */
        Builder importJobs(Consumer<ImportReadSetJobItem.Builder>... importJobs);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ImportReadSetJobItem> importJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetImportJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            importJobs(model.importJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImportReadSetJobItem.Builder> getImportJobs() {
            List<ImportReadSetJobItem.Builder> result = ImportReadSetJobListCopier.copyToBuilder(this.importJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobs(Collection<ImportReadSetJobItem.BuilderImpl> importJobs) {
            this.importJobs = ImportReadSetJobListCopier.copyFromBuilder(importJobs);
        }

        @Override
        public final Builder importJobs(Collection<ImportReadSetJobItem> importJobs) {
            this.importJobs = ImportReadSetJobListCopier.copy(importJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(ImportReadSetJobItem... importJobs) {
            importJobs(Arrays.asList(importJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(Consumer<ImportReadSetJobItem.Builder>... importJobs) {
            importJobs(Stream.of(importJobs).map(c -> ImportReadSetJobItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetImportJobsResponse build() {
            return new ListReadSetImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
