/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.EulaIdListCopier;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptEulasRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, AcceptEulasRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AcceptEulasRequest.getter(AcceptEulasRequest::clientToken)).setter(AcceptEulasRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<String>> EULA_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eulaIds").getter(AcceptEulasRequest.getter(AcceptEulasRequest::eulaIds)).setter(AcceptEulasRequest.setter(Builder::eulaIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(AcceptEulasRequest.getter(AcceptEulasRequest::studioId)).setter(AcceptEulasRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EULA_IDS_FIELD, STUDIO_ID_FIELD));
    private final String clientToken;
    private final List<String> eulaIds;
    private final String studioId;

    private AcceptEulasRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.eulaIds = builder.eulaIds;
        this.studioId = builder.studioId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasEulaIds() {
        return this.eulaIds != null && !(this.eulaIds instanceof SdkAutoConstructList);
    }

    public final List<String> eulaIds() {
        return this.eulaIds;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEulaIds() ? this.eulaIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptEulasRequest)) {
            return false;
        }
        AcceptEulasRequest other = (AcceptEulasRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && this.hasEulaIds() == other.hasEulaIds() && Objects.equals(this.eulaIds(), other.eulaIds()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptEulasRequest").add("ClientToken", (Object)this.clientToken()).add("EulaIds", this.hasEulaIds() ? this.eulaIds() : null).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "eulaIds": {
                return Optional.ofNullable(clazz.cast(this.eulaIds()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptEulasRequest, T> g) {
        return obj -> g.apply((AcceptEulasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<String> eulaIds = DefaultSdkAutoConstructList.getInstance();
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptEulasRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.eulaIds(model.eulaIds);
            this.studioId(model.studioId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getEulaIds() {
            if (this.eulaIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eulaIds;
        }

        public final void setEulaIds(Collection<String> eulaIds) {
            this.eulaIds = EulaIdListCopier.copy(eulaIds);
        }

        @Override
        public final Builder eulaIds(Collection<String> eulaIds) {
            this.eulaIds = EulaIdListCopier.copy(eulaIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulaIds(String ... eulaIds) {
            this.eulaIds(Arrays.asList(eulaIds));
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptEulasRequest build() {
            return new AcceptEulasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptEulasRequest> {
        public Builder clientToken(String var1);

        public Builder eulaIds(Collection<String> var1);

        public Builder eulaIds(String ... var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

