/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The launch profile validation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationResult.Builder, ValidationResult> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ValidationResult::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(ValidationResult::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(ValidationResult::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ValidationResult::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String statusCodeValue;

    private final String statusMessage;

    private final String type;

    private ValidationResult(BuilderImpl builder) {
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.type = builder.type;
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LaunchProfileValidationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see LaunchProfileValidationState
     */
    public final LaunchProfileValidationState state() {
        return LaunchProfileValidationState.fromValue(state);
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LaunchProfileValidationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see LaunchProfileValidationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link LaunchProfileValidationStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
     * @see LaunchProfileValidationStatusCode
     */
    public final LaunchProfileValidationStatusCode statusCode() {
        return LaunchProfileValidationStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link LaunchProfileValidationStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
     * @see LaunchProfileValidationStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The status message for the validation result.
     * </p>
     * 
     * @return The status message for the validation result.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The type of the validation result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LaunchProfileValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the validation result.
     * @see LaunchProfileValidationType
     */
    public final LaunchProfileValidationType type() {
        return LaunchProfileValidationType.fromValue(type);
    }

    /**
     * <p>
     * The type of the validation result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LaunchProfileValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the validation result.
     * @see LaunchProfileValidationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationResult").add("State", stateAsString()).add("StatusCode", statusCodeAsString())
                .add("StatusMessage", statusMessage()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationResult, T> g) {
        return obj -> g.apply((ValidationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationResult> {
        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see LaunchProfileValidationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfileValidationState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see LaunchProfileValidationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfileValidationState
         */
        Builder state(LaunchProfileValidationState state);

        /**
         * <p>
         * The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
         * @see LaunchProfileValidationStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfileValidationStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code. This will contain the failure reason if the state is <code>VALIDATION_FAILED</code>.
         * @see LaunchProfileValidationStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfileValidationStatusCode
         */
        Builder statusCode(LaunchProfileValidationStatusCode statusCodeValue);

        /**
         * <p>
         * The status message for the validation result.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the validation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The type of the validation result.
         * </p>
         * 
         * @param type
         *        The type of the validation result.
         * @see LaunchProfileValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfileValidationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the validation result.
         * </p>
         * 
         * @param type
         *        The type of the validation result.
         * @see LaunchProfileValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfileValidationType
         */
        Builder type(LaunchProfileValidationType type);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String statusCodeValue;

        private String statusMessage;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationResult model) {
            state(model.state);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
            type(model.type);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LaunchProfileValidationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(LaunchProfileValidationStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LaunchProfileValidationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ValidationResult build() {
            return new ValidationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
