/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue;
import software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration;
import software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript;
import software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentScriptParameterKeyValueListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentSecurityGroupIdListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentState;
import software.amazon.awssdk.services.nimble.model.StudioComponentStatusCode;
import software.amazon.awssdk.services.nimble.model.StudioComponentSubtype;
import software.amazon.awssdk.services.nimble.model.StudioComponentType;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StudioComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StudioComponent> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(StudioComponent.getter(StudioComponent::arn)).setter(StudioComponent.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<StudioComponentConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(StudioComponent.getter(StudioComponent::configuration)).setter(StudioComponent.setter(Builder::configuration)).constructor(StudioComponentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StudioComponent.getter(StudioComponent::createdAt)).setter(StudioComponent.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(StudioComponent.getter(StudioComponent::createdBy)).setter(StudioComponent.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StudioComponent.getter(StudioComponent::description)).setter(StudioComponent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EC2_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2SecurityGroupIds").getter(StudioComponent.getter(StudioComponent::ec2SecurityGroupIds)).setter(StudioComponent.setter(Builder::ec2SecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StudioComponentInitializationScript>> INITIALIZATION_SCRIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("initializationScripts").getter(StudioComponent.getter(StudioComponent::initializationScripts)).setter(StudioComponent.setter(Builder::initializationScripts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScripts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StudioComponentInitializationScript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StudioComponent.getter(StudioComponent::name)).setter(StudioComponent.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeRoleArn").getter(StudioComponent.getter(StudioComponent::runtimeRoleArn)).setter(StudioComponent.setter(Builder::runtimeRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeRoleArn").build()}).build();
    private static final SdkField<List<ScriptParameterKeyValue>> SCRIPT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scriptParameters").getter(StudioComponent.getter(StudioComponent::scriptParameters)).setter(StudioComponent.setter(Builder::scriptParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScriptParameterKeyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURE_INITIALIZATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secureInitializationRoleArn").getter(StudioComponent.getter(StudioComponent::secureInitializationRoleArn)).setter(StudioComponent.setter(Builder::secureInitializationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secureInitializationRoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(StudioComponent.getter(StudioComponent::stateAsString)).setter(StudioComponent.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(StudioComponent.getter(StudioComponent::statusCodeAsString)).setter(StudioComponent.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(StudioComponent.getter(StudioComponent::statusMessage)).setter(StudioComponent.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioComponentId").getter(StudioComponent.getter(StudioComponent::studioComponentId)).setter(StudioComponent.setter(Builder::studioComponentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentId").build()}).build();
    private static final SdkField<String> SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtype").getter(StudioComponent.getter(StudioComponent::subtypeAsString)).setter(StudioComponent.setter(Builder::subtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtype").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StudioComponent.getter(StudioComponent::tags)).setter(StudioComponent.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StudioComponent.getter(StudioComponent::typeAsString)).setter(StudioComponent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(StudioComponent.getter(StudioComponent::updatedAt)).setter(StudioComponent.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(StudioComponent.getter(StudioComponent::updatedBy)).setter(StudioComponent.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONFIGURATION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUP_IDS_FIELD, INITIALIZATION_SCRIPTS_FIELD, NAME_FIELD, RUNTIME_ROLE_ARN_FIELD, SCRIPT_PARAMETERS_FIELD, SECURE_INITIALIZATION_ROLE_ARN_FIELD, STATE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STUDIO_COMPONENT_ID_FIELD, SUBTYPE_FIELD, TAGS_FIELD, TYPE_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final StudioComponentConfiguration configuration;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final List<String> ec2SecurityGroupIds;
    private final List<StudioComponentInitializationScript> initializationScripts;
    private final String name;
    private final String runtimeRoleArn;
    private final List<ScriptParameterKeyValue> scriptParameters;
    private final String secureInitializationRoleArn;
    private final String state;
    private final String statusCodeValue;
    private final String statusMessage;
    private final String studioComponentId;
    private final String subtype;
    private final Map<String, String> tags;
    private final String type;
    private final Instant updatedAt;
    private final String updatedBy;

    private StudioComponent(BuilderImpl builder) {
        this.arn = builder.arn;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
        this.initializationScripts = builder.initializationScripts;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.scriptParameters = builder.scriptParameters;
        this.secureInitializationRoleArn = builder.secureInitializationRoleArn;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.studioComponentId = builder.studioComponentId;
        this.subtype = builder.subtype;
        this.tags = builder.tags;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final String arn() {
        return this.arn;
    }

    public final StudioComponentConfiguration configuration() {
        return this.configuration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEc2SecurityGroupIds() {
        return this.ec2SecurityGroupIds != null && !(this.ec2SecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2SecurityGroupIds() {
        return this.ec2SecurityGroupIds;
    }

    public final boolean hasInitializationScripts() {
        return this.initializationScripts != null && !(this.initializationScripts instanceof SdkAutoConstructList);
    }

    public final List<StudioComponentInitializationScript> initializationScripts() {
        return this.initializationScripts;
    }

    public final String name() {
        return this.name;
    }

    public final String runtimeRoleArn() {
        return this.runtimeRoleArn;
    }

    public final boolean hasScriptParameters() {
        return this.scriptParameters != null && !(this.scriptParameters instanceof SdkAutoConstructList);
    }

    public final List<ScriptParameterKeyValue> scriptParameters() {
        return this.scriptParameters;
    }

    public final String secureInitializationRoleArn() {
        return this.secureInitializationRoleArn;
    }

    public final StudioComponentState state() {
        return StudioComponentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StudioComponentStatusCode statusCode() {
        return StudioComponentStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String studioComponentId() {
        return this.studioComponentId;
    }

    public final StudioComponentSubtype subtype() {
        return StudioComponentSubtype.fromValue(this.subtype);
    }

    public final String subtypeAsString() {
        return this.subtype;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final StudioComponentType type() {
        return StudioComponentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SecurityGroupIds() ? this.ec2SecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitializationScripts() ? this.initializationScripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScriptParameters() ? this.scriptParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secureInitializationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioComponent)) {
            return false;
        }
        StudioComponent other = (StudioComponent)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && this.hasEc2SecurityGroupIds() == other.hasEc2SecurityGroupIds() && Objects.equals(this.ec2SecurityGroupIds(), other.ec2SecurityGroupIds()) && this.hasInitializationScripts() == other.hasInitializationScripts() && Objects.equals(this.initializationScripts(), other.initializationScripts()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.runtimeRoleArn(), other.runtimeRoleArn()) && this.hasScriptParameters() == other.hasScriptParameters() && Objects.equals(this.scriptParameters(), other.scriptParameters()) && Objects.equals(this.secureInitializationRoleArn(), other.secureInitializationRoleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.studioComponentId(), other.studioComponentId()) && Objects.equals(this.subtypeAsString(), other.subtypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"StudioComponent").add("Arn", (Object)this.arn()).add("Configuration", (Object)this.configuration()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Ec2SecurityGroupIds", this.hasEc2SecurityGroupIds() ? this.ec2SecurityGroupIds() : null).add("InitializationScripts", this.hasInitializationScripts() ? this.initializationScripts() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("RuntimeRoleArn", (Object)this.runtimeRoleArn()).add("ScriptParameters", (Object)(this.scriptParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("SecureInitializationRoleArn", (Object)this.secureInitializationRoleArn()).add("State", (Object)this.stateAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StudioComponentId", (Object)this.studioComponentId()).add("Subtype", (Object)this.subtypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ec2SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupIds()));
            }
            case "initializationScripts": {
                return Optional.ofNullable(clazz.cast(this.initializationScripts()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "runtimeRoleArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeRoleArn()));
            }
            case "scriptParameters": {
                return Optional.ofNullable(clazz.cast(this.scriptParameters()));
            }
            case "secureInitializationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secureInitializationRoleArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "studioComponentId": {
                return Optional.ofNullable(clazz.cast(this.studioComponentId()));
            }
            case "subtype": {
                return Optional.ofNullable(clazz.cast(this.subtypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioComponent, T> g) {
        return obj -> g.apply((StudioComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private StudioComponentConfiguration configuration;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private List<String> ec2SecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<StudioComponentInitializationScript> initializationScripts = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String runtimeRoleArn;
        private List<ScriptParameterKeyValue> scriptParameters = DefaultSdkAutoConstructList.getInstance();
        private String secureInitializationRoleArn;
        private String state;
        private String statusCodeValue;
        private String statusMessage;
        private String studioComponentId;
        private String subtype;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioComponent model) {
            this.arn(model.arn);
            this.configuration(model.configuration);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.ec2SecurityGroupIds(model.ec2SecurityGroupIds);
            this.initializationScripts(model.initializationScripts);
            this.name(model.name);
            this.runtimeRoleArn(model.runtimeRoleArn);
            this.scriptParameters(model.scriptParameters);
            this.secureInitializationRoleArn(model.secureInitializationRoleArn);
            this.state(model.state);
            this.statusCode(model.statusCodeValue);
            this.statusMessage(model.statusMessage);
            this.studioComponentId(model.studioComponentId);
            this.subtype(model.subtype);
            this.tags(model.tags);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final StudioComponentConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(StudioComponentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(StudioComponentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SecurityGroupIds() {
            if (this.ec2SecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2SecurityGroupIds;
        }

        public final void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
        }

        @Override
        public final Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroupIds(String ... ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds(Arrays.asList(ec2SecurityGroupIds));
            return this;
        }

        public final List<StudioComponentInitializationScript.Builder> getInitializationScripts() {
            List<StudioComponentInitializationScript.Builder> result = StudioComponentInitializationScriptListCopier.copyToBuilder(this.initializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitializationScripts(Collection<StudioComponentInitializationScript.BuilderImpl> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copyFromBuilder(initializationScripts);
        }

        @Override
        public final Builder initializationScripts(Collection<StudioComponentInitializationScript> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copy(initializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initializationScripts(StudioComponentInitializationScript ... initializationScripts) {
            this.initializationScripts(Arrays.asList(initializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder> ... initializationScripts) {
            this.initializationScripts(Stream.of(initializationScripts).map(c -> (StudioComponentInitializationScript)((StudioComponentInitializationScript.Builder)StudioComponentInitializationScript.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return this.runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final List<ScriptParameterKeyValue.Builder> getScriptParameters() {
            List<ScriptParameterKeyValue.Builder> result = StudioComponentScriptParameterKeyValueListCopier.copyToBuilder(this.scriptParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScriptParameters(Collection<ScriptParameterKeyValue.BuilderImpl> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copyFromBuilder(scriptParameters);
        }

        @Override
        public final Builder scriptParameters(Collection<ScriptParameterKeyValue> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copy(scriptParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptParameters(ScriptParameterKeyValue ... scriptParameters) {
            this.scriptParameters(Arrays.asList(scriptParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder> ... scriptParameters) {
            this.scriptParameters(Stream.of(scriptParameters).map(c -> (ScriptParameterKeyValue)((ScriptParameterKeyValue.Builder)ScriptParameterKeyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSecureInitializationRoleArn() {
            return this.secureInitializationRoleArn;
        }

        public final void setSecureInitializationRoleArn(String secureInitializationRoleArn) {
            this.secureInitializationRoleArn = secureInitializationRoleArn;
        }

        @Override
        public final Builder secureInitializationRoleArn(String secureInitializationRoleArn) {
            this.secureInitializationRoleArn = secureInitializationRoleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StudioComponentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(StudioComponentStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStudioComponentId() {
            return this.studioComponentId;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final String getSubtype() {
            return this.subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(StudioComponentSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StudioComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public StudioComponent build() {
            return new StudioComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StudioComponent> {
        public Builder arn(String var1);

        public Builder configuration(StudioComponentConfiguration var1);

        default public Builder configuration(Consumer<StudioComponentConfiguration.Builder> configuration) {
            return this.configuration((StudioComponentConfiguration)((StudioComponentConfiguration.Builder)StudioComponentConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder ec2SecurityGroupIds(Collection<String> var1);

        public Builder ec2SecurityGroupIds(String ... var1);

        public Builder initializationScripts(Collection<StudioComponentInitializationScript> var1);

        public Builder initializationScripts(StudioComponentInitializationScript ... var1);

        public Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder> ... var1);

        public Builder name(String var1);

        public Builder runtimeRoleArn(String var1);

        public Builder scriptParameters(Collection<ScriptParameterKeyValue> var1);

        public Builder scriptParameters(ScriptParameterKeyValue ... var1);

        public Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder> ... var1);

        public Builder secureInitializationRoleArn(String var1);

        public Builder state(String var1);

        public Builder state(StudioComponentState var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StudioComponentStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder studioComponentId(String var1);

        public Builder subtype(String var1);

        public Builder subtype(StudioComponentSubtype var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(StudioComponentType var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

