/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.VolumeRetentionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopStreamingSessionRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, StopStreamingSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StopStreamingSessionRequest.getter(StopStreamingSessionRequest::clientToken)).setter(StopStreamingSessionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StopStreamingSessionRequest.getter(StopStreamingSessionRequest::sessionId)).setter(StopStreamingSessionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(StopStreamingSessionRequest.getter(StopStreamingSessionRequest::studioId)).setter(StopStreamingSessionRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final SdkField<String> VOLUME_RETENTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeRetentionMode").getter(StopStreamingSessionRequest.getter(StopStreamingSessionRequest::volumeRetentionModeAsString)).setter(StopStreamingSessionRequest.setter(Builder::volumeRetentionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeRetentionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, SESSION_ID_FIELD, STUDIO_ID_FIELD, VOLUME_RETENTION_MODE_FIELD));
    private final String clientToken;
    private final String sessionId;
    private final String studioId;
    private final String volumeRetentionMode;

    private StopStreamingSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.sessionId = builder.sessionId;
        this.studioId = builder.studioId;
        this.volumeRetentionMode = builder.volumeRetentionMode;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final VolumeRetentionMode volumeRetentionMode() {
        return VolumeRetentionMode.fromValue(this.volumeRetentionMode);
    }

    public final String volumeRetentionModeAsString() {
        return this.volumeRetentionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeRetentionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStreamingSessionRequest)) {
            return false;
        }
        StopStreamingSessionRequest other = (StopStreamingSessionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.volumeRetentionModeAsString(), other.volumeRetentionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StopStreamingSessionRequest").add("ClientToken", (Object)this.clientToken()).add("SessionId", (Object)this.sessionId()).add("StudioId", (Object)this.studioId()).add("VolumeRetentionMode", (Object)this.volumeRetentionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "volumeRetentionMode": {
                return Optional.ofNullable(clazz.cast(this.volumeRetentionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopStreamingSessionRequest, T> g) {
        return obj -> g.apply((StopStreamingSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String sessionId;
        private String studioId;
        private String volumeRetentionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStreamingSessionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.sessionId(model.sessionId);
            this.studioId(model.studioId);
            this.volumeRetentionMode(model.volumeRetentionMode);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getVolumeRetentionMode() {
            return this.volumeRetentionMode;
        }

        public final void setVolumeRetentionMode(String volumeRetentionMode) {
            this.volumeRetentionMode = volumeRetentionMode;
        }

        @Override
        public final Builder volumeRetentionMode(String volumeRetentionMode) {
            this.volumeRetentionMode = volumeRetentionMode;
            return this;
        }

        @Override
        public final Builder volumeRetentionMode(VolumeRetentionMode volumeRetentionMode) {
            this.volumeRetentionMode(volumeRetentionMode == null ? null : volumeRetentionMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopStreamingSessionRequest build() {
            return new StopStreamingSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopStreamingSessionRequest> {
        public Builder clientToken(String var1);

        public Builder sessionId(String var1);

        public Builder studioId(String var1);

        public Builder volumeRetentionMode(String var1);

        public Builder volumeRetentionMode(VolumeRetentionMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

