/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchProfilePlatform {
    LINUX("LINUX"),
    WINDOWS("WINDOWS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchProfilePlatform> VALUE_MAP;
    private final String value;

    private LaunchProfilePlatform(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchProfilePlatform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchProfilePlatform> knownValues() {
        EnumSet<LaunchProfilePlatform> knownValues = EnumSet.allOf(LaunchProfilePlatform.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchProfilePlatform.class, LaunchProfilePlatform::toString);
    }
}

