/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the associated Certificate Manager Secure Sockets Layer/Transport Layer Security (SSL/TLS) server
 * certificates and scope settings Network Firewall uses to decrypt traffic in a <a>TLSInspectionConfiguration</a>. For
 * information about working with SSL/TLS certificates for TLS inspection, see <a href=
 * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html">
 * Requirements for using SSL/TLS server certficiates with TLS inspection configurations</a> in the <i>Network Firewall
 * Developer Guide</i>.
 * </p>
 * <note>
 * <p>
 * If a server certificate that's associated with your <a>TLSInspectionConfiguration</a> is revoked, deleted, or expired
 * it can result in client-side TLS errors.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerCertificateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerCertificateConfiguration.Builder, ServerCertificateConfiguration> {
    private static final SdkField<List<ServerCertificate>> SERVER_CERTIFICATES_FIELD = SdkField
            .<List<ServerCertificate>> builder(MarshallingType.LIST)
            .memberName("ServerCertificates")
            .getter(getter(ServerCertificateConfiguration::serverCertificates))
            .setter(setter(Builder::serverCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServerCertificateScope>> SCOPES_FIELD = SdkField
            .<List<ServerCertificateScope>> builder(MarshallingType.LIST)
            .memberName("Scopes")
            .getter(getter(ServerCertificateConfiguration::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerCertificateScope> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerCertificateScope::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CERTIFICATES_FIELD,
            SCOPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ServerCertificate> serverCertificates;

    private final List<ServerCertificateScope> scopes;

    private ServerCertificateConfiguration(BuilderImpl builder) {
        this.serverCertificates = builder.serverCertificates;
        this.scopes = builder.scopes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerCertificates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerCertificates() {
        return serverCertificates != null && !(serverCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerCertificates} method.
     * </p>
     * 
     * @return The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
     */
    public final List<ServerCertificate> serverCertificates() {
        return serverCertificates;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of a server certificate configuration's scopes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return A list of a server certificate configuration's scopes.
     */
    public final List<ServerCertificateScope> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasServerCertificates() ? serverCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateConfiguration)) {
            return false;
        }
        ServerCertificateConfiguration other = (ServerCertificateConfiguration) obj;
        return hasServerCertificates() == other.hasServerCertificates()
                && Objects.equals(serverCertificates(), other.serverCertificates()) && hasScopes() == other.hasScopes()
                && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerCertificateConfiguration")
                .add("ServerCertificates", hasServerCertificates() ? serverCertificates() : null)
                .add("Scopes", hasScopes() ? scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificates":
            return Optional.ofNullable(clazz.cast(serverCertificates()));
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificateConfiguration, T> g) {
        return obj -> g.apply((ServerCertificateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerCertificateConfiguration> {
        /**
         * <p>
         * The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
         * </p>
         * 
         * @param serverCertificates
         *        The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificates(Collection<ServerCertificate> serverCertificates);

        /**
         * <p>
         * The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
         * </p>
         * 
         * @param serverCertificates
         *        The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificates(ServerCertificate... serverCertificates);

        /**
         * <p>
         * The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificate.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificate.Builder#build()} is called
         * immediately and its result is passed to {@link #serverCertificates(List<ServerCertificate>)}.
         * 
         * @param serverCertificates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificates(java.util.Collection<ServerCertificate>)
         */
        Builder serverCertificates(Consumer<ServerCertificate.Builder>... serverCertificates);

        /**
         * <p>
         * A list of a server certificate configuration's scopes.
         * </p>
         * 
         * @param scopes
         *        A list of a server certificate configuration's scopes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<ServerCertificateScope> scopes);

        /**
         * <p>
         * A list of a server certificate configuration's scopes.
         * </p>
         * 
         * @param scopes
         *        A list of a server certificate configuration's scopes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(ServerCertificateScope... scopes);

        /**
         * <p>
         * A list of a server certificate configuration's scopes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope.Builder#build()} is
         * called immediately and its result is passed to {@link #scopes(List<ServerCertificateScope>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.ServerCertificateScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(java.util.Collection<ServerCertificateScope>)
         */
        Builder scopes(Consumer<ServerCertificateScope.Builder>... scopes);
    }

    static final class BuilderImpl implements Builder {
        private List<ServerCertificate> serverCertificates = DefaultSdkAutoConstructList.getInstance();

        private List<ServerCertificateScope> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateConfiguration model) {
            serverCertificates(model.serverCertificates);
            scopes(model.scopes);
        }

        public final List<ServerCertificate.Builder> getServerCertificates() {
            List<ServerCertificate.Builder> result = ServerCertificatesCopier.copyToBuilder(this.serverCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerCertificates(Collection<ServerCertificate.BuilderImpl> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copyFromBuilder(serverCertificates);
        }

        @Override
        public final Builder serverCertificates(Collection<ServerCertificate> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copy(serverCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(ServerCertificate... serverCertificates) {
            serverCertificates(Arrays.asList(serverCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(Consumer<ServerCertificate.Builder>... serverCertificates) {
            serverCertificates(Stream.of(serverCertificates).map(c -> ServerCertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ServerCertificateScope.Builder> getScopes() {
            List<ServerCertificateScope.Builder> result = ServerCertificateScopesCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ServerCertificateScope.BuilderImpl> scopes) {
            this.scopes = ServerCertificateScopesCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ServerCertificateScope> scopes) {
            this.scopes = ServerCertificateScopesCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ServerCertificateScope... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ServerCertificateScope.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> ServerCertificateScope.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServerCertificateConfiguration build() {
            return new ServerCertificateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
