/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of port ranges for use in the rules in a rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortSet implements SdkPojo, Serializable, ToCopyableBuilder<PortSet.Builder, PortSet> {
    private static final SdkField<List<String>> DEFINITION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Definition")
            .getter(getter(PortSet::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> definition;

    private PortSet(BuilderImpl builder) {
        this.definition = builder.definition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Definition property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDefinition() {
        return definition != null && !(definition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of port ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefinition} method.
     * </p>
     * 
     * @return The set of port ranges.
     */
    public final List<String> definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDefinition() ? definition() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortSet)) {
            return false;
        }
        PortSet other = (PortSet) obj;
        return hasDefinition() == other.hasDefinition() && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortSet").add("Definition", hasDefinition() ? definition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortSet, T> g) {
        return obj -> g.apply((PortSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortSet> {
        /**
         * <p>
         * The set of port ranges.
         * </p>
         * 
         * @param definition
         *        The set of port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Collection<String> definition);

        /**
         * <p>
         * The set of port ranges.
         * </p>
         * 
         * @param definition
         *        The set of port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String... definition);
    }

    static final class BuilderImpl implements Builder {
        private List<String> definition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortSet model) {
            definition(model.definition);
        }

        public final Collection<String> getDefinition() {
            if (definition instanceof SdkAutoConstructList) {
                return null;
            }
            return definition;
        }

        public final void setDefinition(Collection<String> definition) {
            this.definition = VariableDefinitionListCopier.copy(definition);
        }

        @Override
        public final Builder definition(Collection<String> definition) {
            this.definition = VariableDefinitionListCopier.copy(definition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definition(String... definition) {
            definition(Arrays.asList(definition));
            return this;
        }

        @Override
        public PortSet build() {
            return new PortSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
